/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.GMFObservableList;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class AppliedCommentsObservableList
extends GMFObservableList {
    public AppliedCommentsObservableList(EditingDomain domain, Element source) {
        super(AppliedCommentsObservableList.getAppliedCommentsList(source), domain, (EObject)source, (EStructuralFeature)UMLPackage.eINSTANCE.getElement_OwnedComment());
    }

    private static List<Comment> getAppliedCommentsList(Element source) {
        LinkedList<Comment> result = new LinkedList<Comment>();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)source)) {
            if (setting.getEStructuralFeature() != UMLPackage.Literals.COMMENT__ANNOTATED_ELEMENT || !(setting.getEObject() instanceof Comment)) continue;
            Comment comment = (Comment)setting.getEObject();
            boolean isProxy = false;
            for (Element annotatedElement : comment.getAnnotatedElements()) {
                if (annotatedElement == source || annotatedElement.eResource() != null) continue;
                isProxy = true;
            }
            if (isProxy || !comment.getAnnotatedElements().contains((Object)source)) continue;
            result.add(comment);
        }
        return result;
    }

    protected void refreshCacheList() {
        if (this.isDisposed()) {
            return;
        }
        this.wrappedList.clear();
        this.wrappedList.addAll(AppliedCommentsObservableList.getAppliedCommentsList((Element)this.source));
        this.fireListChange(null);
    }

    public Command getAddCommand(Object value) {
        CompoundCommand addAppliedCommentCommand = null;
        if (value instanceof Comment) {
            addAppliedCommentCommand = new CompoundCommand("Add applied comment");
            SetRequest setRequest = new SetRequest((TransactionalEditingDomain)this.editingDomain, this.source, this.feature, value);
            addAppliedCommentCommand.append(this.getCommandFromRequests(this.getProvider(), Collections.singletonList(setRequest)));
            if (!((Comment)value).getAnnotatedElements().contains((Object)this.source)) {
                AddCommand addCommand = new AddCommand(this.editingDomain, (EObject)value, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_AnnotatedElement(), (Object)this.source);
                addAppliedCommentCommand.append((Command)addCommand);
            }
        }
        return addAppliedCommentCommand;
    }

    public Command getRemoveCommand(Object value) {
        Command removeAppliedCommentCommand = null;
        if (value instanceof Comment) {
            Comment comment = (Comment)value;
            if (comment.getAnnotatedElements().size() > 1) {
                LinkedList values = new LinkedList(comment.getAnnotatedElements());
                values.remove(this.source);
                SetRequest setRequest = new SetRequest((EObject)comment, (EStructuralFeature)UMLPackage.eINSTANCE.getComment_AnnotatedElement(), values);
                removeAppliedCommentCommand = this.getCommandFromRequests(this.getProvider(), Collections.singletonList(setRequest));
            } else {
                DestroyElementRequest detroyRequest = new DestroyElementRequest((TransactionalEditingDomain)this.editingDomain, (EObject)comment, false);
                removeAppliedCommentCommand = this.getCommandFromRequests(this.getProvider(), Collections.singleton(detroyRequest));
            }
        }
        return removeAppliedCommentCommand;
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        Iterator<?> itr = values.iterator();
        CompoundCommand removeAppliedCommentCommand = new CompoundCommand("Remove applied comment");
        while (itr.hasNext()) {
            Element value = (Element)itr.next();
            Assert.isTrue((boolean)(value instanceof Comment));
            removeAppliedCommentCommand.append(this.getRemoveCommand(value));
        }
        return removeAppliedCommentCommand;
    }

    public Command getClearCommand() {
        throw new UnsupportedOperationException();
    }

    public List<Command> getMoveCommands(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    public Command getRemoveCommand(int index) {
        throw new UnsupportedOperationException();
    }

    public Command getSetCommand(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Command getAddAllCommand(Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    public Command getAddAllCommand(int index, Collection<?> values) {
        throw new UnsupportedOperationException();
    }

    public Command getAddCommand(int index, Object value) {
        throw new UnsupportedOperationException();
    }
}

