/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckoutManager;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentModifier;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLabelProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutState;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutStateManager;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.OpenWithActionProvider;
import org.eclipse.emf.cdo.internal.ui.CDOContentProvider;
import org.eclipse.emf.cdo.internal.ui.RunnableViewerRefresh;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CDOCheckoutContentProvider
extends CDOContentProvider<CDOCheckout>
implements ICommonContentProvider,
IPropertySourceProvider,
IOpenListener {
    public static final String PROJECT_EXPLORER_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private static final Map<String, CDOCheckoutContentProvider> INSTANCES = new HashMap<String, CDOCheckoutContentProvider>();
    private static final CDOCheckoutManager CHECKOUT_MANAGER = CDOExplorerUtil.getCheckoutManager();
    private final IListener checkoutManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            RunnableViewerRefresh viewerRefresh = CDOCheckoutContentProvider.this.stateManager.getViewerRefresh();
            if (event instanceof IContainerEvent) {
                viewerRefresh.addNotification(null, true, true);
            } else if (event instanceof CDOCheckoutManager.CheckoutStateEvent) {
                CDOCheckoutManager.CheckoutStateEvent e = (CDOCheckoutManager.CheckoutStateEvent)event;
                CDOCheckout checkout = e.getCheckout();
                CDOCheckout.State state = e.getNewState();
                if (state == CDOCheckout.State.Opening) {
                    ViewerUtil.refresh((StructuredViewer)CDOCheckoutContentProvider.this.getViewer(), (Object)checkout);
                    ViewerUtil.expand((TreeViewer)CDOCheckoutContentProvider.this.getViewer(), (Object)checkout, (boolean)true);
                } else {
                    if (state == CDOCheckout.State.Closed) {
                        ViewerUtil.expand((TreeViewer)CDOCheckoutContentProvider.this.getViewer(), (Object)checkout, (boolean)false);
                    }
                    viewerRefresh.addNotification((Object)checkout, true, true);
                    if (state == CDOCheckout.State.Open) {
                        ViewerUtil.expand((TreeViewer)CDOCheckoutContentProvider.this.getViewer(), (Object)checkout, (boolean)true);
                    }
                    this.updatePropertySheetPage(checkout);
                }
            } else if (event instanceof CDOExplorerManager.ElementsChangedEvent) {
                CDOExplorerManager.ElementsChangedEvent e = (CDOExplorerManager.ElementsChangedEvent)event;
                CDOExplorerManager.ElementsChangedEvent.StructuralImpact structuralImpact = e.getStructuralImpact();
                Object[] changedElements = e.getChangedElements();
                if (structuralImpact != CDOExplorerManager.ElementsChangedEvent.StructuralImpact.NONE && changedElements.length == 1) {
                    Object changedElement = changedElements[0];
                    if (changedElement instanceof CDOElement) {
                        changedElement = ((CDOElement)changedElement).getParent();
                    }
                    if (structuralImpact == CDOExplorerManager.ElementsChangedEvent.StructuralImpact.PARENT) {
                        changedElement = CDOExplorerUtil.getParent((Object)changedElement);
                    }
                    viewerRefresh.addNotification(changedElement, true, true);
                } else {
                    Object[] objectArray = changedElements;
                    int n = changedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object changedElement = objectArray[n2];
                        viewerRefresh.addNotification(changedElement, false, true);
                        ++n2;
                    }
                }
                this.updatePropertySheetPage(changedElements);
            }
        }

        private void updatePropertySheetPage(final Object element) {
            TreeViewer viewer;
            Control control;
            IPage currentPage;
            IWorkbenchPage workbenchPage = CDOCheckoutContentProvider.this.getWorkbenchPage();
            PropertySheet propertySheet = this.getPropertySheet(workbenchPage);
            if (propertySheet != null && ((currentPage = propertySheet.getCurrentPage()) instanceof PropertySheetPage || currentPage instanceof TabbedPropertySheetPage) && !(control = (viewer = CDOCheckoutContentProvider.this.getViewer()).getControl()).isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IStructuredSelection selection;
                        if (!control.isDisposed() && (selection = (IStructuredSelection)viewer.getSelection()).size() == 1) {
                            Object[] objectArray = selection.toArray();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object = objectArray[n2];
                                if (object == element) {
                                    TabbedPropertySheetPage page;
                                    if (currentPage instanceof PropertySheetPage) {
                                        ((PropertySheetPage)currentPage).refresh();
                                    } else if (currentPage instanceof TabbedPropertySheetPage && (page = (TabbedPropertySheetPage)currentPage).getCurrentTab() != null) {
                                        page.refresh();
                                    }
                                    return;
                                }
                                ++n2;
                            }
                        }
                    }
                });
            }
        }

        private PropertySheet getPropertySheet(IWorkbenchPage workbenchPage) {
            IViewReference[] iViewReferenceArray = workbenchPage.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart view;
                IViewReference viewReference = iViewReferenceArray[n2];
                if ("org.eclipse.ui.views.PropertySheet".equals(viewReference.getId()) && (view = viewReference.getView(false)) instanceof PropertySheet) {
                    return (PropertySheet)view;
                }
                ++n2;
            }
            return null;
        }
    };
    private final CDOCheckoutStateManager stateManager = new CDOCheckoutStateManager(this);
    private String viewerID;

    public void init(ICommonContentExtensionSite config) {
        this.viewerID = config.getService().getViewerId();
        INSTANCES.put(this.viewerID, this);
        CHECKOUT_MANAGER.addListener(this.checkoutManagerListener);
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void dispose() {
        CHECKOUT_MANAGER.removeListener(this.checkoutManagerListener);
        INSTANCES.remove(this.viewerID);
    }

    public void disposeWith(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CDOCheckoutContentProvider.this.dispose();
            }
        });
    }

    public final CDOCheckoutStateManager getStateManager() {
        return this.stateManager;
    }

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        super.inputChanged(newViewer, oldInput, newInput);
        this.stateManager.inputChanged(this.getViewer(), oldInput, newInput);
    }

    public boolean hasChildren(Object object) {
        if (object instanceof IResource) {
            if (object instanceof IWorkspaceRoot) {
                return !CHECKOUT_MANAGER.isEmpty();
            }
            return false;
        }
        return super.hasChildren(object);
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IResource) {
            if (object instanceof IWorkspaceRoot) {
                return CHECKOUT_MANAGER.getCheckouts();
            }
            return ViewerUtil.NO_CHILDREN;
        }
        return super.getChildren(object);
    }

    public Object getParent(Object object) {
        if (object instanceof CDOCheckout) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        return super.getParent(object);
    }

    public IPropertySource getPropertySource(Object object) {
        CDOCheckoutState.ContentProvider contentProvider = this.stateManager.getContentProvider(object);
        if (contentProvider != null) {
            return contentProvider.getPropertySource(object);
        }
        return null;
    }

    public void selectObjects(final Object ... objects) {
        final TreeViewer viewer = this.getViewer();
        final Control control = viewer.getControl();
        if (!control.isDisposed()) {
            final long end = System.currentTimeMillis() + 5000L;
            final Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (control.isDisposed()) {
                        return;
                    }
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        LinkedList path = new LinkedList();
                        CDOCheckout checkout = CDOExplorerUtil.walkUp((Object)object, path);
                        if (checkout != null) {
                            viewer.setExpandedState((Object)checkout, true);
                            if (!path.isEmpty()) {
                                path.removeFirst();
                            }
                            if (!path.isEmpty()) {
                                path.removeLast();
                            }
                            for (Object parent : path) {
                                viewer.setExpandedState(parent, true);
                            }
                        }
                        ++n2;
                    }
                    viewer.setSelection((ISelection)new StructuredSelection(objects), true);
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    HashSet<Object> actual = new HashSet<Object>(Arrays.asList(selection.toArray()));
                    HashSet<Object> expected = new HashSet<Object>(Arrays.asList(objects));
                    if (!actual.equals(expected) && (CDOCheckoutContentProvider.isObjectLoading((Object[])objects) || System.currentTimeMillis() < end)) {
                        display.timerExec(50, (Runnable)this);
                    }
                }
            });
        }
    }

    public void open(OpenEvent event) {
        IStructuredSelection ssel;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1) {
            Object element = ssel.getFirstElement();
            if (element instanceof CDOCheckout) {
                final CDOCheckout checkout = (CDOCheckout)element;
                if (checkout.getState() == CDOCheckout.State.Closed) {
                    new Job("Open " + checkout.getLabel()){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                checkout.open();
                            }
                            catch (Exception ex) {
                                OM.LOG.error((Throwable)ex);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            } else if (!(element instanceof CDOResourceNode) && element instanceof EObject) {
                EObject eObject = (EObject)element;
                Shell shell = this.getWorkbenchPage().getWorkbenchWindow().getShell();
                ComposedAdapterFactory adapterFactory = this.stateManager.getAdapterFactory(eObject);
                OpenWithActionProvider.editObject(shell, adapterFactory, eObject);
            }
        }
    }

    protected void hookViewer(TreeViewer viewer) {
        viewer.addOpenListener((IOpenListener)this);
    }

    protected void unhookViewer(TreeViewer viewer) {
        viewer.removeOpenListener((IOpenListener)this);
    }

    protected Object adapt(Object target, Object type) {
        return this.stateManager.adapt(target, type);
    }

    protected Object[] modifyChildren(Object parent, Object[] children) {
        return CDOCheckoutContentModifier.Registry.INSTANCE.modifyChildren(parent, children);
    }

    protected ITreeContentProvider getContentProvider(Object object) {
        return this.stateManager.getContentProvider(object);
    }

    protected RunnableViewerRefresh getViewerRefresh() {
        return this.stateManager.getViewerRefresh();
    }

    protected boolean isContext(Object object) {
        return object instanceof CDOCheckout;
    }

    protected CDOContentProvider.ContextState getContextState(CDOCheckout checkout) {
        switch (checkout.getState()) {
            case Closing: 
            case Closed: {
                return CDOContentProvider.ContextState.Closed;
            }
            case Opening: {
                return CDOContentProvider.ContextState.Opening;
            }
            case Open: {
                return CDOContentProvider.ContextState.Open;
            }
        }
        throw new IllegalStateException("Unexpected checkout state: " + checkout);
    }

    protected void openContext(CDOCheckout checkout) {
        checkout.open();
    }

    protected void closeContext(CDOCheckout checkout) {
        checkout.close();
    }

    protected Object getRootObject(CDOCheckout checkout) {
        return checkout.getRootObject();
    }

    private IWorkbenchPage getWorkbenchPage() {
        TreeViewer viewer = this.getViewer();
        if (viewer instanceof CommonViewer) {
            CommonViewer commonViewer = (CommonViewer)viewer;
            return commonViewer.getCommonNavigator().getSite().getPage();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static TreeViewer createTreeViewer(Composite container, final Predicate<Object> contentPredicate) {
        CDOItemProvider parentItemProvider = new CDOItemProvider(null){

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length != 0;
            }

            public Object[] getChildren(Object element) {
                ArrayList<Object> children = new ArrayList<Object>();
                Object[] objectArray = this.doGetChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (contentPredicate.test(child)) {
                        children.add(child);
                    }
                    ++n2;
                }
                return children.toArray();
            }

            private Object[] doGetChildren(Object element) {
                CDOCheckout checkout;
                if (element instanceof CDOCheckout && (checkout = (CDOCheckout)element).isOpen()) {
                    return checkout.getRootObject().eContents().toArray();
                }
                return super.getChildren(element);
            }

            public void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
            }
        };
        CDOCheckoutContentProvider contentProvider = new CDOCheckoutContentProvider();
        contentProvider.disposeWith((Control)container);
        CDOCheckoutLabelProvider labelProvider = new CDOCheckoutLabelProvider(contentProvider);
        TreeViewer parentViewer = new TreeViewer(container, 2048);
        parentViewer.setContentProvider((IContentProvider)parentItemProvider);
        parentViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        parentViewer.setInput((Object)CDOExplorerUtil.getCheckoutManager());
        return parentViewer;
    }

    public static TreeViewer createTreeViewer(Composite container) {
        return CDOCheckoutContentProvider.createTreeViewer(container, child -> child instanceof CDOCheckout || child instanceof CDOResourceFolder);
    }

    public static final CDOCheckoutContentProvider getInstance(String viewerID) {
        return INSTANCES.get(viewerID);
    }
}

