/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.SimpleConfigurePushDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class SimplePushActionHandler
extends RepositoryActionHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemote(repository);
        if (config == null) {
            MessageDialog.openInformation((Shell)this.getShell(event), (String)UIText.SimplePushActionHandler_NothingToPushDialogTitle, (String)UIText.SimplePushActionHandler_NothingToPushDialogMessage);
            return null;
        }
        PushOperationUI op = new PushOperationUI(repository, config.getName(), false);
        op.start();
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repository = this.getRepository();
        return repository != null && SimpleConfigurePushDialog.getConfiguredRemoteCached(repository) != null;
    }

    public void updateElement(UIElement element, Map parameters) {
        RemoteConfig config = SimpleConfigurePushDialog.getConfiguredRemoteCached(this.getRepository());
        if (config != null) {
            element.setText(SimpleConfigurePushDialog.getSimplePushCommandLabel(config));
        }
    }
}

