/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.dialogs.CommitSelectDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithPreviousActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        if (resources != null && resources.length > 0) {
            try {
                IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                RevCommit previous = this.getPreviousRevision(event, resources);
                if (previous != null) {
                    CompareUtils.compare(resources, repository, "HEAD", previous.getName(), true, workbenchPage);
                } else {
                    this.showNotFoundDialog(event, resources);
                }
            }
            catch (Exception e) {
                Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
            }
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection selection = this.getSelection();
        return super.isEnabled() && selection.size() == 1 && this.selectionMapsToSingleRepository();
    }

    private RevCommit getPreviousRevision(final ExecutionEvent event, IResource[] resources) throws IOException {
        final List<RevCommit> previousList = this.findPreviousCommits(Arrays.asList(resources));
        final AtomicReference<RevCommit> previous = new AtomicReference<RevCommit>();
        if (previousList.isEmpty()) {
            return null;
        }
        if (previousList.size() == 1) {
            previous.set(previousList.get(0));
        } else {
            final ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (RevCommit pc : previousList) {
                commits.add(pc);
            }
            HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CommitSelectDialog dlg = new CommitSelectDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), commits);
                    if (dlg.open() == 0) {
                        for (RevCommit pc : previousList) {
                            if (!pc.equals((AnyObjectId)dlg.getSelectedCommit())) continue;
                            previous.set(pc);
                            break;
                        }
                    }
                }
            });
        }
        return (RevCommit)previous.get();
    }

    private void showNotFoundDialog(final ExecutionEvent event, IResource[] resources) {
        String resourceNames = CommonUtils.getResourceNames(Arrays.asList(resources));
        final String message = MessageFormat.format(UIText.CompareWithPreviousActionHandler_MessageRevisionNotFound, resourceNames);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)UIText.CompareWithPreviousActionHandler_TitleRevisionNotFound, (String)message);
            }
        });
    }
}

