/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.spi.server.IAppExtension3;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AppExtension
implements IAppExtension3 {
    public abstract String getName();

    @Override
    public final void start(File configFile) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void stop() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start(IRepository[] repositories, File configFile) throws Exception {
        String name = this.getName();
        OM.LOG.info(String.valueOf(name) + " extension starting");
        Document document = this.getDocument(configFile);
        NodeList repositoryConfigs = document.getElementsByTagName("repository");
        int i = 0;
        while (i < repositoryConfigs.getLength()) {
            Element repositoryConfig = (Element)repositoryConfigs.item(i);
            String repositoryName = repositoryConfig.getAttribute("name");
            InternalRepository repository = this.getRepository(repositories, repositoryName);
            if (repository != null) {
                try {
                    this.start(repository, repositoryConfig);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
            ++i;
        }
        OM.LOG.info(String.valueOf(name) + " extension started");
    }

    @Override
    public void stop(IRepository[] repositories) throws Exception {
        String name = this.getName();
        OM.LOG.info(String.valueOf(name) + " extension stopping");
        IRepository[] iRepositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository = iRepositoryArray[n2];
            try {
                this.stop((InternalRepository)repository);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
        OM.LOG.info(String.valueOf(name) + " extension stopped");
    }

    protected abstract void start(InternalRepository var1, Element var2) throws Exception;

    protected abstract void stop(InternalRepository var1) throws Exception;

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    private InternalRepository getRepository(IRepository[] repositories, String name) {
        IRepository[] iRepositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository repository = iRepositoryArray[n2];
            if (Objects.equals(repository.getName(), name)) {
                return (InternalRepository)repository;
            }
            ++n2;
        }
        return null;
    }
}

