/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class SecurityUtil {
    public static final String PBE_WITH_MD5_AND_DES = "PBEWithMD5AndDES";
    public static final byte[] DEFAULT_SALT = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    public static final int DEFAULT_ITERATION_COUNT = 20;

    private SecurityUtil() {
    }

    public static byte[] pbe(byte[] data, char[] password, String algorithmName, byte[] salt, int count, int mode) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(password);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(algorithmName);
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance(algorithmName);
        pbeCipher.init(mode, (Key)pbeKey, pbeParamSpec);
        return pbeCipher.doFinal(data);
    }

    public static byte[] pbeDecrypt(byte[] data, char[] password, String algorithmName, byte[] salt, int count) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return SecurityUtil.pbe(data, password, algorithmName, salt, count, 2);
    }

    public static byte[] pbeEncrypt(byte[] data, char[] password, String algorithmName, byte[] salt, int count) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return SecurityUtil.pbe(data, password, algorithmName, salt, count, 1);
    }

    @Deprecated
    public static byte[] encrypt(byte[] data, char[] password, String algorithmName, byte[] salt, int count) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return SecurityUtil.pbeEncrypt(data, password, algorithmName, salt, count);
    }
}

