/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.gogo.command.Util;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class Basic {
    private final BundleContext m_bc;
    private final Bundle m_b0;

    public Basic(BundleContext bc) {
        this.m_bc = bc;
        this.m_b0 = this.m_bc.getBundle(0L);
    }

    @Descriptor(value="query bundle start level")
    public String bundlelevel(@Descriptor(value="bundle to query") Bundle bundle) {
        return bundle + " is level " + ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Descriptor(value="set bundle start level or initial bundle start level")
    public String bundlelevel(@Descriptor(value="set the bundle's start level") @Parameter(names={"-s", "--setlevel"}, presentValue="true", absentValue="false") boolean set, @Descriptor(value="set the initial bundle start level") @Parameter(names={"-i", "--setinitial"}, presentValue="true", absentValue="false") boolean initial, @Descriptor(value="target level") int level, @Descriptor(value="target identifiers") Bundle[] bundles) {
        if (set && initial) {
            return "Cannot specify '-s' and '-i' at the same time.";
        }
        if (!set && !initial) {
            return "Must specify either '-s' or '-i'.";
        }
        if (level <= 0) {
            return "Specified start level must be greater than zero.";
        }
        if (initial) {
            if (bundles == null || bundles.length != 0) return "Cannot specify bundles when setting initial start level.";
            ((FrameworkStartLevel)this.m_b0.adapt(FrameworkStartLevel.class)).setInitialBundleStartLevel(level);
            return null;
        } else {
            if (!set) return null;
            if (bundles == null || bundles.length == 0) return "Must specify target bundles.";
            for (Bundle bundle : bundles) {
                ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(level);
            }
        }
        return null;
    }

    @Descriptor(value="query framework active start level")
    public String frameworklevel() {
        return "Level is " + ((FrameworkStartLevel)this.m_b0.adapt(FrameworkStartLevel.class)).getStartLevel();
    }

    @Descriptor(value="set framework active start level")
    public void frameworklevel(@Descriptor(value="target start level") int level) {
        ((FrameworkStartLevel)this.m_b0.adapt(FrameworkStartLevel.class)).setStartLevel(level, new FrameworkListener[0]);
    }

    @Descriptor(value="display bundle headers")
    public String headers(@Descriptor(value="target bundles") Bundle[] bundles) {
        try (Formatter f = new Formatter();){
            bundles = bundles == null || bundles.length == 0 ? this.m_bc.getBundles() : bundles;
            String prefix = "";
            for (Bundle bundle : bundles) {
                String title = Util.getBundleName(bundle);
                f.format("%s%s%n", prefix, title);
                f.format("%s%n", Util.getUnderlineString(title.length()));
                Dictionary dict = bundle.getHeaders();
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    String k = (String)keys.nextElement();
                    String v = (String)dict.get(k);
                    f.format("%s = %s%n", k, v);
                }
                prefix = "\n";
            }
            String string = f.toString();
            return string;
        }
    }

    @Descriptor(value="displays available commands")
    public String help() {
        try (Formatter f = new Formatter();){
            Map<String, List<Method>> commands = this.getCommands();
            for (String name : commands.keySet()) {
                f.format("%s%n", name);
            }
            String string = f.toString();
            return string;
        }
    }

    @Descriptor(value="displays information about a specific command")
    public String help(@Descriptor(value="target command") String name) {
        Map<String, List<Method>> commands = this.getCommands();
        List<Method> methods = null;
        int scopeIdx = name.indexOf(58);
        if (scopeIdx < 0) {
            for (Map.Entry<String, List<Method>> entry : commands.entrySet()) {
                String k = entry.getKey().substring(entry.getKey().indexOf(58) + 1);
                if (!name.equals(k)) continue;
                name = entry.getKey();
                methods = entry.getValue();
                break;
            }
        } else {
            methods = commands.get(name);
        }
        if (methods == null || methods.size() <= 0) {
            return "No methods found matching: " + name;
        }
        try (Formatter f = new Formatter();){
            String prefix = "";
            for (Method m : methods) {
                int aliasIdx;
                String[] names;
                Descriptor d = m.getAnnotation(Descriptor.class);
                if (d == null) {
                    f.format("%s%s%n", prefix, m.getName());
                } else {
                    f.format("%s%s - %s%n", prefix, m.getName(), d.value());
                }
                f.format("   scope: %s%n", name.substring(0, name.indexOf(58)));
                Class<?>[] paramTypes = m.getParameterTypes();
                TreeMap<String, Parameter> flags = new TreeMap<String, Parameter>();
                TreeMap<String, String> flagDescs = new TreeMap<String, String>();
                TreeMap<String, Parameter> options = new TreeMap<String, Parameter>();
                TreeMap<String, String> optionDescs = new TreeMap<String, String>();
                ArrayList<String> params = new ArrayList<String>();
                Annotation[][] anns = m.getParameterAnnotations();
                for (int paramIdx = 0; paramIdx < anns.length; ++paramIdx) {
                    Class<?> paramType = m.getParameterTypes()[paramIdx];
                    if (paramType == CommandSession.class) continue;
                    Parameter p = Basic.findAnnotation(anns[paramIdx], Parameter.class);
                    d = Basic.findAnnotation(anns[paramIdx], Descriptor.class);
                    if (p != null) {
                        if (p.presentValue().equals("org.apache.felix.service.command.unspecified.parameter")) {
                            options.put(p.names()[0], p);
                            if (d == null) continue;
                            optionDescs.put(p.names()[0], d.value());
                            continue;
                        }
                        flags.put(p.names()[0], p);
                        if (d == null) continue;
                        flagDescs.put(p.names()[0], d.value());
                        continue;
                    }
                    if (d != null) {
                        params.add(paramTypes[paramIdx].getSimpleName());
                        params.add(d.value());
                        continue;
                    }
                    params.add(paramTypes[paramIdx].getSimpleName());
                    params.add("");
                }
                if (flags.size() > 0) {
                    f.format("   flags:%n", new Object[0]);
                    for (Map.Entry entry : flags.entrySet()) {
                        names = ((Parameter)entry.getValue()).names();
                        f.format("      %s", names[0]);
                        for (aliasIdx = 1; aliasIdx < names.length; ++aliasIdx) {
                            f.format(", %s", names[aliasIdx]);
                        }
                        f.format("   %s%n", flagDescs.get(entry.getKey()));
                    }
                }
                if (options.size() > 0) {
                    f.format("   options:%n", new Object[0]);
                    for (Map.Entry entry : options.entrySet()) {
                        names = ((Parameter)entry.getValue()).names();
                        f.format("      %s", names[0]);
                        for (aliasIdx = 1; aliasIdx < names.length; ++aliasIdx) {
                            f.format(", %s", names[aliasIdx]);
                        }
                        f.format("   %s%s%n", optionDescs.get(entry.getKey()), ((Parameter)entry.getValue()).absentValue() == null ? "" : " [optional]");
                    }
                }
                if (params.size() > 0) {
                    f.format("   parameters:%n", new Object[0]);
                    Iterator it = params.iterator();
                    while (it.hasNext()) {
                        f.format("      %s   %s%n", it.next(), it.next());
                    }
                }
                prefix = "\n";
            }
            String string = f.toString();
            return string;
        }
    }

    private static <T extends Annotation> T findAnnotation(Annotation[] anns, Class<T> clazz) {
        for (int i = 0; anns != null && i < anns.length; ++i) {
            if (!clazz.isInstance(anns[i])) continue;
            return (T)((Annotation)clazz.cast(anns[i]));
        }
        return null;
    }

    private Map<String, List<Method>> getCommands() {
        ServiceReference[] refs = null;
        try {
            refs = this.m_bc.getAllServiceReferences(null, "(osgi.command.scope=*)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        TreeMap<String, List<Method>> commands = new TreeMap<String, List<Method>>();
        for (ServiceReference ref : refs) {
            String[] funcs;
            String[] stringArray;
            Object svc = this.m_bc.getService(ref);
            if (svc == null) continue;
            String scope = (String)ref.getProperty("osgi.command.scope");
            Object ofunc = ref.getProperty("osgi.command.function");
            if (ofunc instanceof String[]) {
                stringArray = (String[])ofunc;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = String.valueOf(ofunc);
            }
            for (String func : funcs = stringArray) {
                commands.put(scope + ":" + func, new ArrayList());
            }
            if (!commands.isEmpty()) {
                Method[] methods;
                for (Method method : methods = svc.getClass().getMethods()) {
                    List commandMethods = (List)commands.get(scope + ":" + method.getName());
                    if (commandMethods == null) continue;
                    commandMethods.add(method);
                }
            }
            Iterator it = commands.entrySet().iterator();
            while (it.hasNext()) {
                if (((List)it.next().getValue()).size() != 0) continue;
                it.remove();
            }
        }
        return commands;
    }

    @Descriptor(value="install bundle using URLs")
    public String install(@Descriptor(value="command session") CommandSession session, @Descriptor(value="target URLs") String[] urls) throws IOException {
        try (Formatter f = new Formatter();){
            StringBuilder sb = new StringBuilder();
            for (String url : urls) {
                String location = Util.resolveUri(session, url.trim());
                Bundle bundle = null;
                try {
                    bundle = this.m_bc.installBundle(location, null);
                }
                catch (IllegalStateException ex) {
                    f.format("%s%n", ex.toString());
                }
                catch (BundleException ex) {
                    if (ex.getNestedException() != null) {
                        f.format("%s%n", ex.getNestedException().toString());
                    } else {
                        f.format("%s%n", ex.toString());
                    }
                }
                catch (Exception ex) {
                    f.format("%s%n", ex.toString());
                }
                if (bundle == null) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(bundle.getBundleId());
            }
            if (sb.toString().indexOf(44) > 0) {
                String string = "Bundle IDs: " + sb.toString();
                return string;
            }
            if (sb.length() > 0) {
                String string = "Bundle ID: " + sb.toString();
                return string;
            }
            String string = f.toString();
            return string;
        }
    }

    @Descriptor(value="list all installed bundles")
    public String lb(@Descriptor(value="show location") @Parameter(names={"-l", "--location"}, presentValue="true", absentValue="false") boolean showLoc, @Descriptor(value="show symbolic name") @Parameter(names={"-s", "--symbolicname"}, presentValue="true", absentValue="false") boolean showSymbolic, @Descriptor(value="show update location") @Parameter(names={"-u", "--updatelocation"}, presentValue="true", absentValue="false") boolean showUpdate) {
        return this.lb(showLoc, showSymbolic, showUpdate, null);
    }

    @Descriptor(value="list installed bundles matching a substring")
    public String lb(@Descriptor(value="show location") @Parameter(names={"-l", "--location"}, presentValue="true", absentValue="false") boolean showLoc, @Descriptor(value="show symbolic name") @Parameter(names={"-s", "--symbolicname"}, presentValue="true", absentValue="false") boolean showSymbolic, @Descriptor(value="show update location") @Parameter(names={"-u", "--updatelocation"}, presentValue="true", absentValue="false") boolean showUpdate, @Descriptor(value="subtring matched against name or symbolic name") String pattern) {
        if (showLoc && showSymbolic && showUpdate || showLoc && showSymbolic || showSymbolic && showUpdate || showLoc && showUpdate) {
            return "Only one of -l, -s, -u should be used.";
        }
        ArrayList<Bundle> found = new ArrayList<Bundle>();
        if (pattern == null) {
            found.addAll(Arrays.asList(this.m_bc.getBundles()));
        } else {
            Bundle[] bundles = this.m_bc.getBundles();
            for (Bundle bundle : bundles) {
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                if (!this.matchBundleName(bundle.getSymbolicName(), pattern) && !this.matchBundleName(name, pattern)) continue;
                found.add(bundle);
            }
        }
        if (found.size() > 0) {
            Formatter f = new Formatter();
            Object object = null;
            try {
                Basic.printBundleList(found.toArray(new Bundle[found.size()]), showLoc, showSymbolic, showUpdate, this.m_b0, f);
                String string = f.toString();
                return string;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (f != null) {
                    if (object != null) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        f.close();
                    }
                }
            }
        }
        return "No matching bundles found.";
    }

    private boolean matchBundleName(String name, String pattern) {
        return name != null && name.toLowerCase().contains(pattern.toLowerCase());
    }

    @Descriptor(value="display all matching log entries")
    public String log(@Descriptor(value="minimum log level [ debug | info | warn | error ]") String logLevel) {
        return this.log(-1, logLevel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Descriptor(value="display some matching log entries")
    public String log(@Descriptor(value="maximum number of entries") int maxEntries, @Descriptor(value="minimum log level [ debug | info | warn | error ]") String logLevel) {
        ArrayList refs = new ArrayList();
        try {
            LogReaderService lrs = Util.getService(this.m_bc, LogReaderService.class, refs);
            if (lrs == null) {
                return "Log reader service is unavailable.";
            }
            try (Formatter f = new Formatter();){
                Enumeration entries = lrs.getLog();
                ArrayList<LogEntry> select = new ArrayList<LogEntry>();
                int minLevel = Basic.logLevelAsInt(logLevel);
                int index = 0;
                while (entries.hasMoreElements() && (maxEntries < 0 || index < maxEntries)) {
                    LogEntry entry = (LogEntry)entries.nextElement();
                    if (entry.getLevel() > minLevel) continue;
                    select.add(0, entry);
                    ++index;
                }
                select.forEach(e -> this.display((LogEntry)e, f));
                Util.ungetServices(this.m_bc, refs);
                String string = f.toString();
                return string;
            }
        }
        catch (NoClassDefFoundError ncdfe) {
            return "Log reader service is unavailable.";
        }
    }

    private void display(LogEntry entry, Formatter f) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        StringBuilder buffer = new StringBuilder();
        buffer.append(sdf.format(new Date(entry.getTime()))).append(" ");
        buffer.append(Basic.logLevelAsString(entry.getLevel())).append(" - ");
        buffer.append("Bundle: ").append(entry.getBundle().getSymbolicName());
        if (entry.getServiceReference() != null) {
            buffer.append(" - ");
            buffer.append(entry.getServiceReference().toString());
        }
        buffer.append(" - ").append(entry.getMessage());
        if (entry.getException() != null) {
            buffer.append(" - ");
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            entry.getException().printStackTrace(pw);
            buffer.append(writer.toString());
        }
        f.format("%s%n", buffer.toString());
    }

    private static int logLevelAsInt(String logLevel) {
        if ("error".equalsIgnoreCase(logLevel)) {
            return 1;
        }
        if ("warn".equalsIgnoreCase(logLevel)) {
            return 2;
        }
        if ("info".equalsIgnoreCase(logLevel)) {
            return 3;
        }
        return 4;
    }

    private static String logLevelAsString(int level) {
        switch (level) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
        }
        return "DEBUG";
    }

    @Descriptor(value="refresh bundles")
    public void refresh(@Descriptor(value="target bundles (can be null or empty)") Bundle[] bundles) {
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        ((FrameworkWiring)this.m_b0.adapt(FrameworkWiring.class)).refreshBundles(Arrays.asList(bundles), new FrameworkListener[0]);
    }

    @Descriptor(value="resolve bundles")
    public String resolve(@Descriptor(value="target bundles (can be null or empty)") Bundle[] bundles) {
        if (((FrameworkWiring)this.m_b0.adapt(FrameworkWiring.class)).resolveBundles(bundles != null ? Arrays.asList(bundles) : null)) {
            return "Not all bundles could be resolved.";
        }
        return null;
    }

    @Descriptor(value="start bundles")
    public String start(@Descriptor(value="start bundle transiently") @Parameter(names={"-t", "--transient"}, presentValue="true", absentValue="false") boolean trans, @Descriptor(value="use declared activation policy") @Parameter(names={"-p", "--policy"}, presentValue="true", absentValue="false") boolean policy, @Descriptor(value="target bundle identifiers or URLs") String[] ss) {
        if (ss == null || ss.length < 1) {
            return "Please specify the bundles to start.";
        }
        int options = 0;
        if (trans) {
            options |= 1;
        }
        if (policy) {
            options |= 2;
        }
        try (Formatter f = new Formatter();){
            for (String s : ss) {
                String id = s.trim();
                try {
                    Bundle bundle = null;
                    if (Character.isDigit(id.charAt(0))) {
                        long l = Long.parseLong(id);
                        bundle = this.m_bc.getBundle(l);
                    } else {
                        bundle = this.m_bc.installBundle(id);
                    }
                    if (bundle != null) {
                        bundle.start(options);
                        continue;
                    }
                    f.format("Bundle ID '%s'  is invalid.%n", id);
                }
                catch (NumberFormatException ex) {
                    f.format("Unable to parse id '%s'.%n", id);
                }
                catch (BundleException ex) {
                    if (ex.getNestedException() != null) {
                        f.format("%s%n", ex.getNestedException().toString());
                        continue;
                    }
                    f.format("%s%n", ex.toString());
                }
                catch (Exception ex) {
                    f.format("%s%n", ex.toString());
                }
            }
            String string = f.toString();
            return string;
        }
    }

    @Descriptor(value="stop bundles")
    public String stop(@Descriptor(value="stop bundle transiently") @Parameter(names={"-t", "--transient"}, presentValue="true", absentValue="false") boolean trans, @Descriptor(value="target bundles") Bundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return "Please specify the bundles to stop.";
        }
        int options = 0;
        if (trans) {
            options |= 1;
        }
        try (Formatter f = new Formatter();){
            for (Bundle bundle : bundles) {
                try {
                    bundle.stop(options);
                }
                catch (BundleException ex) {
                    if (ex.getNestedException() != null) {
                        f.format("%s%n", ex.getNestedException().toString());
                        continue;
                    }
                    f.format("%s%n", ex.toString());
                }
                catch (Exception ex) {
                    f.format("%s%n", ex.toString());
                }
            }
            String string = f.toString();
            return string;
        }
    }

    @Descriptor(value="uninstall bundles")
    public String uninstall(@Descriptor(value="target bundles") Bundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return "Please specify the bundles to uninstall.";
        }
        try (Formatter f = new Formatter();){
            for (Bundle bundle : bundles) {
                try {
                    bundle.uninstall();
                }
                catch (BundleException ex) {
                    if (ex.getNestedException() != null) {
                        f.format("%s%n", ex.getNestedException().toString());
                        continue;
                    }
                    f.format("%s%n", ex.toString());
                }
                catch (Exception ex) {
                    f.format("%s%n", ex.toString());
                }
            }
            String string = f.toString();
            return string;
        }
    }

    @Descriptor(value="update bundle")
    public String update(@Descriptor(value="target bundle") Bundle bundle) {
        if (bundle == null) {
            return "Must specify a bundle.";
        }
        try {
            bundle.update();
            return null;
        }
        catch (BundleException ex) {
            if (ex.getNestedException() != null) {
                return ex.getNestedException().toString();
            }
            return ex.toString();
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    @Descriptor(value="update bundle from URL")
    public String update(@Descriptor(value="command session") CommandSession session, @Descriptor(value="target bundle") Bundle bundle, @Descriptor(value="URL from where to retrieve bundle") String location) throws IOException {
        if (bundle == null) {
            return "Must specify a bundle.";
        }
        if (location == null) {
            return "Must specify a location.";
        }
        try {
            location = Util.resolveUri(session, location.trim());
            InputStream is = new URL(location).openStream();
            bundle.update(is);
            return null;
        }
        catch (MalformedURLException ex) {
            return "Unable to parse URL";
        }
        catch (IOException ex) {
            return "Unable to open input stream: " + ex;
        }
        catch (BundleException ex) {
            if (ex.getNestedException() != null) {
                return ex.getNestedException().toString();
            }
            return ex.toString();
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    @Descriptor(value="determines from where a bundle loads a class")
    public String which(@Descriptor(value="target bundle") Bundle bundle, @Descriptor(value="target class name") String className) {
        if (bundle == null) {
            return "Please specify a bundle";
        }
        Class clazz = null;
        try {
            clazz = bundle.loadClass(className);
            if (clazz.getClassLoader() == null) {
                return "Loaded from: boot class loader";
            }
            if (clazz.getClassLoader() instanceof BundleReference) {
                Bundle p = ((BundleReference)clazz.getClassLoader()).getBundle();
                return "Loaded from: " + p;
            }
            return "Loaded from: " + clazz.getClassLoader();
        }
        catch (ClassNotFoundException ex) {
            return "Class not found";
        }
    }

    private static void printBundleList(Bundle[] bundles, boolean showLoc, boolean showSymbolic, boolean showUpdate, Bundle b0, Formatter f) {
        f.format("START LEVEL %s%n", ((FrameworkStartLevel)b0.adapt(FrameworkStartLevel.class)).getStartLevel());
        String lastColumn = "Name";
        if (showLoc) {
            lastColumn = "Location";
        } else if (showSymbolic) {
            lastColumn = "Symbolic name";
        } else if (showUpdate) {
            lastColumn = "Update location";
        }
        f.format("%5s|%-11s|%5s|%s%n", "ID", "State", "Level", lastColumn);
        for (Bundle bundle : bundles) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            name = name == null ? bundle.getSymbolicName() : name;
            String string = name = name == null ? bundle.getLocation() : name;
            if (showLoc) {
                name = bundle.getLocation();
            } else if (showSymbolic) {
                name = bundle.getSymbolicName();
                name = name == null ? "<no symbolic name>" : name;
            } else if (showUpdate) {
                name = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
                name = name == null ? bundle.getLocation() : name;
            }
            name = !showLoc && !showUpdate ? name + " (" + bundle.getVersion() + ")" : name;
            int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
            f.format("%5d|%-11s|%5d|%s|%s%n", bundle.getBundleId(), Basic.getStateString(bundle), level, name, bundle.getVersion());
        }
    }

    private static String getStateString(Bundle bundle) {
        int state = bundle.getState();
        if (state == 32) {
            return "Active     ";
        }
        if (state == 2) {
            return "Installed  ";
        }
        if (state == 4) {
            return "Resolved   ";
        }
        if (state == 8) {
            return "Starting   ";
        }
        if (state == 16) {
            return "Stopping   ";
        }
        return "Unknown    ";
    }
}

