/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.properties.providers;

import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;

public class ProviderUtils {
    public static final String ELEMENT_TYPE_DISPLAY_NAME_SEPARATOR = "::";

    private ProviderUtils() {
    }

    public static String getElementTypeDisplayName(ElementTypeConfiguration element) {
        String result = "";
        IElementType elementType = element instanceof MetamodelTypeConfiguration ? ElementTypeRegistry.getInstance().getType(((MetamodelTypeConfiguration)element).getIdentifier()) : (element instanceof SpecializationTypeConfiguration ? ElementTypeRegistry.getInstance().getType(((SpecializationTypeConfiguration)element).getIdentifier()) : null);
        if (elementType != null) {
            result = elementType.getDisplayName() != null && !elementType.getDisplayName().isEmpty() ? elementType.getDisplayName() : result;
        }
        return result;
    }

    public static final String getNameToDisplay(ElementTypeConfiguration configuration) {
        String displayName = ProviderUtils.getElementTypeDisplayName(configuration);
        String[] res = displayName.split(ELEMENT_TYPE_DISPLAY_NAME_SEPARATOR);
        String metamodelName = null;
        if (res.length == 2) {
            metamodelName = res[1];
        }
        String returnedValue = "";
        if (metamodelName != null && !metamodelName.isEmpty()) {
            returnedValue = metamodelName;
        } else if (configuration.getName() != null && !configuration.getName().isEmpty()) {
            returnedValue = configuration.getName();
        }
        return returnedValue;
    }
}

