/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.generator;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.ProjectEditors;
import org.eclipse.papyrus.toolsmiths.Activator;
import org.eclipse.papyrus.toolsmiths.factory.ExtensionFactory;
import org.eclipse.papyrus.toolsmiths.messages.Messages;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.toolsmiths.model.customizationplugin.CustomizationConfiguration;
import org.xml.sax.SAXException;

public class PluginGenerator {
    public static PluginGenerator instance = new PluginGenerator();
    private static final String PLUGIN_NATURE_ID = "org.eclipse.pde.PluginNature";

    public void generate(IProject project, CustomizationConfiguration configuration) throws CoreException, IOException, SAXException, ParserConfigurationException {
        IPluginEditor editor = ProjectEditors.getPluginEditor((IProject)project);
        if (!editor.exists()) {
            editor.create();
        }
        editor.init();
        HashSet<String> natures = new HashSet<String>();
        natures.add(PLUGIN_NATURE_ID);
        editor.addNatures(natures);
        editor.setSingleton(true);
        for (CustomizableElement element : configuration.getElements()) {
            ExtensionFactory factory = this.getFactory(element);
            if (factory != null) {
                factory.addElement(element, editor);
                continue;
            }
            Activator.log.warn(Messages.PluginGenerator_factoryNotFound + String.valueOf(element.eClass()));
        }
        editor.save();
        if (editor.pluginManifestExists()) {
            editor.addToBuild("plugin.xml");
            editor.save();
        }
        String pluginId = configuration.getPlugin();
        Resource resource = configuration.eResource();
        URI uri = URI.createPlatformResourceURI((String)(pluginId + "/customizationConfiguration.xmi"), (boolean)true);
        if (resource == null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resource = resourceSet.createResource(uri);
            resource.getContents().add((Object)configuration);
        } else {
            configuration.eResource().setURI(uri);
        }
        configuration.eResource().save(Collections.EMPTY_MAP);
        editor.getProject().refreshLocal(0, null);
    }

    private ExtensionFactory getFactory(CustomizableElement element) {
        ExtensionFactory factory = ExtensionFactory.registry.getFactory(element.eClass());
        return factory;
    }

    private PluginGenerator() {
    }
}

