/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.rules;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.PaletteUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.nattable.common.editor.AbstractEMFNattableEditor;
import org.eclipse.papyrus.infra.nattable.common.modelresource.PapyrusNattableModel;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.internal.preferences.EditorPreferences;
import org.eclipse.papyrus.infra.ui.internal.preferences.YesNo;
import org.eclipse.papyrus.junit.matchers.CommandMatchers;
import org.eclipse.papyrus.junit.utils.CommandUtils;
import org.eclipse.papyrus.junit.utils.EditorUtils;
import org.eclipse.papyrus.junit.utils.JUnitUtils;
import org.eclipse.papyrus.junit.utils.rules.AbstractModelFixture;
import org.eclipse.papyrus.junit.utils.rules.ActiveDiagram;
import org.eclipse.papyrus.junit.utils.rules.ActiveTable;
import org.eclipse.papyrus.junit.utils.rules.ShowView;
import org.eclipse.papyrus.sirius.editor.internal.sessions.SessionService;
import org.eclipse.papyrus.sirius.editor.modelresource.SiriusDiagramModel;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.tests.support.api.DiagramComponentizationTestSupport;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.runner.Description;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SiriusDiagramEditorFixture
extends AbstractModelFixture<TransactionalEditingDomain> {
    private static boolean DUMP_COMMANDS = Boolean.getBoolean("dump.commands");
    private DiagramEditorWithFlyOutPalette activeDiagramEditor;
    private AbstractEMFNattableEditor activeTableEditor;
    private IDiagramCommandFactory commandFactory;
    private IMultiDiagramEditor editor;
    private final Collection<IEditorPart> editorsToClose = Lists.newArrayList();
    private final boolean ensureOperationHistoryIntegrity;
    private final List<String> excludedTypeView = Arrays.asList("Note");
    private YesNo initialEditorLayoutStorageMigrationPreference;
    private ModelExplorerView modelExplorer;
    private ListMultimap<Description, IFile> modelFiles;
    private IOperationHistory operationHistory;
    private IOperationHistoryListener operationHistoryIntegrityListener;
    private static final String TOOL_NAME_INCORRECT = "The tool name is not correct";
    private static final String LAYER_NAME_INCORRECT = "The layer name is not correct (not found in the diagram description of this diagram)";
    private Session session;
    private Class<?> testClass;
    private Description testDescription;
    private Collection<IViewPart> viewsToClose;

    public static Point at(int x, int y) {
        return new Point(x, y);
    }

    public static Point at(int x, int y, IGraphicalEditPart relativeTo) {
        Point at = new Point(x, y);
        IFigure figure = relativeTo.getContentPane();
        Point layoutOrigin = figure.getClientArea().getLocation();
        at.performTranslate(layoutOrigin.x, layoutOrigin.y);
        figure.translateToParent((Translatable)at);
        figure.translateToAbsolute((Translatable)at);
        return at;
    }

    public static Dimension sized(int width, int height) {
        return new Dimension(width, height);
    }

    private static <T> Supplier<T> failOnAbsence(String message) {
        return () -> {
            Assert.fail((String)message);
            return null;
        };
    }

    private static <T> Stream<T> stream(Collection rawCollection, Class<T> type) {
        return rawCollection.stream().filter(type::isInstance).map(type::cast);
    }

    public SiriusDiagramEditorFixture() {
        this(true);
    }

    public SiriusDiagramEditorFixture(boolean ensureOperationHistoryIntegrity) {
        this(ensureOperationHistoryIntegrity, Collections.emptyList());
    }

    public SiriusDiagramEditorFixture(boolean ensureOperationHistoryIntegrity, List<String> additionalFileExtension) {
        super(Lists.asList((Object)"aird", (Object[])additionalFileExtension.toArray(new String[additionalFileExtension.size()])));
        this.ensureOperationHistoryIntegrity = ensureOperationHistoryIntegrity;
    }

    public SiriusDiagramEditorFixture(List<String> additionalFileExtension) {
        super(additionalFileExtension);
        this.ensureOperationHistoryIntegrity = true;
    }

    public void activate() {
        if (this.editor != null) {
            this.activate((IWorkbenchPart)this.editor);
        }
    }

    public void activate(IWorkbenchPart part) {
        IWorkbenchPage page = part.getSite().getPage();
        if (page.getActivePart() != part) {
            page.activate(part);
            this.flushDisplayEvents();
        }
    }

    public SiriusDiagramEditorFixture activateDiagram(DiagramEditPart diagram) {
        return this.activateDiagram(this.editor, diagram);
    }

    public SiriusDiagramEditorFixture activateDiagram(IMultiDiagramEditor editor, final DiagramEditPart diagram) {
        this.activate((IWorkbenchPart)editor);
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] select = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IComponentPage page) {
            }

            public void accept(IEditorPage page) {
                DiagramEditorWithFlyOutPalette nested = (DiagramEditorWithFlyOutPalette)TypeUtils.as((Object)page.getIEditorPart(), DiagramEditorWithFlyOutPalette.class);
                if (nested != null && nested.getDiagramEditPart() == diagram) {
                    select[0] = page;
                    SiriusDiagramEditorFixture.this.setActiveDiagramEditor(nested);
                }
            }
        });
        if (select[0] != null) {
            sashContainer.selectPage(select[0]);
            this.flushDisplayEvents();
        }
        return this;
    }

    public SiriusDiagramEditorFixture activateDiagram(IMultiDiagramEditor editor, final String name) {
        this.activate((IWorkbenchPart)editor);
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] select = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IComponentPage page) {
            }

            public void accept(IEditorPage page) {
                if (name.equals(page.getPageTitle()) && page.getIEditorPart() instanceof DiagramEditorWithFlyOutPalette) {
                    select[0] = page;
                    SiriusDiagramEditorFixture.this.setActiveDiagramEditor((DiagramEditorWithFlyOutPalette)page.getIEditorPart());
                }
            }
        });
        if (select[0] != null) {
            sashContainer.selectPage(select[0]);
            this.flushDisplayEvents();
        }
        return this;
    }

    public SiriusDiagramEditorFixture activateDiagram(String name) {
        return this.activateDiagram(this.editor, name);
    }

    public SiriusDiagramEditorFixture activateTable(IMultiDiagramEditor editor, final String name) {
        this.activate((IWorkbenchPart)editor);
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] select = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IComponentPage page) {
            }

            public void accept(IEditorPage page) {
                if (name.equals(page.getPageTitle()) && page.getIEditorPart() instanceof AbstractEMFNattableEditor) {
                    select[0] = page;
                    SiriusDiagramEditorFixture.this.setActiveTableEditor((AbstractEMFNattableEditor)page.getIEditorPart());
                }
            }
        });
        if (select[0] != null) {
            sashContainer.selectPage(select[0]);
            this.flushDisplayEvents();
        }
        return this;
    }

    public SiriusDiagramEditorFixture activateTable(String name) {
        return this.activateTable(this.editor, name);
    }

    public void close() {
        if (this.editor != null) {
            this.close((IEditorPart)this.editor);
            this.editor = null;
        }
    }

    public void close(IEditorPart editor) {
        if (editor.getSite() != null && editor.getSite().getPage() != null) {
            editor.getSite().getPage().closeEditor(editor, false);
            this.flushDisplayEvents();
        }
    }

    public String closeDiagram() {
        String result = this.getActiveDiagramEditor().getDiagram().getName();
        this.closeDiagram(this.editor, result);
        return result;
    }

    public SiriusDiagramEditorFixture closeDiagram(IMultiDiagramEditor editor, String name) {
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)editor.getServicesRegistry());
            NotationModel representation = (NotationModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
            Diagram diagram = representation.getDiagram(name);
            if (diagram != null) {
                ((IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)editor.getServicesRegistry())).closePage((Object)diagram);
                this.flushDisplayEvents();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot close diagram", e);
        }
        return this;
    }

    public SiriusDiagramEditorFixture closeDiagram(String name) {
        return this.closeDiagram(this.editor, name);
    }

    public IGraphicalEditPart createShape(EditPart parent, IElementType type, Point location, Dimension size) {
        CreateViewRequest request = CreateViewRequestFactory.getCreateShapeRequest((IElementType)type, (PreferencesHint)((IGraphicalEditPart)parent).getDiagramPreferencesHint());
        request.setLocation(location);
        request.setSize(size);
        CreateElementRequest semanticRequest = null;
        if (!request.getViewDescriptors().isEmpty() && (semanticRequest = (CreateElementRequest)((CreateElementRequestAdapter)((CreateViewRequest.ViewDescriptor)request.getViewDescriptors().get(0)).getElementAdapter()).getAdapter(CreateElementRequest.class)) != null) {
            semanticRequest.setParameter("initialMouseLocationForCreation", (Object)location.getCopy());
        }
        EditPart target = parent.getTargetEditPart((Request)request);
        MatcherAssert.assertThat((String)"No target edit part", (Object)target, (Matcher)CoreMatchers.notNullValue());
        org.eclipse.gef.commands.Command command = target.getCommand((Request)request);
        this.execute(command);
        return this.getNewEditPart(parent, request.getViewDescriptors());
    }

    public IGraphicalEditPart createShape(IElementType type, Point location, Dimension size) {
        EditPartViewer viewer = this.getActiveDiagram().getViewer();
        class MyTool
        extends AspectUnspecifiedTypeCreationTool {
            private Collection<? extends CreateViewRequest.ViewDescriptor> results;

            MyTool(IElementType iElementType) {
                super(Collections.singletonList(iElementType));
                this.results = Collections.emptyList();
            }

            protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
                super.selectAddedObject(viewer, objects);
                this.results = objects.stream().filter(CreateViewRequest.ViewDescriptor.class::isInstance).map(CreateViewRequest.ViewDescriptor.class::cast).collect(Collectors.toList());
            }

            Collection<? extends CreateViewRequest.ViewDescriptor> getResults() {
                return this.results;
            }
        }
        MyTool tool = new MyTool(type);
        Event mouse = new Event();
        mouse.display = this.editor.getSite().getShell().getDisplay();
        mouse.widget = viewer.getControl();
        mouse.x = location.x();
        mouse.y = location.y();
        viewer.getEditDomain().setActiveTool((Tool)tool);
        tool.setViewer(viewer);
        mouse.type = 5;
        tool.mouseMove(new MouseEvent(mouse), viewer);
        mouse.type = 3;
        mouse.button = 1;
        tool.mouseDown(new MouseEvent(mouse), viewer);
        this.flushDisplayEvents();
        if (size == null) {
            mouse.type = 4;
            tool.mouseUp(new MouseEvent(mouse), viewer);
        } else {
            mouse.type = 5;
            mouse.x = location.x() + size.width();
            mouse.y = location.y() + size.height();
            tool.mouseDrag(new MouseEvent(mouse), viewer);
            this.flushDisplayEvents();
            mouse.type = 4;
            tool.mouseUp(new MouseEvent(mouse), viewer);
        }
        this.flushDisplayEvents();
        return this.getNewEditPart((EditPart)this.getActiveDiagram(), tool.getResults());
    }

    public void delete(EditPart ... editPart) {
        org.eclipse.gef.commands.Command delete = Stream.of(editPart).map(ep -> ep.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)))).reduce(org.eclipse.gef.commands.Command::chain).orElseThrow(IllegalArgumentException::new);
        this.execute(delete);
    }

    public void deselect(EditPart editPart) {
        editPart.getViewer().getSelectionManager().deselect(editPart);
    }

    public void ensurePapyrusPerspective() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String papyrus = "org.eclipse.papyrus.infra.core.perspective";
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IPerspectiveDescriptor perspective = activePage.getPerspective();
                if (!"org.eclipse.papyrus.infra.core.perspective".equals(perspective.getId()) && (perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.eclipse.papyrus.infra.core.perspective")) != null) {
                    activePage.setPerspective(perspective);
                    SiriusDiagramEditorFixture.this.flushDisplayEvents();
                }
            }
        });
    }

    public void execute(Command command) {
        super.execute(command);
        this.flushDisplayEvents();
    }

    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) {
        IStatus result = super.execute(operation, monitor, info);
        this.flushDisplayEvents();
        return result;
    }

    public void execute(org.eclipse.gef.commands.Command command) {
        MatcherAssert.assertThat((String)"No command", (Object)command, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)command, (Matcher)CommandMatchers.GEF.canExecute());
        this.getActiveDiagramEditor().getDiagramEditDomain().getDiagramCommandStack().execute(command);
        this.flushDisplayEvents();
    }

    public EditPart findEditPart(EditPart scope, EObject modelElement) {
        Iterator iter;
        EditPart result = null;
        View view = (View)PlatformHelper.getAdapter((Object)scope, View.class);
        if (view != null && view.getElement() == modelElement) {
            result = scope;
        }
        if (result == null) {
            iter = scope.getChildren().iterator();
            while (result == null && iter.hasNext()) {
                result = this.findEditPart((EditPart)iter.next(), modelElement);
            }
        }
        if (result == null && scope instanceof GraphicalEditPart) {
            iter = ((GraphicalEditPart)scope).getSourceConnections().iterator();
            while (result == null && iter.hasNext()) {
                result = this.findEditPart((EditPart)iter.next(), modelElement);
            }
            if (result == null) {
                iter = ((GraphicalEditPart)scope).getTargetConnections().iterator();
                while (result == null && iter.hasNext()) {
                    result = this.findEditPart((EditPart)iter.next(), modelElement);
                }
            }
        }
        return result;
    }

    public EditPart findEditPart(EObject modelElement) {
        return this.findEditPart((IDiagramWorkbenchPart)this.getActiveDiagramEditor(), modelElement);
    }

    public EditPart findEditPart(IDiagramWorkbenchPart editor, EObject modelElement) {
        DiagramEditPart diagram = editor.getDiagramEditPart();
        return this.findEditPart((EditPart)diagram, modelElement);
    }

    public EditPart findEditPart(IDiagramWorkbenchPart editor, String name, Class<? extends NamedElement> type) {
        EditPart result = null;
        UnmodifiableIterator views = Iterators.filter((Iterator)editor.getDiagram().eAllContents(), View.class);
        while (views.hasNext()) {
            View next = (View)views.next();
            EObject element = next.getElement();
            if (!type.isInstance(element) || !name.equals(type.cast(element).getName())) continue;
            result = (EditPart)editor.getDiagramGraphicalViewer().getEditPartRegistry().get(next);
            break;
        }
        return result;
    }

    public EditPart findEditPart(IMultiDiagramEditor editor, EObject modelElement) {
        IEditorPart activeEditor = editor.getActiveEditor();
        MatcherAssert.assertThat((String)"No diagram active", (Object)activeEditor, (Matcher)CoreMatchers.instanceOf(DiagramEditor.class));
        return this.findEditPart((IDiagramWorkbenchPart)((DiagramEditor)activeEditor), modelElement);
    }

    public EditPart findEditPart(IMultiDiagramEditor editor, String name, Class<? extends NamedElement> type) {
        IEditorPart activeEditor = editor.getActiveEditor();
        MatcherAssert.assertThat((String)"No diagram active", (Object)activeEditor, (Matcher)CoreMatchers.instanceOf(DiagramEditor.class));
        return this.findEditPart((IDiagramWorkbenchPart)((DiagramEditor)activeEditor), name, type);
    }

    public EditPart findEditPart(String name, Class<? extends NamedElement> type) {
        return this.findEditPart((IDiagramWorkbenchPart)this.getActiveDiagramEditor(), name, type);
    }

    public EditPart findOrphanEditPart() {
        IDiagramWorkbenchPart activeEditor = (IDiagramWorkbenchPart)this.editor.getActiveEditor();
        EditPart result = null;
        UnmodifiableIterator views = Iterators.filter((Iterator)activeEditor.getDiagram().eAllContents(), View.class);
        while (views.hasNext()) {
            View next = (View)views.next();
            String type = next.getType();
            EObject element = next.getElement();
            if (element != null || this.excludedTypeView.contains(type)) continue;
            result = (EditPart)activeEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(next);
            break;
        }
        return result;
    }

    public EditPart findOrphanEditPart(String type) {
        IDiagramWorkbenchPart activeEditor = (IDiagramWorkbenchPart)this.editor.getActiveEditor();
        EditPart result = null;
        UnmodifiableIterator views = Iterators.filter((Iterator)activeEditor.getDiagram().eAllContents(), View.class);
        while (views.hasNext()) {
            View next = (View)views.next();
            EObject element = next.getElement();
            if (element != null || !type.equals(next.getType())) continue;
            result = (EditPart)activeEditor.getDiagramGraphicalViewer().getEditPartRegistry().get(next);
            break;
        }
        return result;
    }

    public void flushDisplayEvents() {
        while (true) {
            try {
                while (Display.getCurrent() == null || Display.getCurrent().readAndDispatch()) {
                }
            }
            catch (Exception e) {
                Bundle testBundle = FrameworkUtil.getBundle(this.testClass == null ? SiriusDiagramEditorFixture.class : this.testClass);
                Platform.getLog((Bundle)testBundle).log((IStatus)new Status(4, testBundle.getSymbolicName(), "Uncaught exception in display runnable.", (Throwable)e));
                continue;
            }
            break;
        }
    }

    public DiagramEditPart getActiveDiagram() {
        return this.getActiveDiagramEditor().getDiagramEditPart();
    }

    public DSemanticDiagram getActiveSiriusDiagram() {
        Diagram diagram;
        DiagramEditPart diagramEditpart = this.getActiveDiagramEditor().getDiagramEditPart();
        if (diagramEditpart != null && (diagram = diagramEditpart.getDiagramView()).getElement() instanceof DSemanticDiagram) {
            DSemanticDiagram ddDiagram = (DSemanticDiagram)diagram.getElement();
            return ddDiagram;
        }
        return null;
    }

    public DiagramEditorWithFlyOutPalette getActiveDiagramEditor() {
        IEditorPart activeEditor;
        DiagramEditorWithFlyOutPalette result = this.activeDiagramEditor;
        if (result == null && (activeEditor = this.getWorkbenchPage().getActiveEditor()) instanceof IMultiDiagramEditor && (activeEditor = ((IMultiDiagramEditor)activeEditor).getActiveEditor()) instanceof DiagramEditorWithFlyOutPalette) {
            result = (DiagramEditorWithFlyOutPalette)activeEditor;
            this.setActiveDiagramEditor(result);
        }
        MatcherAssert.assertThat((String)"No diagram active", (Object)result, (Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public AbstractEMFNattableEditor getActiveTableEditor() {
        IEditorPart activeEditor;
        AbstractEMFNattableEditor result = this.activeTableEditor;
        if (result == null && (activeEditor = this.getWorkbenchPage().getActiveEditor()) instanceof IMultiDiagramEditor && (activeEditor = ((IMultiDiagramEditor)activeEditor).getActiveEditor()) instanceof AbstractEMFNattableEditor) {
            result = (AbstractEMFNattableEditor)activeEditor;
            this.setActiveTableEditor(result);
        }
        MatcherAssert.assertThat((String)"No table active", (Object)result, (Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public INattableModelManager getActiveTableManager() {
        return (INattableModelManager)this.getActiveTableEditor().getAdapter(INattableModelManager.class);
    }

    /*
     * WARNING - void declaration
     */
    public Request getAspectUnspecifiedCreateRequest(final Tool tool) throws Exception {
        final IDiagramGraphicalViewer viewer = this.getActiveDiagramEditor().getDiagramGraphicalViewer();
        final AtomicReference exception = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    tool.setViewer((EditPartViewer)viewer);
                }
                catch (Exception ex) {
                    exception.set(ex);
                }
            }
        });
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        Tool tool2 = tool;
        if (tool2 instanceof AspectUnspecifiedTypeCreationTool) {
            void creationTool;
            AspectUnspecifiedTypeCreationTool aspectUnspecifiedTypeCreationTool = (AspectUnspecifiedTypeCreationTool)tool2;
            AspectUnspecifiedTypeCreationTool cfr_ignored_0 = (AspectUnspecifiedTypeCreationTool)tool2;
            return creationTool.createCreateRequest();
        }
        Tool tool3 = tool;
        if (tool3 instanceof AspectUnspecifiedTypeConnectionTool) {
            void connectionTool;
            AspectUnspecifiedTypeConnectionTool aspectUnspecifiedTypeConnectionTool = (AspectUnspecifiedTypeConnectionTool)tool3;
            AspectUnspecifiedTypeConnectionTool cfr_ignored_1 = (AspectUnspecifiedTypeConnectionTool)tool3;
            void v0 = connectionTool;
            v0.getClass();
            return new AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest((AspectUnspecifiedTypeConnectionTool)v0, connectionTool.getElementTypes(), false, this.getPreferencesHint());
        }
        throw new Exception("Unexpected kind of creation tool.");
    }

    public DiagramEditPart getDiagram(IMultiDiagramEditor editor, final String name) {
        IDiagramWorkbenchPart diagramPart;
        ISashWindowsContainer sashContainer = (ISashWindowsContainer)PlatformHelper.getAdapter((Object)editor, ISashWindowsContainer.class);
        final org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[] matchedPage = new org.eclipse.papyrus.infra.core.sasheditor.editor.IPage[1];
        sashContainer.visit(new IPageVisitor(){

            public void accept(IComponentPage page) {
            }

            public void accept(IEditorPage page) {
                if (name.equals(page.getPageTitle()) && page.getIEditorPart() instanceof DiagramEditorWithFlyOutPalette) {
                    matchedPage[0] = page;
                }
            }
        });
        IEditorPage editorPage = (IEditorPage)TypeUtils.as((Object)matchedPage[0], IEditorPage.class);
        IDiagramWorkbenchPart iDiagramWorkbenchPart = diagramPart = editorPage == null ? null : (IDiagramWorkbenchPart)TypeUtils.as((Object)editorPage.getIEditorPart(), IDiagramWorkbenchPart.class);
        if (diagramPart != null) {
            if (diagramPart.getDiagramEditPart() == null) {
                diagramPart.setFocus();
            }
            return diagramPart.getDiagramEditPart();
        }
        return null;
    }

    public DiagramEditPart getDiagram(String name) {
        return this.getDiagram(this.editor, name);
    }

    public TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain result = null;
        if (this.editor != null) {
            result = this.getEditingDomain(this.editor);
        }
        return result;
    }

    public TransactionalEditingDomain getEditingDomain(IMultiDiagramEditor editor) {
        TransactionalEditingDomain result = null;
        try {
            result = (TransactionalEditingDomain)this.getServiceRegistry(editor).getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to get editing domain from Papyrus editor: " + e.getLocalizedMessage()));
        }
        return result;
    }

    public IMultiDiagramEditor getEditor() {
        return this.editor;
    }

    public IMultiDiagramEditor getEditor(String path) {
        IMultiDiagramEditor result = null;
        String fileName = new Path(path).lastSegment();
        IEditorReference[] iEditorReferenceArray = this.getWorkbenchPage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference next = iEditorReferenceArray[n2];
            if ("org.eclipse.papyrus.infra.core.papyrusEditor".equals(next.getId()) && fileName.equals(next.getName())) {
                result = (IMultiDiagramEditor)next.getEditor(true);
            }
            ++n2;
        }
        return result;
    }

    public String getLabel(EObject object) {
        String result = null;
        try {
            IItemLabelProvider labels;
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.editor.getServicesRegistry());
            if (domain instanceof AdapterFactoryEditingDomain && (labels = (IItemLabelProvider)((AdapterFactoryEditingDomain)domain).getAdapterFactory().adapt((Notifier)object, IItemLabelProvider.class)) != null) {
                result = labels.getText((Object)object);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (result == null) {
            result = String.valueOf(object);
        }
        return result;
    }

    public Package getModel() {
        return this.getModel(this.editor);
    }

    public Package getModel(IMultiDiagramEditor editor) {
        Package result = null;
        ModelSet modelSet = this.getModelSet(editor);
        UmlModel uml = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        MatcherAssert.assertThat((String)"No UML model present in resource set", (Object)uml.getResource(), (Matcher)CoreMatchers.notNullValue());
        result = (Package)EcoreUtil.getObjectByType((Collection)uml.getResource().getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        MatcherAssert.assertThat((String)"Model resource contains no UML Package", (Object)result, (Matcher)CoreMatchers.notNullValue());
        return result;
    }

    public ModelExplorerView getModelExplorerView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ModelExplorerPageBookView view;
                try {
                    view = (ModelExplorerPageBookView)SiriusDiagramEditorFixture.this.getWorkbenchPage().showView("org.eclipse.papyrus.views.modelexplorer.modelexplorer");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                    return;
                }
                IPage currentPage = view.getCurrentPage();
                ModelExplorerPage page = (ModelExplorerPage)currentPage;
                IViewPart viewer = page.getViewer();
                SiriusDiagramEditorFixture.this.modelExplorer = (ModelExplorerView)viewer;
            }
        });
        return this.modelExplorer;
    }

    public ModelSet getModelSet() {
        return this.getModelSet(this.editor);
    }

    public ModelSet getModelSet(IMultiDiagramEditor editor) {
        try {
            return (ModelSet)this.getServiceRegistry(editor).getService(ModelSet.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to get model set from Papyrus editor: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public IPageManager getPageManager() {
        return this.getPageManager(this.editor);
    }

    public IPageManager getPageManager(IMultiDiagramEditor editor) {
        try {
            return (IPageManager)this.getServiceRegistry(editor).getService(IPageManager.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to get page manager from Papyrus editor: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public PaletteViewer getPalette() {
        return this.getPalette((IDiagramWorkbenchPart)this.getActiveDiagramEditor());
    }

    public PaletteViewer getPalette(IDiagramWorkbenchPart editor) {
        return editor.getDiagramEditPart().getViewer().getEditDomain().getPaletteViewer();
    }

    public PaletteViewer getPalette(IMultiDiagramEditor editor) {
        IEditorPart activeEditor = editor.getActiveEditor();
        MatcherAssert.assertThat((String)"No diagram active", (Object)activeEditor, (Matcher)CoreMatchers.instanceOf(DiagramEditor.class));
        return this.getPalette((IDiagramWorkbenchPart)((DiagramEditor)activeEditor));
    }

    public Tool getPaletteTool(String paletteToolId) {
        PaletteRoot paletteRoot = this.getActiveDiagramEditor().getDiagramGraphicalViewer().getEditDomain().getPaletteViewer().getPaletteRoot();
        List allToolEntries = PaletteUtil.getAllToolEntries((PaletteContainer)paletteRoot);
        return allToolEntries.stream().filter(entry -> entry.getId().equals(paletteToolId)).findAny().map(ToolEntry::createTool).orElse(null);
    }

    public List<IWorkbenchPart> getPartStack(IWorkbenchPart part) {
        MPart mpart = (MPart)part.getSite().getService(MPart.class);
        EModelService modelService = (EModelService)mpart.getContext().get(EModelService.class);
        MPartStack stack = (MPartStack)modelService.getContainer((MUIElement)mpart);
        ArrayList result = Lists.newArrayListWithCapacity((int)stack.getChildren().size());
        for (MPart next : Iterables.filter((Iterable)stack.getChildren(), MPart.class)) {
            IWorkbenchPart wbPart = (IWorkbenchPart)next.getContext().get(IWorkbenchPart.class);
            if (wbPart == null) continue;
            result.add(wbPart);
        }
        return result;
    }

    public PreferencesHint getPreferencesHint() {
        RootEditPart rootEditPart;
        PreferencesHint result = PreferencesHint.USE_DEFAULTS;
        if (this.activeDiagramEditor != null && (rootEditPart = this.activeDiagramEditor.getDiagramGraphicalViewer().getRootEditPart()) instanceof IDiagramPreferenceSupport) {
            result = ((IDiagramPreferenceSupport)rootEditPart).getPreferencesHint();
        }
        return result;
    }

    public ServicesRegistry getServiceRegistry() {
        return this.getServiceRegistry(this.editor);
    }

    public ServicesRegistry getServiceRegistry(IMultiDiagramEditor editor) {
        return editor.getServicesRegistry();
    }

    public Session getSession() {
        return this.session;
    }

    public EditPart getShapeCompartment(EditPart shapeEditPart) {
        return SiriusDiagramEditorFixture.stream(shapeEditPart.getChildren(), EditPart.class).filter(ShapeCompartmentEditPart.class::isInstance).findFirst().orElseGet(SiriusDiagramEditorFixture.failOnAbsence("No shape compartment"));
    }

    public IViewPart getView(String id, boolean open) {
        IViewPart result = null;
        IWorkbenchPage wbPage = this.getWorkbenchPage();
        try {
            try {
                result = wbPage.findView(id);
                if (result == null && open) {
                    result = wbPage.showView(id);
                }
                if (result != null) {
                    result.getSite().getPage().activate((IWorkbenchPart)result);
                    this.flushDisplayEvents();
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to show a view: " + id));
                this.flushDisplayEvents();
            }
        }
        finally {
            this.flushDisplayEvents();
        }
        return result;
    }

    public void move(GraphicalEditPart editPart, Point newLocation) {
        ChangeBoundsRequest move = new ChangeBoundsRequest((Object)"move");
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds();
        move.setEditParts((EditPart)editPart);
        move.setConstrainedMove(false);
        move.setMoveDelta(SiriusDiagramEditorFixture.at(newLocation.x() - bounds.x(), newLocation.y() - bounds.y()));
        this.execute(editPart.getCommand((Request)move));
    }

    public IMultiDiagramEditor open() {
        return this.openOne(this.testDescription);
    }

    public IMultiDiagramEditor open(String resourcePath) {
        return this.open(new Path(resourcePath).removeFileExtension().lastSegment(), AbstractModelFixture.ResourceKind.BUNDLE, resourcePath);
    }

    public IMultiDiagramEditor open(String targetPath, AbstractModelFixture.ResourceKind resourceKind, String resourcePath) {
        IFile papyrusModel = this.getProject().getFile(this.initModelResource(targetPath, resourceKind, resourcePath).getURI().trimFileExtension().appendFileExtension("di"));
        return this.open(papyrusModel);
    }

    public IMultiDiagramEditor open(String targetPath, String resourcePath) {
        return this.open(targetPath, AbstractModelFixture.ResourceKind.BUNDLE, resourcePath);
    }

    public SiriusDiagramEditorFixture openDiagram(IMultiDiagramEditor editor, String name) {
        this.activate((IWorkbenchPart)editor);
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)editor.getServicesRegistry());
            SiriusDiagramModel representation = (SiriusDiagramModel)modelSet.getModel("org.eclipse.papyrus.sirius.editor.DSemanticDiagram");
            DSemanticDiagram diagram = representation.getDiagram(name);
            this.openEditor(diagram);
            this.flushDisplayEvents();
            this.activateDiagram(editor, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Cannot initialize test", e);
        }
        return this;
    }

    public SiriusDiagramEditorFixture openDiagram(String name) {
        return this.openDiagram(this.editor, name);
    }

    public SiriusDiagramEditorFixture openTable(IMultiDiagramEditor editor, String name) {
        this.activate((IWorkbenchPart)editor);
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)editor.getServicesRegistry());
            PapyrusNattableModel representation = (PapyrusNattableModel)modelSet.getModel("org.eclipse.papyrus.infra.nattable.resource.NattableModel");
            Table table = representation.getTable(name);
            ((IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)editor.getServicesRegistry())).openPage((Object)table);
            this.flushDisplayEvents();
            this.activateTable(editor, name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize test", e);
        }
        return this;
    }

    public SiriusDiagramEditorFixture openTable(String name) {
        return this.openTable(this.editor, name);
    }

    public void redo() {
        super.redo();
        this.flushDisplayEvents();
    }

    public IMultiDiagramEditor reopen() {
        return this.reopenOne(this.testDescription);
    }

    public EditPart requireEditPart(EditPart scope, EObject modelElement) {
        EditPart result = this.findEditPart(scope, modelElement);
        if (result == null) {
            String label = this.getLabel(modelElement);
            Assert.fail((String)String.format("No edit-part found for \"%s\" in %s", label, scope));
        }
        return result;
    }

    public void resize(GraphicalEditPart editPart, Dimension newSize) {
        ChangeBoundsRequest resize = new ChangeBoundsRequest((Object)"resize");
        IFigure figure = editPart.getFigure();
        Rectangle bounds = figure.getBounds();
        resize.setEditParts((EditPart)editPart);
        resize.setResizeDirection(12);
        resize.setCenteredResize(false);
        resize.setConstrainedResize(false);
        resize.setSizeDelta(SiriusDiagramEditorFixture.sized(newSize.width() - bounds.width(), newSize.height() - bounds.height()));
        this.execute(editPart.getCommand((Request)resize));
    }

    public void save() {
        this.save((ISaveablePart)this.getEditor());
    }

    public void save(ISaveablePart part) {
        if (part.isDirty()) {
            try {
                try {
                    part.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Failed to save editor/view: " + e.getLocalizedMessage()));
                    this.flushDisplayEvents();
                }
            }
            finally {
                this.flushDisplayEvents();
            }
        }
    }

    public void saveAll() {
        try {
            IWorkbenchPage page = this.editor.getSite().getPage();
            page.saveAllEditors(false);
        }
        finally {
            this.flushDisplayEvents();
        }
    }

    public void select(EditPart editPart) {
        editPart.getViewer().getSelectionManager().appendSelection(editPart);
    }

    public void splitEditorArea(IEditorPart editorToMove, boolean splitHorizontally) {
        MPart editorPart = (MPart)editorToMove.getSite().getService(MPart.class);
        EModelService modelService = (EModelService)editorPart.getContext().get(EModelService.class);
        MPartStack oldStack = (MPartStack)modelService.getContainer((MUIElement)editorPart);
        MPartStack newStack = (MPartStack)modelService.createModelElement(MPartStack.class);
        modelService.insert((MPartSashContainerElement)newStack, (MPartSashContainerElement)oldStack, splitHorizontally ? 3 : 1, 0.5f);
        newStack.getChildren().add(editorPart);
        this.activate((IWorkbenchPart)editorToMove);
    }

    public void undo() {
        super.undo();
        this.flushDisplayEvents();
    }

    private IGraphicalEditPart getNewEditPart(EditPart context, Collection<? extends CreateViewRequest.ViewDescriptor> viewDescriptors) {
        return viewDescriptors.stream().map(desc -> desc.getAdapter(View.class)).map(View.class::cast).filter(Objects::nonNull).map(view -> DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)context)).filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).findAny().orElseGet(SiriusDiagramEditorFixture.failOnAbsence("Could not find newly created edit-part"));
    }

    private IPageManager getPageManager(ServicesRegistry servicesRegistry) {
        try {
            return (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)servicesRegistry);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    private AbstractToolDescription getTool(List<AbstractToolDescription> tools, String toolName) {
        AbstractToolDescription theAbstractToolDescription = null;
        int i = 0;
        while (i < tools.size()) {
            AbstractToolDescription tool = tools.get(i);
            String name = tool.getName();
            if (name != null && name.equals(toolName)) {
                theAbstractToolDescription = tool;
                break;
            }
            ++i;
        }
        return theAbstractToolDescription;
    }

    /*
     * WARNING - void declaration
     */
    private void movePartRelativeTo(IWorkbenchPart part, String relativeTo, int where) {
        MPart mPart = (MPart)part.getSite().getService(MPart.class);
        EModelService modelService = (EModelService)mPart.getContext().get(EModelService.class);
        MUIElement relativePart = modelService.find(relativeTo, (MUIElement)modelService.getTopLevelWindowFor((MUIElement)mPart));
        if (relativePart instanceof MPartSashContainerElement) {
            MPart toMove = mPart;
            MPlaceholder placeHolder = mPart.getCurSharedRef();
            if (placeHolder != null) {
                toMove = placeHolder;
            }
            if (where < 0) {
                MUIElement mUIElement = relativePart;
                if (mUIElement instanceof MPart) {
                    void relativeMPart;
                    MPart mPart2 = (MPart)mUIElement;
                    MPart cfr_ignored_0 = (MPart)mUIElement;
                    if (relativeMPart.getCurSharedRef() != null) {
                        relativePart = relativeMPart.getCurSharedRef();
                    }
                }
                relativePart.getParent().getChildren().add(toMove);
            } else {
                MPartStack newStack = (MPartStack)modelService.createModelElement(MPartStack.class);
                newStack.getChildren().add(toMove);
                modelService.insert((MPartSashContainerElement)newStack, (MPartSashContainerElement)relativePart, where, 0.3f);
            }
        }
    }

    private void setActiveDiagramEditor(DiagramEditorWithFlyOutPalette editor) {
        this.activeDiagramEditor = editor;
        this.activeTableEditor = null;
    }

    private void setActiveTableEditor(AbstractEMFNattableEditor editor) {
        this.activeTableEditor = editor;
        this.activeDiagramEditor = null;
    }

    public final boolean applyContainerCreationTool(String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof ContainerCreationDescription || tool instanceof NodeCreationDescription || tool instanceof ToolDescription) {
            Command command = this.getCommand(container, tool);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
            boolean canExecute = command.canExecute();
            domain.getCommandStack().execute(command);
            return canExecute;
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    public final boolean applyContainerDropDescriptionTool(DDiagram diagram, String dndToolName, DragAndDropTarget dropContainer, DDiagramElement droppedDDiagramElement) {
        boolean result = false;
        AbstractToolDescription dndTool = this.getTool(diagram, dndToolName);
        if (dndTool instanceof ContainerDropDescription) {
            Command command = this.getCommandFactory().buildDropInContainerCommandFromTool(dropContainer, droppedDDiagramElement, (ContainerDropDescription)dndTool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applyContainerDropDescriptionTool(DDiagram diagram, String dndToolName, DragAndDropTarget dropContainer, EObject droppedElement) {
        boolean result = false;
        AbstractToolDescription dndTool = this.getTool(diagram, dndToolName);
        if (dndTool instanceof ContainerDropDescription) {
            Command command = this.getCommandFactory().buildDropInContainerCommandFromTool(dropContainer, droppedElement, (ContainerDropDescription)dndTool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applySemanticDeletionTool(DDiagramElement element) {
        boolean result = false;
        Command command = this.getCommandFactory().buildDeleteDiagramElement(element);
        this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        return result;
    }

    public final boolean applyGraphicalDeletionTool(DDiagramElement element) {
        boolean result = false;
        Command command = this.getCommandFactory().buildDeleteFromDiagramCommand(element);
        this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        return result;
    }

    public final boolean applyDirectEditTool(String toolName, DDiagram diagram, DDiagramElement element, String value) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof DirectEditLabel) {
            Command command = this.getCommandFactory().buildDirectEditLabelFromTool((DRepresentationElement)element, (DirectEditLabel)tool, value);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applyEdgeCreationTool(String toolName, DDiagram diagram, EdgeTarget source, EdgeTarget target) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof EdgeCreationDescription) {
            Command command = this.getCommandFactory().buildCreateEdgeCommandFromTool(source, target, (EdgeCreationDescription)tool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applyEdgeReconnectionTool(String toolName, DDiagram diagram, DEdge edge, EdgeTarget source, EdgeTarget target) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof ReconnectEdgeDescription) {
            Command command = this.getCommandFactory().buildReconnectEdgeCommandFromTool((ReconnectEdgeDescription)tool, edge, source, target);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applyGenericTool(String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool instanceof ToolDescription) {
            Command command = this.getCommand(container, tool);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
            boolean canExecute = command.canExecute();
            domain.getCommandStack().execute(command);
            return canExecute;
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    public final boolean applyNodeCreationTool(String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool != null) {
            Command command = this.getCommand(container, tool);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)container);
            boolean canExecute = command.canExecute();
            domain.getCommandStack().execute(command);
            return canExecute;
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    public final boolean applyNodeCreationTool(String layerName, String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool;
        boolean result = false;
        Layer layer = this.getLayer(diagram, layerName);
        if (layer != null && (tool = this.getTool(layer, toolName)) != null) {
            Command command = this.getCommand(container, tool);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applySelectionTool(String toolName, DDiagram diagram, EObject container) {
        boolean result = false;
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool != null) {
            Collection<EObject> selectedElements = this.getSelectedEObject(tool, diagram, container);
            Command command = this.getCommand(container, tool, selectedElements);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    public final boolean applySelectionTool(String layerName, String toolName, DDiagram diagram, EObject container) {
        AbstractToolDescription tool;
        boolean result = false;
        Layer layer = this.getLayer(diagram, layerName);
        if (layer != null && (tool = this.getTool(layer, toolName)) != null) {
            Collection<EObject> selectedElements = this.getSelectedEObject(tool, diagram, container);
            Command command = this.getCommand(container, tool, selectedElements);
            result = command.canExecute();
            this.session.getTransactionalEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected void arrangeAll(DiagramEditPart diagramEditPart) {
        ArrangeRequest arrangeRequest = new ArrangeRequest("arrangeAllAction");
        ArrayList<DiagramEditPart> partsToArrange = new ArrayList<DiagramEditPart>();
        partsToArrange.add(diagramEditPart);
        arrangeRequest.setPartsToArrange(partsToArrange);
        diagramEditPart.performRequest((Request)arrangeRequest);
    }

    protected void closeRequiredViews() {
        if (this.viewsToClose != null) {
            for (IViewPart closeMe : this.viewsToClose) {
                closeMe.getSite().getPage().hideView(closeMe);
            }
            this.viewsToClose = null;
            this.flushDisplayEvents();
        }
    }

    protected TransactionalEditingDomain createEditingDomain() {
        return null;
    }

    protected void finished(Description description) {
        try {
            this.modelFiles = null;
            Throwable exception = null;
            for (IEditorPart editor : ImmutableList.copyOf(this.editorsToClose)) {
                try {
                    this.close(editor);
                }
                catch (Exception e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                exception.printStackTrace();
                Assert.fail((String)("Failed to close an editor: " + exception.getLocalizedMessage()));
            }
        }
        finally {
            try {
                if (this.operationHistoryIntegrityListener != null) {
                    this.operationHistory.removeOperationHistoryListener(this.operationHistoryIntegrityListener);
                    this.operationHistoryIntegrityListener = null;
                    this.operationHistory = null;
                }
            }
            finally {
                this.editorsToClose.clear();
                this.editor = null;
                this.activeDiagramEditor = null;
                EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(this.initialEditorLayoutStorageMigrationPreference);
                try {
                    if (this.hasRequiredViews()) {
                        this.closeRequiredViews();
                    }
                }
                finally {
                    super.finished(description);
                }
            }
        }
    }

    protected final Command getCommand(EObject container, AbstractToolDescription tool) {
        Command cmd = null;
        if (tool instanceof NodeCreationDescription) {
            if (container instanceof DDiagram) {
                cmd = this.getCommandFactory().buildCreateNodeCommandFromTool((DDiagram)container, (NodeCreationDescription)tool);
            } else if (container instanceof DDiagramElementContainer) {
                cmd = this.getCommandFactory().buildCreateNodeCommandFromTool((DDiagramElementContainer)container, (NodeCreationDescription)tool);
            } else if (container instanceof DNode) {
                cmd = this.getCommandFactory().buildCreateNodeCommandFromTool((DNode)container, (NodeCreationDescription)tool);
            }
        } else if (tool instanceof ContainerCreationDescription) {
            if (container instanceof DDiagram) {
                cmd = this.getCommandFactory().buildCreateContainerCommandFromTool((DDiagram)container, (ContainerCreationDescription)tool);
            } else if (container instanceof DDiagramElementContainer) {
                cmd = this.getCommandFactory().buildCreateContainerCommandFromTool((DDiagramElementContainer)container, (ContainerCreationDescription)tool);
            }
        } else if (tool instanceof ToolDescription) {
            cmd = this.getCommandFactory().buildGenericToolCommandFromTool(container, (ToolDescription)tool);
        }
        return cmd;
    }

    protected IDiagramCommandFactory getCommandFactory() {
        if (this.commandFactory == null) {
            this.commandFactory = DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.getEditingDomain());
            this.commandFactory.setUserInterfaceCallBack((UICallBack)new NoUICallback());
        }
        return this.commandFactory;
    }

    protected final ShowView getRequiredViews() {
        ShowView result = (ShowView)this.testDescription.getAnnotation(ShowView.class);
        if (result == null) {
            Class<?> clazz = this.testClass;
            while (result == null && clazz != null && clazz != Object.class) {
                result = clazz.getAnnotation(ShowView.class);
                clazz = clazz.getSuperclass();
            }
        }
        return result;
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final AbstractToolDescription getTool(DDiagram diagram, String toolName) {
        List tools = DiagramComponentizationTestSupport.getAllTools((Session)this.session, (DiagramDescription)diagram.getDescription());
        return this.getTool(tools, toolName);
    }

    protected final IWorkbenchPage getWorkbenchPage() {
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null) {
            window = bench.getWorkbenchWindows()[0];
        }
        return window.getActivePage();
    }

    protected final boolean hasRequiredViews() {
        return this.getRequiredViews() != null;
    }

    protected IMultiDiagramEditor open(final IFile modelFile) {
        boolean firstEditor = this.editorsToClose.isEmpty();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    SiriusDiagramEditorFixture.this.editor = EditorUtils.openPapyrusEditor((IFile)modelFile);
                    SiriusDiagramEditorFixture.this.editorsToClose.add((IEditorPart)SiriusDiagramEditorFixture.this.editor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)("Failed to open Papyrus editor: " + e.getLocalizedMessage()));
                }
            }
        });
        if (firstEditor && !this.editorsToClose.isEmpty()) {
            final IWorkbenchPage page = this.editor.getSite().getPage();
            page.addPartListener(new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    SiriusDiagramEditorFixture.this.editorsToClose.remove(part);
                    if (part == SiriusDiagramEditorFixture.this.editor) {
                        SiriusDiagramEditorFixture.this.editor = null;
                    }
                    if (SiriusDiagramEditorFixture.this.editorsToClose.isEmpty()) {
                        page.removePartListener((IPartListener)this);
                    }
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partOpened(IWorkbenchPart part) {
                }
            });
        }
        this.flushDisplayEvents();
        return this.editor;
    }

    protected Iterable<IMultiDiagramEditor> openAll(Description description) {
        ArrayList result = Lists.newArrayList();
        for (Resource resource : this.initModelResources(description)) {
            if (!resource.getURI().fileExtension().equals("uml")) continue;
            IFile papyrusModel = this.getProject().getFile(resource.getURI().trimFileExtension().appendFileExtension("di"));
            this.modelFiles.put((Object)description, (Object)papyrusModel);
            result.add(this.open(papyrusModel));
        }
        return result;
    }

    protected final void openEditor(DSemanticDiagram proto) {
        ServicesRegistry sReg = this.getServiceRegistry(proto.getTarget());
        if (sReg == null) {
            return;
        }
        IPageManager pageManager = this.getPageManager(sReg);
        if (pageManager == null) {
            return;
        }
        pageManager.openPage((Object)proto);
    }

    protected IMultiDiagramEditor openOne(Description description) {
        IFile papyrusModel = this.getProject().getFile(((Resource)Iterables.getOnlyElement((Iterable)this.initModelResources(description))).getURI().trimFileExtension().appendFileExtension("di"));
        this.modelFiles.put((Object)description, (Object)papyrusModel);
        return this.open(papyrusModel);
    }

    protected void openRequiredViews() {
        IWorkbenchPage page = this.getWorkbenchPage();
        for (ShowViewDescriptor next : ShowViewDescriptor.getDescriptors(this.getRequiredViews())) {
            IViewPart part = page.findView(next.viewID());
            if (part != null) continue;
            try {
                part = page.showView(next.viewID());
                this.movePartRelativeTo((IWorkbenchPart)part, next.relativeTo(), next.location());
                if (this.viewsToClose == null) {
                    this.viewsToClose = Lists.newArrayListWithExpectedSize((int)1);
                }
                this.viewsToClose.add(part);
            }
            catch (PartInitException e) {
                e.printStackTrace();
                Assert.fail((String)("Failed to open required view: " + e.getLocalizedMessage()));
            }
        }
        this.flushDisplayEvents();
    }

    protected IMultiDiagramEditor reopenOne(Description description) {
        IFile papyrusModel = (IFile)this.modelFiles.get((Object)description).get(0);
        return this.open(papyrusModel);
    }

    protected void starting(Description description) {
        this.testClass = description.getTestClass();
        this.testDescription = description;
        this.initialEditorLayoutStorageMigrationPreference = EditorPreferences.getInstance().getConvertSharedPageLayoutToPrivate();
        EditorPreferences.getInstance().setConvertSharedPageLayoutToPrivate(YesNo.NO);
        if (this.hasRequiredViews()) {
            this.openRequiredViews();
        }
        this.modelFiles = ArrayListMultimap.create();
        this.openAll(description);
        ActiveDiagram activeDiagram = (ActiveDiagram)JUnitUtils.getAnnotation((Description)description, ActiveDiagram.class);
        if (activeDiagram != null) {
            String name = activeDiagram.value();
            this.activateDiagram(name);
            if (this.activeDiagramEditor == null || !name.equals(this.getActiveDiagramEditor().getDiagram().getName())) {
                this.openDiagram(name);
            }
        } else {
            ActiveTable activeTable = (ActiveTable)JUnitUtils.getAnnotation((Description)description, ActiveTable.class);
            if (activeTable != null) {
                String name = activeTable.value();
                this.activateTable(name);
                if (this.activeTableEditor == null || !name.equals(this.getActiveTableEditor().getTable().getName())) {
                    this.openTable(name);
                }
            }
        }
        super.starting(description);
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)this.editor.getServicesRegistry());
            SiriusDiagramModel siriusModel = (SiriusDiagramModel)modelSet.getModel("org.eclipse.papyrus.sirius.editor.DSemanticDiagram");
            SessionService sessionService = (SessionService)this.editor.getServicesRegistry().getService((Object)"org.eclipse.papyrus.sirius.editor.sirius.ISiriusSessionService");
            this.session = sessionService.getSiriusSession();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        if (this.ensureOperationHistoryIntegrity) {
            IWorkspaceCommandStack stack = (IWorkspaceCommandStack)this.getEditingDomain().getCommandStack();
            final IUndoContext emfContext = stack.getDefaultUndoContext();
            this.operationHistory = stack.getOperationHistory();
            this.operationHistoryIntegrityListener = new IOperationHistoryListener(){

                public void historyNotification(OperationHistoryEvent event) {
                    IUndoableOperation undo;
                    IUndoContext diagramContext;
                    if (DUMP_COMMANDS && event.getEventType() == 1) {
                        System.err.println(">> Executing command");
                        CommandUtils.dump((Object)event.getOperation());
                        System.err.println();
                    }
                    if (event.getEventType() == 4 && SiriusDiagramEditorFixture.this.activeDiagramEditor != null && (diagramContext = SiriusDiagramEditorFixture.this.activeDiagramEditor.getDiagramEditDomain().getDiagramCommandStack().getUndoContext()) != null && (undo = event.getOperation()) != null && !undo.hasContext(emfContext)) {
                        undo.addContext(emfContext);
                    }
                }
            };
            this.operationHistory.addOperationHistoryListener(this.operationHistoryIntegrityListener);
        }
    }

    protected final Layer getLayer(DDiagram diagram, String layerName) {
        List layers = DiagramComponentizationTestSupport.getAllLayers((Session)this.session, (DiagramDescription)diagram.getDescription());
        for (Layer layer : layers) {
            if (!layer.getName().equals(layerName)) continue;
            return layer;
        }
        throw new IllegalArgumentException(LAYER_NAME_INCORRECT);
    }

    protected final AbstractToolDescription getTool(Layer layer, String toolName) {
        return this.getTool((List<AbstractToolDescription>)layer.getAllTools(), toolName);
    }

    protected Collection<EObject> getSelectedEObject(AbstractToolDescription tool, DDiagram diagram, EObject container) {
        return Collections.emptyList();
    }

    protected Command getCommand(EObject container, AbstractToolDescription tool, Collection<EObject> selectedElements) {
        Command cmd = null;
        if (tool instanceof SelectionWizardDescription && container instanceof DSemanticDecorator) {
            cmd = this.getCommandFactory().buildSelectionWizardCommandFromTool((SelectionWizardDescription)tool, (DSemanticDecorator)container, selectedElements);
        } else if (tool instanceof OperationAction) {
            cmd = this.getCommandFactory().buildOperationActionFromTool((OperationAction)tool, (Collection)selectedElements.stream().filter(DSemanticDecorator.class::isInstance).map(DSemanticDecorator.class::cast).collect(Collectors.toList()));
        }
        return cmd;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean applyNodeCreationToolFromPalette(String toolName, DDiagram diagram, EObject container, Point location, Dimension size) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        if (tool != null) {
            CreateRequest request;
            DummyCreationTool creationTool = this.createPaletteTool(tool);
            EditPart targetEditPart = this.findEditPart(container);
            creationTool.setTargetEditPart(targetEditPart);
            CreateRequest createRequest = request = creationTool.getTargetRequest();
            if (createRequest instanceof CreateRequest) {
                void requestcreation;
                CreateRequest createRequest2 = createRequest;
                requestcreation.setLocation(location);
                requestcreation.setSize(size);
            }
            org.eclipse.gef.commands.Command command = targetEditPart.getCommand((Request)request);
            this.getEditingDomain().getCommandStack().execute(GEFtoEMFCommandWrapper.wrap((org.eclipse.gef.commands.Command)command));
            return command.canExecute();
        }
        throw new IllegalArgumentException(TOOL_NAME_INCORRECT);
    }

    private DummyCreationTool createPaletteTool(AbstractToolDescription tool) {
        AbstractToolDescription containerCreation = tool;
        ToolBasedCreationFactory creationFactory = new ToolBasedCreationFactory(containerCreation);
        CreationToolEntry paletteEntry = new CreationToolEntry(containerCreation.getName(), containerCreation.getDocumentation(), (CreationFactory)creationFactory, null, null);
        paletteEntry.setToolClass(DummyCreationTool.class);
        DummyCreationTool creationTool = (DummyCreationTool)paletteEntry.createTool();
        creationTool.setViewer((EditPartViewer)this.getActiveDiagramEditor().getDiagramGraphicalViewer());
        return creationTool;
    }

    public boolean applyEdgeCreationToolFromPalette(String toolName, DDiagram diagram, EdgeTarget element1, EdgeTarget element2, Point absoluteStartPoint, Point absoluteEndPoint) {
        AbstractToolDescription tool = this.getTool(diagram, toolName);
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)this.findEditPart((EObject)element1);
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart)this.findEditPart((EObject)element2);
        CreateConnectionRequest createConnectionRequest = new CreateConnectionRequest();
        createConnectionRequest.setSourceEditPart((EditPart)sourceEditPart);
        createConnectionRequest.setTargetEditPart((EditPart)targetEditPart);
        createConnectionRequest.setType((Object)"connection start");
        createConnectionRequest.setLocation(absoluteStartPoint);
        createConnectionRequest.setFactory((CreationFactory)new ToolBasedCreationFactory(tool));
        sourceEditPart.showSourceFeedback((Request)createConnectionRequest);
        targetEditPart.showTargetFeedback((Request)createConnectionRequest);
        try {
            org.eclipse.gef.commands.Command startCommand = sourceEditPart.getCommand((Request)createConnectionRequest);
            if (startCommand.canExecute()) {
                createConnectionRequest.setType((Object)"connection end");
                createConnectionRequest.setLocation(absoluteEndPoint);
                Command endCommand = GEFtoEMFCommandWrapper.wrap((org.eclipse.gef.commands.Command)targetEditPart.getCommand((Request)createConnectionRequest));
                if (endCommand.canExecute()) {
                    this.getEditingDomain().getCommandStack().execute(endCommand);
                    return true;
                }
            }
        }
        finally {
            sourceEditPart.eraseSourceFeedback((Request)createConnectionRequest);
            targetEditPart.eraseTargetFeedback((Request)createConnectionRequest);
        }
        return false;
    }

    public static class DummyCreationTool
    extends CreationTool {
        public void setTargetEditPart(EditPart editpart) {
            super.setTargetEditPart(editpart);
        }

        public CreateRequest getTargetRequest() {
            return super.getTargetRequest();
        }
    }

    private static final class ShowViewDescriptor {
        private static final ShowView.Location DEFAULT_LOCATION_EDITORS = ShowView.Location.RIGHT;
        private static final ShowView.Location DEFAULT_LOCATION_VIEW = ShowView.Location.STACKED;
        private static final String DEFAULT_RELATIVE_TO = "org.eclipse.ui.editorss";
        private final ShowView.Location location;
        private final String relativeTo;
        private final String viewID;

        static Iterable<ShowViewDescriptor> getDescriptors(ShowView annotation) {
            ImmutableList.Builder result = ImmutableList.builder();
            String[] ids = annotation.value();
            int i = 0;
            while (i < ids.length) {
                result.add((Object)new ShowViewDescriptor(annotation, i));
                ++i;
            }
            return result.build();
        }

        private ShowViewDescriptor(ShowView annotation, int index) {
            this.viewID = annotation.value()[index];
            String[] relativeTo = annotation.relativeTo();
            this.relativeTo = relativeTo.length == 0 ? null : (relativeTo.length == 1 ? relativeTo[0] : relativeTo[index]);
            ShowView.Location[] location = annotation.location();
            this.location = location.length == 0 ? null : (location.length == 1 ? location[0] : location[index]);
        }

        int location() {
            return (this.location != null ? this.location : (this.relativeTo == null ? DEFAULT_LOCATION_EDITORS : DEFAULT_LOCATION_VIEW)).toModelServiceLocation();
        }

        String relativeTo() {
            return this.relativeTo != null ? this.relativeTo : DEFAULT_RELATIVE_TO;
        }

        String viewID() {
            return this.viewID;
        }
    }

    private class ToolBasedCreationFactory
    implements CreationFactory {
        AbstractToolDescription toolDesc;

        public ToolBasedCreationFactory(AbstractToolDescription toolDescription) {
            this.toolDesc = toolDescription;
        }

        public Object getNewObject() {
            return this.toolDesc;
        }

        public Object getObjectType() {
            return this.toolDesc.getClass();
        }
    }
}

