/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.textedit.editpart;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.sirius.uml.diagram.textedit.Activator;
import org.eclipse.sirius.diagram.model.business.internal.spec.DNodeSpec;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class XtextSiriusDNodeNameEditPart
extends DNodeNameEditPart
implements ITextAwareEditPart {
    protected IDirectEditorConfiguration configuration;

    public XtextSiriusDNodeNameEditPart(View view) {
        super(view);
    }

    protected void performDirectEditRequest(Request request) {
        EObject resolveSemanticElement = this.resolveSemanticElement();
        if (resolveSemanticElement instanceof DNodeSpec) {
            EObject target = ((DNodeSpec)resolveSemanticElement).getTarget();
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + target.eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (Object)target, (Object)((Object)this)) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (Object)target, (Object)((Object)this));
            this.configuration.preEditAction((Object)target);
        }
        if (this.configuration instanceof ICustomDirectEditorConfiguration) {
            this.setManager(((ICustomDirectEditorConfiguration)this.configuration).createDirectEditManager((ITextAwareEditPart)this));
            this.initializeDirectEditManager(request);
        }
    }

    protected void initializeDirectEditManager(final Request request) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (XtextSiriusDNodeNameEditPart.this.isActive() && XtextSiriusDNodeNameEditPart.this.isEditable()) {
                        if (request.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)request.getExtendedData().get("directedit_extendeddata_initial_char");
                            XtextSiriusDNodeNameEditPart.this.performDirectEdit(initialChar.charValue());
                        } else {
                            XtextSiriusDNodeNameEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEdit() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                XtextSiriusDNodeNameEditPart.this.getManager().show();
            }
        });
    }
}

