/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.codegen;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class TaggedTextMerger {
    private String beginTag;
    private String endTag;

    public TaggedTextMerger(String beginTag, String endTag) {
        this.beginTag = beginTag;
        this.endTag = endTag;
    }

    public String getBeginTag() {
        return this.beginTag;
    }

    public String getEndTag() {
        return this.endTag;
    }

    public String process(String oldText, String newText) {
        int bpos = newText.indexOf(this.getBeginTag());
        if (bpos < 0) {
            return newText;
        }
        int epos = newText.indexOf(this.getEndTag());
        if (epos < 0 || epos <= bpos) {
            return newText;
        }
        StringBuffer sb = new StringBuffer();
        try {
            RegionsIterator regions = new RegionsIterator(oldText);
            if (regions.hasNext()) {
                do {
                    sb.append(regions.next());
                } while (regions.hasNext());
            } else {
                sb.append(newText.substring(bpos + this.getBeginTag().length(), epos));
            }
        }
        catch (NoSuchElementException nsee) {
            return newText;
        }
        return newText.substring(0, bpos + this.getBeginTag().length()) + sb.toString() + newText.substring(epos);
    }

    protected class RegionsIterator
    implements Iterator<String> {
        private String text;
        private int offset;

        public RegionsIterator(String text) {
            assert (text != null);
            this.text = text;
        }

        @Override
        public boolean hasNext() {
            return this.text.indexOf(TaggedTextMerger.this.getBeginTag(), this.offset) > 0;
        }

        @Override
        public String next() {
            int bpos = this.text.indexOf(TaggedTextMerger.this.getBeginTag(), this.offset);
            if (bpos < 0) {
                throw new NoSuchElementException();
            }
            int epos = this.text.indexOf(TaggedTextMerger.this.getEndTag(), bpos + TaggedTextMerger.this.getBeginTag().length());
            if (epos < 0) {
                throw new NoSuchElementException();
            }
            this.offset = epos + TaggedTextMerger.this.getEndTag().length();
            return this.text.substring(bpos + TaggedTextMerger.this.getBeginTag().length(), epos);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

