/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.profile.internal.messages.Messages;
import org.eclipse.papyrus.uml.tools.utils.StaticProfileUtil;
import org.eclipse.uml2.uml.Profile;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class ProfilePluginXMLValidator {
    public static final String CATEGORY = "profile";
    private static final String PACKAGE = "package";
    private static final String GEN_MODEL_ATTRIBUTE = "genModel";
    private static final String GENMODEL_EXTENSION = "genmodel";
    private static final String URI_ATTRIBUTE = "uri";
    private static final String PROFILE = "profile";
    private static final String LOCATION = "location";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String PATH_SEPARATOR = "/";
    private static final String PATHMAP = "pathmap://";
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    private final IFile profileFile;

    ProfilePluginXMLValidator(IFile profileFile) {
        this.profileFile = profileFile;
    }

    Optional<Element> matchExtension(Element element, String point, Profile profile) {
        switch (point) {
            case "org.eclipse.emf.ecore.generated_package": {
                NodeList children = element.getElementsByTagName(PACKAGE);
                int i = 0;
                while (i < children.getLength()) {
                    Element package_ = (Element)children.item(i);
                    if (this.matchEcorePackage(package_, profile)) {
                        return Optional.of(package_);
                    }
                    ++i;
                }
                break;
            }
            case "org.eclipse.uml2.uml.generated_package": {
                NodeList profiles = element.getElementsByTagName("profile");
                int i = 0;
                while (i < profiles.getLength()) {
                    Element profileElement = (Element)profiles.item(i);
                    if (this.matchUML2Package(profileElement, profile)) {
                        return Optional.of(profileElement);
                    }
                    ++i;
                }
                break;
            }
            case "org.eclipse.papyrus.uml.extensionpoints.UMLProfile": {
                if (profile.getNestingPackage() != null) break;
                NodeList profiles = element.getElementsByTagName("profile");
                int i = 0;
                while (i < profiles.getLength()) {
                    Element profileElement = (Element)profiles.item(i);
                    if (this.matchPapyrusProfile(profileElement, profile)) {
                        return Optional.of(profileElement);
                    }
                    ++i;
                }
                break;
            }
        }
        return Optional.empty();
    }

    private boolean matchPapyrusProfile(Element profileElement, Profile profile) {
        String profilePath = this.profileFile.getProjectRelativePath().removeFileExtension().addFileExtension("uml").toString();
        URIConverter converter = profile.eResource().getResourceSet().getURIConverter();
        URI profileFileURI = converter.normalize(URI.createPlatformPluginURI((String)(this.profileFile.getProject().getName() + PATH_SEPARATOR + profilePath), (boolean)true));
        String path = profileElement.getAttribute(PATH);
        if (path == null) {
            return false;
        }
        URI profileElementURI = null;
        profileElementURI = !path.startsWith(PATHMAP) && !path.startsWith(PLATFORM_PLUGIN) ? URI.createPlatformPluginURI((String)(this.profileFile.getProject().getName() + PATH_SEPARATOR + path), (boolean)false) : URI.createURI((String)path);
        URI normalizedProfileElementURI = converter.normalize(profileElementURI);
        return normalizedProfileElementURI.equals(profileFileURI);
    }

    private boolean matchUML2Package(Element profileElement, Profile profile) {
        String extensionNsURI = profileElement.getAttribute(URI_ATTRIBUTE);
        String stereotypeNsURI = ProfilePluginXMLValidator.profileURI(profile);
        if (stereotypeNsURI == null || stereotypeNsURI.isBlank()) {
            return false;
        }
        return Objects.equals(stereotypeNsURI, extensionNsURI);
    }

    boolean matchEcorePackage(Element element, Profile profile) {
        String extensionGenModel = element.getAttribute(GEN_MODEL_ATTRIBUTE);
        IPath projectRelativePath = this.profileFile.getProjectRelativePath();
        IPath genModelFilePath = projectRelativePath.removeFileExtension().addFileExtension(GENMODEL_EXTENSION);
        String genModelFile = genModelFilePath.toString();
        if (Objects.equals(genModelFile, extensionGenModel)) {
            String extensionNsURI = element.getAttribute(URI_ATTRIBUTE);
            String stereotypeNsURI = ProfilePluginXMLValidator.profileURI(profile);
            if (Objects.equals(stereotypeNsURI, extensionNsURI)) {
                return true;
            }
        }
        return false;
    }

    void checkExtension(Element element, String point, Profile profile, PluginErrorReporter.ProblemReport problems) {
        switch (point) {
            case "org.eclipse.emf.ecore.generated_package": {
                String extensionNsURI = element.getAttribute(URI_ATTRIBUTE);
                if (extensionNsURI != null && !extensionNsURI.isBlank()) break;
                problems.reportProblem(4, element, URI_ATTRIBUTE, NLS.bind((String)Messages.StaticProfilePluginErrorReporter_missingExtensionPointAttribute, (Object)URI_ATTRIBUTE), 16715843, "profile", Collections.singletonMap("modelName", profile.getLabel()));
                break;
            }
            case "org.eclipse.uml2.uml.generated_package": {
                String extensionlocation = element.getAttribute(LOCATION);
                if (extensionlocation == null || extensionlocation.isBlank()) {
                    problems.reportProblem(4, element, LOCATION, NLS.bind((String)Messages.StaticProfilePluginErrorReporter_missingExtensionPointAttribute, (Object)LOCATION), 16715847, "profile", Collections.singletonMap("modelName", profile.getLabel()));
                    break;
                }
                String profileId = ((XMIResource)profile.eResource()).getID((EObject)profile);
                String uml2ProfileFile = this.profileFile.getProjectRelativePath().removeFileExtension().addFileExtension("uml").lastSegment();
                if (extensionlocation.endsWith(PATH_SEPARATOR + uml2ProfileFile + "#" + profileId)) break;
                problems.reportProblem(4, element, LOCATION, NLS.bind((String)Messages.StaticProfilePluginErrorReporter_wrongLocationForProfile, (Object)profile.getLabel()), 16715847, "profile", Collections.singletonMap("modelName", profile.getLabel()));
                break;
            }
            case "org.eclipse.papyrus.uml.extensionpoints.UMLProfile": {
                String name = element.getAttribute(NAME);
                if (name != null && !name.isEmpty()) break;
                problems.reportProblem(2, element, NAME, NLS.bind((String)Messages.StaticProfilePluginErrorReporter_uiLabelIsNull, (Object)profile.getLabel()), 16715841, "profile", Collections.singletonMap("modelName", profile.getLabel()));
                break;
            }
        }
    }

    private static String profileURI(Profile profile) {
        return new StaticProfileUtil(profile).getDefinition().getNsURI();
    }

    int problemId(String point, Profile profile) {
        switch (point) {
            case "org.eclipse.emf.ecore.generated_package": {
                return 16715844;
            }
            case "org.eclipse.uml2.uml.generated_package": {
                return 16715845;
            }
            case "org.eclipse.papyrus.uml.extensionpoints.UMLProfile": {
                return 16715846;
            }
        }
        return 0;
    }
}

