/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.checkers;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.papyrus.infra.properties.environment.Environment;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class PropertiesEnvironmentPluginXMLValidator {
    static final String CATEGORY = "properties-environment";
    private final IFile modelFile;

    PropertiesEnvironmentPluginXMLValidator(IFile modelFile) {
        this.modelFile = modelFile;
    }

    Optional<Element> matchExtension(Element element, String point, Environment environmentModel) {
        switch (point) {
            case "org.eclipse.papyrus.infra.properties.environments": {
                NodeList children = element.getElementsByTagName("environment");
                int i = 0;
                while (i < children.getLength()) {
                    Element model = (Element)children.item(i);
                    if (this.matchContext(model, environmentModel)) {
                        return Optional.of(model);
                    }
                    ++i;
                }
                break;
            }
        }
        return Optional.empty();
    }

    boolean matchContext(Element element, Environment model) {
        String path = element.getAttribute("environmentModel");
        return Objects.equals(path, this.modelFile.getProjectRelativePath().toString());
    }

    int problemID(String point, Environment model) {
        switch (point) {
            case "org.eclipse.papyrus.infra.properties.environments": {
                return 16715841;
            }
        }
        return -1;
    }
}

