/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.util;

import java.util.ArrayList;
import java.util.List;

public class IndexHelper {
    private static final String EOL = System.getProperty("line.separator");
    private List<String> headers = new ArrayList<String>();
    private List<String> footers = new ArrayList<String>();

    public IndexHelper(List<String> headers, List<String> footers) {
        this.headers = headers;
        this.footers = footers;
    }

    public String getIndex(String jsonData) {
        StringBuilder stb = new StringBuilder();
        stb.append(this.getHeader());
        stb.append(this.getBody());
        stb.append(this.getFooter(jsonData));
        return stb.toString();
    }

    public String getHeader() {
        StringBuilder stb = new StringBuilder();
        stb.append("<!DOCTYPE html>" + EOL);
        stb.append("<html>" + EOL);
        for (String header : this.headers) {
            stb.append(header + EOL);
        }
        return stb.toString();
    }

    public String getBody() {
        StringBuilder stb = new StringBuilder();
        stb.append("<body>" + EOL);
        stb.append("<div id=\"html-editor\" class=\"html-editor api\">" + EOL);
        stb.append("<div id=\"diagram-explorer-div\" class=\"diagram-explorer-div split split-horizontal\">" + EOL);
        stb.append("<p id=\"diagram-explorer\">My diagram-explorer tree.</p>" + EOL);
        stb.append("</div>" + EOL);
        stb.append("<div id=\"diagram-div\" class=\"diagram-div split split-horizontal\" style=\"overflow: scroll;\">" + EOL);
        stb.append("<object id=\"diagram\" type=\"image/svg+xml\">" + EOL);
        stb.append("Your browser does not support SVG" + EOL);
        stb.append("</object>" + EOL);
        stb.append("</div>" + EOL);
        stb.append("</div>" + EOL);
        stb.append("</body>" + EOL);
        return stb.toString();
    }

    public String getFooter(String jsonData) {
        StringBuilder stb = new StringBuilder();
        stb.append("<script>" + EOL);
        stb.append("var jsondat = ");
        stb.append("'" + jsonData + "';" + EOL);
        stb.append("obj = JSON.parse(jsondat);" + EOL);
        stb.append("document.getElementById(\"diagram-explorer\").innerHTML = displayJson(obj);" + EOL);
        stb.append("</script>" + EOL);
        for (String footer : this.footers) {
            stb.append(footer + EOL);
        }
        stb.append("</html>" + EOL);
        return stb.toString();
    }
}

