/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Bounds;

public final class RelativePortLocation {
    private final int side;
    private final int relativePosition;

    private RelativePortLocation(int side, int relativePosition) {
        this.side = side;
        this.relativePosition = relativePosition;
    }

    public static RelativePortLocation of(Rectangle portBounds, Rectangle onShape) {
        Point portCenter = portBounds.getCenter();
        int side = RelativePortLocation.getSide(portCenter, onShape);
        return new RelativePortLocation(side, (int)Math.round(switch (side) {
            case 8, 16 -> Math.min(Math.max(0.0, portCenter.preciseY()), onShape.preciseHeight()) * 100.0 / onShape.preciseHeight();
            case 1, 4 -> Math.min(Math.max(0.0, portCenter.preciseX()), onShape.preciseWidth()) * 100.0 / onShape.preciseWidth();
            default -> throw new IllegalStateException("Could not compute side of relative port location");
        }));
    }

    public static RelativePortLocation of(Bounds portBounds, Bounds onShape) {
        return RelativePortLocation.of(new Rectangle(portBounds.getX(), portBounds.getY(), portBounds.getWidth(), portBounds.getHeight()), new Rectangle(onShape.getX(), onShape.getY(), onShape.getWidth(), onShape.getHeight()));
    }

    static int getSide(Point portCenter, Rectangle onShape) {
        int closenessToLeft = Math.abs(portCenter.x());
        int closenessToTop = Math.abs(portCenter.y());
        int closenessToRight = Math.abs(onShape.width() - portCenter.x());
        int closenessToBottom = Math.abs(onShape.height() - portCenter.y());
        int result = closenessToLeft < closenessToRight ? (closenessToBottom < closenessToTop ? (closenessToBottom < closenessToLeft ? 4 : 8) : (closenessToTop < closenessToLeft ? 1 : 8)) : (closenessToBottom < closenessToTop ? (closenessToBottom < closenessToRight ? 4 : 16) : (closenessToTop < closenessToRight ? 1 : 16));
        return result;
    }

    public final int side() {
        return this.side;
    }

    public final int relativePosition() {
        return this.relativePosition;
    }

    public Point applyTo(Rectangle bounds, Dimension portSize) {
        Point result = new Point(-portSize.width() / 2, -portSize.height() / 2);
        switch (this.side()) {
            case 8: {
                result.translate(0, bounds.height() * this.relativePosition() / 100);
                break;
            }
            case 1: {
                result.translate(bounds.width() * this.relativePosition() / 100, 0);
                break;
            }
            case 16: {
                result.translate(bounds.width(), bounds.height() * this.relativePosition() / 100);
                break;
            }
            case 4: {
                result.translate(bounds.width() * this.relativePosition() / 100, bounds.height());
                break;
            }
            default: {
                throw new IllegalStateException("invalid side: " + this.side());
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.relativePosition;
        result = 31 * result + this.side;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelativePortLocation other = (RelativePortLocation)obj;
        if (this.relativePosition != other.relativePosition) {
            return false;
        }
        return this.side == other.side;
    }

    public String toString() {
        return String.format("Port@(%s, %d%%)", switch (this.side) {
            case 1 -> "NORTH";
            case 8 -> "WEST";
            case 4 -> "SOUTH";
            case 16 -> "EAST";
            default -> "<invalid>";
        }, this.relativePosition);
    }
}

