/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.providers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.infra.ui.providers.CompositePapyrusContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public class DelegatingPapyrusContentProvider
implements IAdaptableContentProvider,
IHierarchicContentProvider,
IStaticContentProvider {
    private static final Object[] NONE = new Object[0];
    private final ITreeContentProvider treeDelegate;
    private final IAdaptableContentProvider adaptableDelegate;
    private final IHierarchicContentProvider hierarchicDelegate;
    private final IStaticContentProvider staticDelegate;

    public DelegatingPapyrusContentProvider(ITreeContentProvider delegate) {
        this.treeDelegate = delegate;
        this.adaptableDelegate = (IAdaptableContentProvider)TypeUtils.as((Object)delegate, IAdaptableContentProvider.class);
        this.hierarchicDelegate = (IHierarchicContentProvider)TypeUtils.as((Object)delegate, IHierarchicContentProvider.class);
        this.staticDelegate = (IStaticContentProvider)TypeUtils.as((Object)delegate, IStaticContentProvider.class);
    }

    public static ITreeContentProvider wrap(ITreeContentProvider provider) {
        return provider instanceof IAdaptableContentProvider && provider instanceof IHierarchicContentProvider && provider instanceof IStaticContentProvider ? provider : new DelegatingPapyrusContentProvider(provider);
    }

    public static ITreeContentProvider compose(ITreeContentProvider first, ITreeContentProvider second, ITreeContentProvider ... rest) {
        return DelegatingPapyrusContentProvider.compose(Lists.asList((Object)first, (Object)second, (Object[])rest));
    }

    public static ITreeContentProvider compose(Iterable<? extends ITreeContentProvider> providers) {
        Object result;
        if (providers instanceof Collection) {
            Collection collection = (Collection)providers;
            switch (collection.size()) {
                case 0: {
                    result = new CompositePapyrusContentProvider(new ITreeContentProvider[0]);
                    break;
                }
                case 1: {
                    result = DelegatingPapyrusContentProvider.wrap((ITreeContentProvider)Iterables.getOnlyElement((Iterable)collection));
                    break;
                }
                default: {
                    result = new CompositePapyrusContentProvider(providers);
                    break;
                }
            }
        } else {
            Iterator<? extends ITreeContentProvider> iter = providers.iterator();
            if (!iter.hasNext()) {
                result = new CompositePapyrusContentProvider(new ITreeContentProvider[0]);
            } else {
                ITreeContentProvider provider = iter.next();
                result = iter.hasNext() ? new CompositePapyrusContentProvider(providers) : DelegatingPapyrusContentProvider.wrap(provider);
            }
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        return this.treeDelegate.getElements(inputElement);
    }

    public void dispose() {
        this.treeDelegate.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeDelegate.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getChildren(Object parentElement) {
        return this.treeDelegate.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.treeDelegate.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.treeDelegate.hasChildren(element);
    }

    public Object getAdaptedValue(Object containerElement) {
        return this.adaptableDelegate == null ? containerElement : this.adaptableDelegate.getAdaptedValue(containerElement);
    }

    public boolean isValidValue(Object element) {
        return this.hierarchicDelegate == null || this.hierarchicDelegate.isValidValue(element);
    }

    public Object[] getElements() {
        return this.staticDelegate == null ? NONE : this.staticDelegate.getElements();
    }
}

