/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.dnd.strategies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Activity;

public abstract class AbstractActivityNodeStrategy
extends TransactionalDropStrategy {
    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        if (!(request instanceof DropObjectsRequest)) {
            return null;
        }
        List sourceElements = this.getSourceEObjects(request);
        if (sourceElements.size() != 1) {
            return null;
        }
        EObject sourceElement = (EObject)sourceElements.get(0);
        if (!this.isSourceSupportedCase(sourceElement)) {
            return null;
        }
        EObject droppedNode = sourceElement;
        EObject targetElement = this.getTargetSemanticElement(targetEditPart);
        if (!(targetElement instanceof Activity)) {
            return null;
        }
        if (!this.isGraphicalTargetSupported(targetEditPart)) {
            return null;
        }
        Activity activity = (Activity)targetElement;
        CompositeCommand cc = new CompositeCommand(this.getLabel());
        ICommand editSlotsCommand = this.getCreateAndUpdateCommand(targetEditPart, activity, droppedNode, this.getLocation(request));
        if (editSlotsCommand != null) {
            cc.add((IUndoableOperation)editSlotsCommand);
        }
        return cc.canExecute() ? new ICommandProxy(cc.reduce()) : null;
    }

    protected abstract ICommand getCreateAndUpdateCommand(EditPart var1, Activity var2, EObject var3, Point var4);

    protected abstract boolean isSourceSupportedCase(EObject var1);

    protected boolean isGraphicalTargetSupported(EditPart targetEditPart) {
        return true;
    }

    public Image getImage() {
        return null;
    }

    private Point getLocation(Request request) {
        if (request instanceof DropObjectsRequest) {
            return ((DropObjectsRequest)request).getLocation();
        }
        return new Point(100, 100);
    }

    @Deprecated
    public int getPriority() {
        return 0;
    }
}

