/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper2;
import org.eclipse.papyrus.infra.nattable.utils.TypeSelectionEnum;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.ui.services.IDisposable;

public class TableSelectionProvider
implements ISelectionProvider,
IDisposable,
ILayerListener {
    private SelectionLayer selectionLayer;
    private final ILayerListener selectionListener;
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;
    private INattableModelManager manager;
    private boolean isDisposed = false;
    private boolean isActive = true;

    public TableSelectionProvider(INattableModelManager manager, SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        this.selectionListener = this;
        this.selectionLayer.addLayerListener(this.selectionListener);
        this.currentSelection = new StructuredSelection();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.manager = manager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public synchronized ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        if (this.currentSelection.equals(selection)) {
            return;
        }
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.listeners) {
            current.selectionChanged(event);
        }
    }

    protected void calculateAndStoreNewSelection(ILayerEvent event) {
        Object newSelection;
        Collection<Object> selection = new HashSet();
        if (event instanceof ISelectionEvent) {
            TableSelectionWrapper wrapper = new TableSelectionWrapper(this.manager, this.selectionLayer, ListHelper.asList((Object[])this.selectionLayer.getSelectedCellPositions()));
            TypeSelectionEnum typeSelectionEvent = TypeSelectionEnum.NONE;
            boolean isWithShiftMask = false;
            boolean isWithControlMask = false;
            if (event instanceof CellSelectionEvent) {
                typeSelectionEvent = TypeSelectionEnum.CELL;
                isWithShiftMask = ((CellSelectionEvent)event).isWithShiftMask();
                isWithControlMask = ((CellSelectionEvent)event).isWithControlMask();
            } else if (event instanceof ColumnSelectionEvent) {
                typeSelectionEvent = TypeSelectionEnum.COLUMN;
                isWithShiftMask = ((ColumnSelectionEvent)event).isWithShiftMask();
                isWithControlMask = ((ColumnSelectionEvent)event).isWithControlMask();
            } else if (event instanceof RowSelectionEvent) {
                typeSelectionEvent = TypeSelectionEnum.ROW;
                isWithShiftMask = ((RowSelectionEvent)event).isWithShiftMask();
                isWithControlMask = ((RowSelectionEvent)event).isWithControlMask();
            }
            if (!TypeSelectionEnum.NONE.equals((Object)typeSelectionEvent)) {
                selection = isWithShiftMask ? this.calculateSelectionWithShiftMask(wrapper, typeSelectionEvent) : (isWithControlMask ? this.calculateSelectionWithControlMask(wrapper, typeSelectionEvent, event) : this.calculateSelectionRowsAndColumnsWithTypeSelectionEvent(wrapper, typeSelectionEvent, event));
            } else {
                wrapper = new TableSelectionWrapper2(this.manager, this.selectionLayer);
                selection = this.calculateSelectionRowsAndColumnsWithoutTypeSelectionEvent(wrapper, event);
            }
            newSelection = selection.isEmpty() ? new TableStructuredSelection(this.manager.getTable().getContext(), wrapper) : new TableStructuredSelection(selection.toArray(), wrapper);
        } else {
            newSelection = new StructuredSelection((Object)this.manager.getTable().getContext());
        }
        this.setSelection((ISelection)newSelection);
    }

    protected Collection<Object> calculateSelectionWithShiftMask(TableSelectionWrapper wrapper, TypeSelectionEnum typeSelectionEvent) {
        if (TypeSelectionEnum.CELL.equals((Object)typeSelectionEvent)) {
            if (this.currentSelection instanceof TableStructuredSelection) {
                TableSelectionWrapper existingWrapper = (TableSelectionWrapper)((TableStructuredSelection)this.currentSelection).getAdapter(TableSelectionWrapper.class);
                wrapper.copyRowsSelection(existingWrapper);
                wrapper.copyColumnsSelection(existingWrapper);
            }
        } else if (TypeSelectionEnum.ROW.equals((Object)typeSelectionEvent)) {
            int[] nArray = this.selectionLayer.getFullySelectedRowPositions();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int rowPosition = nArray[n2];
                if (!wrapper.getFullySelectedRows().containsKey(rowPosition) && this.isSelectedCellsContainsRow(wrapper.getSelectedCells(), rowPosition)) {
                    wrapper.addSelectedRow(rowPosition);
                }
                ++n2;
            }
        } else if (TypeSelectionEnum.COLUMN.equals((Object)typeSelectionEvent)) {
            if (this.currentSelection instanceof TableStructuredSelection) {
                TableSelectionWrapper existingWrapper = (TableSelectionWrapper)((TableStructuredSelection)this.currentSelection).getAdapter(TableSelectionWrapper.class);
                wrapper.copyRowsSelection(existingWrapper);
                wrapper.copyColumnsSelection(existingWrapper);
            }
            int[] nArray = this.selectionLayer.getFullySelectedColumnPositions();
            int n = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                int columnPosition = nArray[n3];
                if (!wrapper.getFullySelectedColumns().containsKey(columnPosition) && this.isSelectedCellsContainsColumn(wrapper.getSelectedCells(), columnPosition)) {
                    wrapper.addSelectedColumn(columnPosition);
                }
                ++n3;
            }
        }
        wrapper.buildSingleCellSelection();
        return this.calculateSelectionFromWrapper(wrapper);
    }

    protected Collection<Object> calculateSelectionWithControlMask(TableSelectionWrapper wrapper, TypeSelectionEnum typeSelectionEvent, ILayerEvent event) {
        if (this.currentSelection instanceof TableStructuredSelection) {
            TableSelectionWrapper existingWrapper = (TableSelectionWrapper)((TableStructuredSelection)this.currentSelection).getAdapter(TableSelectionWrapper.class);
            wrapper.copyRowsSelection(existingWrapper);
            wrapper.copyColumnsSelection(existingWrapper);
        }
        if (TypeSelectionEnum.CELL.equals((Object)typeSelectionEvent)) {
            int columnPosition = ((CellSelectionEvent)event).getColumnPosition();
            int rowPosition = ((CellSelectionEvent)event).getRowPosition();
            PositionCoordinate tmpCoordinate = new PositionCoordinate((ILayer)this.selectionLayer, columnPosition, rowPosition);
            if (!wrapper.getSelectedCells().contains(tmpCoordinate)) {
                if (wrapper.getFullySelectedRows().containsKey(rowPosition)) {
                    wrapper.removeSelectedRow(rowPosition);
                }
                if (wrapper.getFullySelectedColumns().containsKey(columnPosition)) {
                    wrapper.removeSelectedColumn(columnPosition);
                }
            }
        } else {
            this.calculateSelectionRowsAndColumnsWithTypeSelectionEvent(wrapper, typeSelectionEvent, event);
        }
        wrapper.buildSingleCellSelection();
        return this.calculateSelectionFromWrapper(wrapper);
    }

    protected Collection<Object> calculateSelectionRowsAndColumnsWithTypeSelectionEvent(TableSelectionWrapper wrapper, TypeSelectionEnum typeSelectionEvent, ILayerEvent event) {
        if (TypeSelectionEnum.COLUMN.equals((Object)typeSelectionEvent)) {
            for (Range range : ((ColumnSelectionEvent)event).getColumnPositionRanges()) {
                int columnPosition = range.start;
                while (columnPosition < range.end) {
                    if (wrapper.getFullySelectedColumns().containsKey(columnPosition)) {
                        wrapper.removeSelectedColumn(columnPosition);
                    } else if (this.isSelectedCellsContainsColumn(wrapper.getSelectedCells(), columnPosition)) {
                        wrapper.addSelectedColumn(columnPosition);
                    }
                    ++columnPosition;
                }
            }
        } else if (TypeSelectionEnum.ROW.equals((Object)typeSelectionEvent)) {
            for (Range range : ((RowSelectionEvent)event).getRowPositionRanges()) {
                int rowPosition = range.start;
                while (rowPosition < range.end) {
                    if (wrapper.getFullySelectedRows().containsKey(rowPosition)) {
                        wrapper.removeSelectedRow(rowPosition);
                    } else if (this.isSelectedCellsContainsRow(wrapper.getSelectedCells(), rowPosition)) {
                        wrapper.addSelectedRow(rowPosition);
                    }
                    ++rowPosition;
                }
            }
        }
        wrapper.buildSingleCellSelection();
        return this.calculateSelectionFromWrapper(wrapper);
    }

    private boolean isSelectedCellsContainsRow(Collection<PositionCoordinate> selectedCells, int rowIndex) {
        boolean result = false;
        Iterator<PositionCoordinate> selectedCellsIterator = selectedCells.iterator();
        while (!result && selectedCellsIterator.hasNext()) {
            PositionCoordinate selectedCell = selectedCellsIterator.next();
            if (selectedCell.getRowPosition() != rowIndex) continue;
            result = true;
        }
        return result;
    }

    private boolean isSelectedCellsContainsColumn(Collection<PositionCoordinate> selectedCells, int columnIndex) {
        boolean result = false;
        Iterator<PositionCoordinate> selectedCellsIterator = selectedCells.iterator();
        while (!result && selectedCellsIterator.hasNext()) {
            PositionCoordinate selectedCell = selectedCellsIterator.next();
            if (selectedCell.getColumnPosition() != columnIndex) continue;
            result = true;
        }
        return result;
    }

    protected Collection<Object> calculateSelectionFromWrapper(TableSelectionWrapper wrapper) {
        return wrapper.getSelectedElements();
    }

    protected Collection<Object> calculateSelectionRowsAndColumnsWithoutTypeSelectionEvent(TableSelectionWrapper wrapper, ILayerEvent event) {
        return wrapper.getSelectedElements();
    }

    public void dispose() {
        this.isDisposed = true;
        this.manager = null;
        this.setSelection((ISelection)StructuredSelection.EMPTY);
        if (this.selectionLayer != null) {
            this.selectionLayer.removeLayerListener(this.selectionListener);
            this.selectionLayer = null;
        }
        this.listeners.clear();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (!this.isDisposed && this.isActive && event instanceof ISelectionEvent) {
            this.calculateAndStoreNewSelection(event);
        }
    }

    public void setActive(boolean activate) {
        this.isActive = activate;
        if (activate) {
            this.calculateAndStoreNewSelection(new FakeSelectionEvent(this.selectionLayer));
        }
    }

    private class FakeSelectionEvent
    implements ILayerEvent,
    ISelectionEvent {
        private final SelectionLayer selectionLayer;

        public FakeSelectionEvent(SelectionLayer layer) {
            this.selectionLayer = layer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public boolean convertToLocal(ILayer localLayer) {
            return false;
        }

        public ILayerEvent cloneEvent() {
            return new FakeSelectionEvent(this.selectionLayer);
        }
    }
}

