/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.command;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml16.blocks.DirectedRelationshipPropertyPath;
import org.eclipse.papyrus.sysml16.service.types.command.wrapper.IEMFElementToEditCommand;
import org.eclipse.papyrus.sysml16.service.types.util.PropertyPathUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SetDirectedRelationshipPropertyPathCommand
extends RecordingCommand
implements IEMFElementToEditCommand {
    protected Element directedRelationShipPropertyPath = null;
    protected View sourceView = null;
    protected boolean isSource;

    public SetDirectedRelationshipPropertyPathCommand(TransactionalEditingDomain domain, View view, boolean isSource) {
        super(domain);
        this.sourceView = view;
        this.isSource = isSource;
    }

    public boolean canExecute() {
        if (this.directedRelationShipPropertyPath == null || this.sourceView == null) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        if (this.canExecute()) {
            if (this.isSource) {
                DirectedRelationshipPropertyPath stereotypeApplication = (DirectedRelationshipPropertyPath)UMLUtil.getStereotypeApplication((Element)this.directedRelationShipPropertyPath, DirectedRelationshipPropertyPath.class);
                stereotypeApplication.getSourcePropertyPath().clear();
                stereotypeApplication.getSourcePropertyPath().addAll(PropertyPathUtil.getPropertyPath(this.sourceView));
                stereotypeApplication.setSourceContext(PropertyPathUtil.getCompositeContext(this.sourceView));
            } else {
                DirectedRelationshipPropertyPath stereotypeApplication = (DirectedRelationshipPropertyPath)UMLUtil.getStereotypeApplication((Element)this.directedRelationShipPropertyPath, DirectedRelationshipPropertyPath.class);
                stereotypeApplication.getTargetPropertyPath().clear();
                stereotypeApplication.getTargetPropertyPath().addAll(PropertyPathUtil.getPropertyPath(this.sourceView));
                stereotypeApplication.setTargetContext(PropertyPathUtil.getCompositeContext(this.sourceView));
            }
        }
    }

    @Override
    public void setElementToEdit(EObject eObject) {
        if (eObject instanceof Element) {
            this.directedRelationShipPropertyPath = (Element)eObject;
        }
    }
}

