/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.metrics.commands.helper;

import java.util.ArrayList;
import org.eclipse.papyrus.metrics.commands.Activator;
import org.eclipse.papyrus.metrics.extensionpoints.helpers.BasicMeasuresRegistry;
import org.eclipse.papyrus.metrics.extensionpoints.helpers.SmmMetricsModelHelper;
import org.eclipse.papyrus.metrics.extensionpoints.helpers.SmmModelRegistry;
import org.omg.smm.AbstractMeasureElement;
import org.omg.smm.Measure;
import org.omg.smm.MeasureLibrary;
import org.omg.smm.NamedMeasure;
import org.omg.smm.SmmModel;

public class MeasuresReaderHelper {
    public ArrayList<Measure> getMeasuresFromFile() {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        SmmModel smmModel = null;
        SmmMetricsModelHelper helper = new SmmMetricsModelHelper();
        String smmModelLocation = helper.getSmmModelFileLocation();
        if (smmModelLocation.isEmpty() || smmModelLocation == null) {
            Activator.log.warn("SMM model location is empty in the extension plugin");
            return null;
        }
        if (helper.getSmmModel(smmModelLocation) == null) {
            Activator.log.warn("Impossible to get SMM model from: " + smmModelLocation);
            return null;
        }
        smmModel = helper.getSmmModel(smmModelLocation);
        for (MeasureLibrary library : smmModel.getLibraries()) {
            for (AbstractMeasureElement abstractMeasureElement : library.getMeasureElements()) {
                if (!(abstractMeasureElement instanceof NamedMeasure)) continue;
                NamedMeasure measure = (NamedMeasure)abstractMeasureElement;
                measures.add((Measure)measure);
            }
        }
        return measures;
    }

    public ArrayList<Measure> getMeasuresFromExtensions() {
        boolean foundMeasures;
        ArrayList<Measure> measures = new ArrayList<Measure>();
        boolean existMeasuresFrombasicMeasuresRegistry = false;
        boolean existMeasuresFromSmmModelRegistry = false;
        BasicMeasuresRegistry basicMeasuresRegistry = BasicMeasuresRegistry.getInstance();
        if (basicMeasuresRegistry.getMeasures() == null || basicMeasuresRegistry.getMeasures().isEmpty()) {
            Activator.log.warn("There are not registered implementations of " + Measure.class.toGenericString() + " in the extension point " + BasicMeasuresRegistry.getExtensionPointId());
        } else {
            Activator.log.info("Found registered implementations of " + Measure.class.toGenericString() + " in the extension point " + BasicMeasuresRegistry.getExtensionPointId());
            existMeasuresFrombasicMeasuresRegistry = true;
        }
        SmmModelRegistry smmModelsRegistry = SmmModelRegistry.getInstance();
        if (smmModelsRegistry.getMeasures() == null || smmModelsRegistry.getMeasures().isEmpty()) {
            Activator.log.warn("There are not registered smm models in the extension point " + SmmModelRegistry.getExtensionPointId());
        } else {
            Activator.log.info("Found registered implementations of " + Measure.class.toGenericString() + " in the extension point " + SmmModelRegistry.getExtensionPointId());
            existMeasuresFromSmmModelRegistry = true;
        }
        boolean bl = foundMeasures = Boolean.TRUE.equals(existMeasuresFrombasicMeasuresRegistry) || Boolean.TRUE.equals(existMeasuresFromSmmModelRegistry);
        if (!foundMeasures) {
            Activator.log.warn("Failed to find at least one registered measure definition");
            return null;
        }
        measures.addAll(basicMeasuresRegistry.getMeasures());
        measures.addAll(smmModelsRegistry.getMeasures());
        return measures;
    }
}

