/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementandprocessconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum QualificationStatusKind implements Enumerator
{
    NOT_QUALIFIED(0, "NotQualified", "NotQualified"),
    QUALIFIED(1, "Qualified", "Qualified"),
    SUSPECT(2, "Suspect", "Suspect");

    public static final int NOT_QUALIFIED_VALUE = 0;
    public static final int QUALIFIED_VALUE = 1;
    public static final int SUSPECT_VALUE = 2;
    private static final QualificationStatusKind[] VALUES_ARRAY;
    public static final List<QualificationStatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new QualificationStatusKind[]{NOT_QUALIFIED, QUALIFIED, SUSPECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static QualificationStatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QualificationStatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QualificationStatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QualificationStatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QualificationStatusKind get(int value) {
        switch (value) {
            case 0: {
                return NOT_QUALIFIED;
            }
            case 1: {
                return QUALIFIED;
            }
            case 2: {
                return SUSPECT;
            }
        }
        return null;
    }

    private QualificationStatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

