/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.CommentsInserter;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.InstanceJavaParser;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ParseException;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.SourcesHelper;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.ImportDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.BodyDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.BlockStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.Statement;

public final class JavaParser {
    private static boolean doNotAssignCommentsPreceedingEmptyLines = true;
    private static boolean doNotConsiderAnnotationsAsNodeStartForCodeAttribution = false;

    private JavaParser() {
    }

    public static boolean getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution() {
        return doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public static void setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(boolean doNotConsiderAnnotationsAsNodeStartForCodeAttribution) {
        JavaParser.doNotConsiderAnnotationsAsNodeStartForCodeAttribution = doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public static boolean getDoNotAssignCommentsPreceedingEmptyLines() {
        return doNotAssignCommentsPreceedingEmptyLines;
    }

    public static void setDoNotAssignCommentsPreceedingEmptyLines(boolean doNotAssignCommentsPreceedingEmptyLines) {
        JavaParser.doNotAssignCommentsPreceedingEmptyLines = doNotAssignCommentsPreceedingEmptyLines;
    }

    private static CommentsInserter commentsInserter() {
        CommentsInserter commentsInserter = new CommentsInserter();
        commentsInserter.setDoNotAssignCommentsPreceedingEmptyLines(doNotAssignCommentsPreceedingEmptyLines);
        commentsInserter.setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(doNotConsiderAnnotationsAsNodeStartForCodeAttribution);
        return commentsInserter;
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        return JavaParser.parse(in, encoding, true);
    }

    public static CompilationUnit parse(InputStream in, String encoding, boolean considerComments) throws ParseException {
        try {
            String code = SourcesHelper.streamToString(in, encoding);
            InputStream in1 = SourcesHelper.stringToStream(code, encoding);
            CompilationUnit cu = new InstanceJavaParser(in1).parse();
            if (considerComments) {
                JavaParser.commentsInserter().insertComments(cu, code);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null, true);
    }

    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        return JavaParser.parse(file, encoding, true);
    }

    public static CompilationUnit parse(File file, String encoding, boolean considerComments) throws ParseException, IOException {
        try (FileInputStream in = new FileInputStream(file);){
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding, considerComments);
            return compilationUnit;
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null, true);
    }

    public static CompilationUnit parse(Reader reader, boolean considerComments) throws ParseException {
        try {
            String code = SourcesHelper.readerToString(reader);
            Reader reader1 = SourcesHelper.stringToReader(code);
            CompilationUnit cu = new InstanceJavaParser(reader1).parse();
            if (considerComments) {
                JavaParser.commentsInserter().insertComments(cu, code);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static BlockStmt parseBlock(String blockStatement) throws ParseException {
        StringReader sr = new StringReader(blockStatement);
        BlockStmt result = new InstanceJavaParser(sr).parseBlock();
        sr.close();
        return result;
    }

    public static Statement parseStatement(String statement) throws ParseException {
        StringReader sr = new StringReader(statement);
        Statement stmt = new InstanceJavaParser(sr).parseStatement();
        sr.close();
        return stmt;
    }

    public static ImportDeclaration parseImport(String importDeclaration) throws ParseException {
        StringReader sr = new StringReader(importDeclaration);
        ImportDeclaration id = new InstanceJavaParser(sr).parseImport();
        sr.close();
        return id;
    }

    public static Expression parseExpression(String expression) throws ParseException {
        StringReader sr = new StringReader(expression);
        Expression e = new InstanceJavaParser(sr).parseExpression();
        sr.close();
        return e;
    }

    public static AnnotationExpr parseAnnotation(String annotation) throws ParseException {
        StringReader sr = new StringReader(annotation);
        AnnotationExpr ae = new InstanceJavaParser(sr).parseAnnotation();
        sr.close();
        return ae;
    }

    public static BodyDeclaration parseBodyDeclaration(String body) throws ParseException {
        StringReader sr = new StringReader(body);
        BodyDeclaration bd = new InstanceJavaParser(sr).parseBodyDeclaration();
        sr.close();
        return bd;
    }
}

