/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.reverse;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IMethodTemplateDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.IStructureTemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Visibility;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.BatchReverseFunctionBody;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.DependencyAnalysis;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.ReverseUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.CElementChange;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.ChangeMapStore;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.CppChangeObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.reverse.change.ModelChangeObject;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.FileWatcher;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.ModelManagement;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.RoundtripCppUtils;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.TypeOperationsEnhanced;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableTemplateSignature;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ArrayExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReverseCpp2Uml {
    private ConflictResolutionMode conflictResolveMode = ConflictResolutionMode.FROM_CODE;
    public static String C_LangID = "C";
    public static String Cpp_LangID = "C++";
    private String langID = "C++";
    private Map<ICElement, EObject> map = new HashMap<ICElement, EObject>();
    private static final String TEMPLATE_PARAMETER_SIGNATURE_NAME = "template_paremeter_signature";
    private static final String REVERSE_FOLDER = "reversed_models";
    private static final String MODEL_POSTFIX = ".uml";
    private ITranslationUnit unit;
    private ICProject m_project;
    private List<Model> m_models;
    private static final Logger LOGGER = Logger.getLogger(ReverseCpp2Uml.class.getName());
    private IIndex index;
    private IProgressMonitor m_monitor;
    private String path;
    private ReverseUtils reverse_utils = ReverseUtils.getInstance();
    private static long timestamp = 0L;
    private ReverseMode reverseMode = ReverseMode.BATCH;
    private Map<ITranslationUnit, IASTTranslationUnit> translationUnitToASTTranslationUnitMap;
    private Map<String, List<IInclude>> excludedIncludesMap;
    private List<CppChangeObject> changeList = new ArrayList<CppChangeObject>();
    private static List<ModelChangeObject> modelChangeList = new ArrayList<ModelChangeObject>();
    private List<ICContainer> containers = new UniqueEList();
    private static final String projectPrefix = "org.eclipse.papyrus.cppgen";

    public static boolean addModelChange(ModelChangeObject change) {
        return modelChangeList.add(change);
    }

    public static void clearModelChange() {
        modelChangeList.clear();
    }

    public ReverseCpp2Uml(ITranslationUnit unit, IProgressMonitor monitor, String langID) {
        try {
            this.unit = unit;
            this.m_project = unit.getCProject();
            this.index = CCorePlugin.getIndexManager().getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
            this.langID = langID;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ITranslationUnit unit, IProgressMonitor monitor) {
        try {
            this.unit = unit;
            this.m_project = unit.getCProject();
            this.index = CCorePlugin.getIndexManager().getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor, String langID) {
        try {
            this.m_project = project;
            this.index = CCorePlugin.getIndexManager().getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
            this.langID = langID;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor) {
        try {
            this.m_project = project;
            this.index = CCorePlugin.getIndexManager().getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ReverseCpp2Uml(ICProject project, IProgressMonitor monitor, String langID, String path) {
        try {
            this.m_project = project;
            this.index = CCorePlugin.getIndexManager().getIndex(this.m_project);
            HashMap<ITranslationUnit, IASTTranslationUnit> _hashMap = new HashMap<ITranslationUnit, IASTTranslationUnit>();
            this.translationUnitToASTTranslationUnitMap = _hashMap;
            HashMap<String, List<IInclude>> _hashMap_1 = new HashMap<String, List<IInclude>>();
            this.excludedIncludesMap = _hashMap_1;
            this.m_monitor = monitor;
            this.langID = langID;
            this.path = path;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void reverse() {
        try {
            String projectName = this.unit.getCProject().getElementName();
            BatchReverseFunctionBody iSync = new BatchReverseFunctionBody(this.unit, projectName, this);
            iSync.run();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSourceFolder(ICContainer container) {
        try {
            ICElement[] _children;
            ICElement[] iCElementArray = _children = container.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (true) {
                boolean _isSourceFolder;
                if (n2 >= n) {
                    return false;
                }
                ICElement child = iCElementArray[n2];
                if (child instanceof ITranslationUnit) {
                    return true;
                }
                if (child instanceof ICContainer && (_isSourceFolder = this.isSourceFolder((ICContainer)child))) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Object reverseProject(boolean reset) {
        try {
            long _divide;
            boolean _lessThan;
            Functions.Function1<ISourceRoot, Boolean> _function = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    return ReverseCpp2Uml.this.isSourceFolder((ICContainer)it);
                }
            };
            Iterable sourceRoots = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.m_project.getSourceRoots())), (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)sourceRoots);
            boolean bl = _lessThan = _size < 1;
            if (_lessThan) {
                throw new Exception("No source folder");
            }
            this.containers.clear();
            Functions.Function1<ISourceRoot, Boolean> _function_1 = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    return it.getElementName().contains(ReverseCpp2Uml.projectPrefix);
                }
            };
            ISourceRoot sourceRootGenerated = (ISourceRoot)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)sourceRoots, (Functions.Function1)_function_1));
            if (sourceRootGenerated != null) {
                Functions.Function1<ICContainer, Boolean> _function_2 = new Functions.Function1<ICContainer, Boolean>(){

                    public Boolean apply(ICContainer it) {
                        return ReverseCpp2Uml.this.isSourceFolder(it);
                    }
                };
                Iterables.addAll(this.containers, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)sourceRootGenerated.getChildren())), ICContainer.class), (Functions.Function1)_function_2));
            } else {
                Iterables.addAll(this.containers, (Iterable)sourceRoots);
            }
            ModelManagement modelManager = new ModelManagement();
            String umlFilePath = null;
            if (this.path == null || this.path.equals("")) {
                IProject _project = this.m_project.getProject();
                String _elementName = this.m_project.getElementName();
                String _plus = String.valueOf(_elementName) + MODEL_POSTFIX;
                umlFilePath = modelManager.getPath(_project, REVERSE_FOLDER, _plus);
            } else {
                umlFilePath = this.path;
            }
            modelManager.createOrgetModel(this.m_project.getElementName(), umlFilePath, !reset, reset);
            this.m_models = modelManager.getModels();
            Consumer<Model> _function_3 = new Consumer<Model>(){

                @Override
                public void accept(Model it) {
                    RoundtripCppUtils.applyProfile(it, "pathmap://PapyrusC_Cpp_PROFILES/C_Cpp.profile.uml");
                    RoundtripCppUtils.applyProfile(it, "pathmap://UML_PROFILES/Standard.profile.uml");
                }
            };
            this.m_models.forEach(_function_3);
            Consumer<ICContainer> _function_4 = new Consumer<ICContainer>(){

                @Override
                public void accept(ICContainer it) {
                    ReverseCpp2Uml.this.reverseProject((IParent)it);
                }
            };
            this.containers.forEach(_function_4);
            modelManager.saveModel(IterableExtensions.toList(Collections.singleton(umlFilePath)));
            long _timeStamp = ((Model)IterableExtensions.last(this.m_models)).eResource().getTimeStamp();
            timestamp = _divide = _timeStamp / 1000L;
            this.clearRawChangeList();
            modelManager.dispose();
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void syncIncrementalProject() {
        try {
            boolean _lessThan;
            this.reverseMode = ReverseMode.INCREMENTAL;
            Functions.Function1<ISourceRoot, Boolean> _function = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    return ReverseCpp2Uml.this.isSourceFolder((ICContainer)it);
                }
            };
            Iterable sourceRoots = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)this.m_project.getSourceRoots())), (Functions.Function1)_function);
            int _size = IterableExtensions.size((Iterable)sourceRoots);
            boolean bl = _lessThan = _size < 1;
            if (_lessThan) {
                throw new Exception("No source folder");
            }
            this.containers.clear();
            Functions.Function1<ISourceRoot, Boolean> _function_1 = new Functions.Function1<ISourceRoot, Boolean>(){

                public Boolean apply(ISourceRoot it) {
                    return it.getElementName().contains(ReverseCpp2Uml.projectPrefix);
                }
            };
            ISourceRoot sourceRootGenerated = (ISourceRoot)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)sourceRoots, (Functions.Function1)_function_1));
            if (sourceRootGenerated != null) {
                Functions.Function1<ICContainer, Boolean> _function_2 = new Functions.Function1<ICContainer, Boolean>(){

                    public Boolean apply(ICContainer it) {
                        return ReverseCpp2Uml.this.isSourceFolder(it);
                    }
                };
                Iterables.addAll(this.containers, (Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)sourceRootGenerated.getChildren())), ICContainer.class), (Functions.Function1)_function_2));
            } else {
                Iterables.addAll(this.containers, (Iterable)sourceRoots);
            }
            ModelManagement modelManager = new ModelManagement();
            String umlFilePath = null;
            if (this.path == null || this.path.equals("")) {
                IProject _project = this.m_project.getProject();
                String _elementName = this.m_project.getElementName();
                String _plus = String.valueOf(_elementName) + MODEL_POSTFIX;
                umlFilePath = modelManager.getPath(_project, REVERSE_FOLDER, _plus);
            } else {
                umlFilePath = this.path;
            }
            modelManager.createOrgetModel(this.m_project.getElementName(), umlFilePath, false, false);
            this.m_models = modelManager.getModels();
            Consumer<Model> _function_3 = new Consumer<Model>(){

                @Override
                public void accept(Model it) {
                    RoundtripCppUtils.applyProfile(it, "pathmap://PapyrusC_Cpp_PROFILES/C_Cpp.profile.uml");
                    RoundtripCppUtils.applyProfile(it, "pathmap://UML_PROFILES/Standard.profile.uml");
                }
            };
            this.m_models.forEach(_function_3);
            if (this.getRawChangeList() == null || this.getRawChangeList().size() == 0) {
                long _divide;
                FileWatcher fileWatcher = new FileWatcher(this.m_project, timestamp);
                List<ITranslationUnit> modifiedItus = fileWatcher.getModifiledTranslationUnits((IParent)this.m_project);
                for (ITranslationUnit modified : modifiedItus) {
                    this.syncTranslationUnit(modified);
                }
                modelManager.saveModel(IterableExtensions.toList(Collections.singleton(umlFilePath)));
                long _timeStamp = ((Model)IterableExtensions.last(this.m_models)).eResource().getTimeStamp();
                timestamp = _divide = _timeStamp / 1000L;
            } else {
                this.reverseIncrementalChanges();
                modelManager.saveModel(IterableExtensions.toList(Collections.singleton(umlFilePath)));
            }
            modelManager.dispose();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void reverseProject(IParent parent) {
        try {
            if (!(parent instanceof ITranslationUnit)) {
                Consumer<ITranslationUnit> _function = new Consumer<ITranslationUnit>(){

                    @Override
                    public void accept(ITranslationUnit it) {
                        String _elementName = it.getElementName();
                        String _plus = "Parsing types in " + _elementName;
                        ReverseCpp2Uml.this.m_monitor.subTask(_plus);
                        ReverseCpp2Uml.this.reverseHeader(it);
                    }
                };
                Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)parent.getChildren())), ITranslationUnit.class).forEach(_function);
                Consumer<IParent> _function_1 = new Consumer<IParent>(){

                    @Override
                    public void accept(IParent it) {
                        ReverseCpp2Uml.this.reverseProject(it);
                    }
                };
                Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)parent.getChildren())), IParent.class).forEach(_function_1);
                Functions.Function1<ITranslationUnit, Boolean> _function_2 = new Functions.Function1<ITranslationUnit, Boolean>(){

                    public Boolean apply(ITranslationUnit it) {
                        boolean _isHeaderUnit = it.isHeaderUnit();
                        return !_isHeaderUnit;
                    }
                };
                Consumer<ITranslationUnit> _function_3 = new Consumer<ITranslationUnit>(){

                    @Override
                    public void accept(ITranslationUnit it) {
                        String _elementName = it.getElementName();
                        String _plus = "Parsing method implementations in " + _elementName;
                        ReverseCpp2Uml.this.m_monitor.subTask(_plus);
                        ReverseCpp2Uml.this.reverseSource(it);
                    }
                };
                IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)parent.getChildren())), ITranslationUnit.class), (Functions.Function1)_function_2).forEach(_function_3);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Model getCorrespondingModel(ITranslationUnit unit) {
        Model ret = null;
        for (Model model : this.m_models) {
            boolean _contains = unit.getPath().toString().contains(model.getName());
            if (!_contains) continue;
            ret = model;
        }
        return ret;
    }

    private void reverseSource(ITranslationUnit unit) {
        String _elementName = this.m_project.getElementName();
        Model _correspondingModel = this.getCorrespondingModel(unit);
        BatchReverseFunctionBody sync = new BatchReverseFunctionBody(unit, _elementName, _correspondingModel, this);
        try {
            sync.run();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                e.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private List<Type> reverseHeader(ITranslationUnit headerUnit) {
        try {
            return this.getOrCreateClassifier(this.getCorrespondingModel(headerUnit), (IParent)headerUnit);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private List<Type> getOrCreateClassifier(Model model, IParent parent) throws Exception {
        UniqueEList ret = new UniqueEList();
        ICElement[] childrend = parent.getChildren();
        int i = 0;
        while (i < childrend.length) {
            ICElement child = childrend[i];
            boolean _matched = false;
            if (child instanceof IStructure) {
                _matched = true;
            }
            if (!_matched && child instanceof IEnumeration) {
                _matched = true;
            }
            if (_matched) {
                boolean _not;
                boolean _equals = ((IDeclaration)child).getElementName().equals("");
                boolean bl = _not = !_equals;
                if (_not) {
                    ret.addAll(this.getOrcreateTypes((IDeclaration)child, parent, model));
                }
            }
            if (!_matched && child instanceof IMethod) {
                _matched = true;
                if (((IMethod)child).getTranslationUnit().isHeaderUnit() && !(child.getParent() instanceof IStructure)) {
                    boolean _greaterThan;
                    IMethod method = (IMethod)child;
                    UniqueEList<Classifier> types = this.getTypeByQualifiedName((ICElement)method, method.getTranslationUnit(), this.getContextNamespaces((ICElement)method));
                    int _size = types.size();
                    boolean bl = _greaterThan = _size > 0;
                    if (_greaterThan) {
                        Classifier type = (Classifier)types.get(0);
                        ITranslationUnit _translationUnit = method.getTranslationUnit();
                        String _elementName = method.getCProject().getElementName();
                        BatchReverseFunctionBody batchReverser = new BatchReverseFunctionBody(_translationUnit, _elementName, this, type);
                        String name = method.getElementName();
                        IASTNode node = this.findEnclosingNode((ISourceReference)method);
                        if (node instanceof IASTFunctionDefinition) {
                            IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                            IASTFunctionDeclarator declarator = definition.getDeclarator();
                            String body = this.getBody((IMethodDeclaration)method);
                            Operation operation = batchReverser.updateMethod((IFunctionDeclaration)method, node, 0, parent, name, body, declarator);
                            if (operation != null) {
                                ITranslationUnit _translationUnit_1 = method.getTranslationUnit();
                                new DependencyAnalysis(operation, definition, _translationUnit_1, this).analyzeDependencies();
                            }
                        }
                    }
                }
            }
            if (!_matched && child instanceof IFunction) {
                _matched = true;
            }
            if (!_matched && child instanceof IParent) {
                _matched = true;
                ret.addAll(this.getOrCreateClassifier(model, (IParent)child));
            }
            if (!_matched && child instanceof ITypeDef) {
                _matched = true;
                Package parentPack = this.getContainerPackage(((ITypeDef)child).getTranslationUnit());
                Classifier tempType = null;
                ICElement _parent = child.getParent();
                if (_parent instanceof IStructure) {
                    boolean _tripleEquals;
                    Type _uMLType = this.getUMLType(child.getParent().getElementName(), ((ITypeDef)child).getTranslationUnit(), this.getContextNamespaces(child));
                    Classifier parentClass = (Classifier)_uMLType;
                    NamedElement _ownedMember = parentClass.getOwnedMember(child.getElementName());
                    boolean bl = _tripleEquals = _ownedMember == null;
                    if (_tripleEquals) {
                        this.createOrgetClassifier((PackageableElement)parentClass, child, true);
                    }
                    NamedElement _ownedMember_1 = parentClass.getOwnedMember(child.getElementName());
                    tempType = (Classifier)_ownedMember_1;
                } else {
                    boolean _tripleEquals_1;
                    Type _ownedType = parentPack.getOwnedType(child.getElementName());
                    boolean bl = _tripleEquals_1 = _ownedType == null;
                    if (_tripleEquals_1) {
                        this.createOrgetClassifier((PackageableElement)parentPack, child, true);
                    }
                    NamedElement _ownedMember_2 = parentPack.getOwnedMember(child.getElementName());
                    tempType = (Classifier)_ownedMember_2;
                }
                ret.add(tempType);
            }
            ++i;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Type> getOrcreateTypes(IDeclaration iStructure, IParent parent, Model model) {
        try {
            ICElement[] _children;
            Include _stereotypeApplication;
            boolean _isApplied;
            boolean _not;
            int _size_1;
            int _contains;
            UniqueEList ret = new UniqueEList();
            String _elementName = iStructure.getElementName();
            String _plus = "Parsing type " + _elementName;
            this.m_monitor.subTask(_plus);
            Classifier tempType = null;
            IDeclaration istructure = iStructure;
            String elementName = istructure.getElementName();
            Package parentPack = this.getContainerPackage(istructure.getTranslationUnit());
            Classifier parentClass = null;
            ICElement _parent = istructure.getParent();
            if (_parent instanceof IStructure) {
                boolean _tripleEquals;
                Type _uMLType = this.getUMLType(istructure.getParent().getElementName(), istructure.getTranslationUnit(), this.getContextNamespaces((ICElement)istructure));
                parentClass = (Classifier)_uMLType;
                NamedElement _ownedMember = parentClass.getOwnedMember(elementName);
                boolean bl = _tripleEquals = _ownedMember == null;
                if (_tripleEquals) {
                    this.createOrgetClassifier((PackageableElement)parentClass, (ICElement)istructure, true);
                }
                NamedElement _ownedMember_1 = parentClass.getOwnedMember(elementName);
                tempType = (Classifier)_ownedMember_1;
            } else {
                boolean _tripleEquals_1;
                Type _ownedType = parentPack.getOwnedType(elementName);
                boolean bl = _tripleEquals_1 = _ownedType == null;
                if (_tripleEquals_1) {
                    this.createOrgetClassifier((PackageableElement)parentPack, (ICElement)istructure, true);
                }
                NamedElement _ownedMember_2 = parentPack.getOwnedMember(elementName);
                tempType = (Classifier)_ownedMember_2;
            }
            if (tempType != null) {
                ret.add(tempType);
                if (istructure instanceof IParent) {
                    UniqueEList nestedStructures = new UniqueEList();
                    Iterables.addAll((Collection)nestedStructures, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IParent)istructure).getChildren())), IDeclaration.class));
                    Iterables.addAll((Collection)nestedStructures, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IParent)istructure).getChildren())), ITypeDef.class));
                    int _size = nestedStructures.size();
                    ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
                    for (Integer i : _doubleDotLessThan) {
                        EObject _createOrgetClassifier_1;
                        Type t_1;
                        boolean isAnonEnumInstance;
                        ICElement ns;
                        block36: {
                            boolean _not2;
                            ns = (ICElement)nestedStructures.get(i);
                            boolean _isEmpty = ns.getElementName().trim().isEmpty();
                            boolean bl = _not2 = !_isEmpty;
                            if (_not2) {
                                EObject _createOrgetClassifier = this.createOrgetClassifier((PackageableElement)tempType, ns, true);
                                Type t = (Type)_createOrgetClassifier;
                                if (t == null) continue;
                                ret.add(t);
                                continue;
                            }
                            if (!(ns instanceof IEnumeration)) continue;
                            isAnonEnumInstance = false;
                            try {
                                ICElement nextNs;
                                boolean _lessThan;
                                int _size_12 = nestedStructures.size();
                                boolean bl2 = _lessThan = i + 1 < _size_12;
                                if (!_lessThan || !((nextNs = (ICElement)nestedStructures.get(i + 1)) instanceof IField)) break block36;
                                String nsRaw = this.findEnclosingNode((ISourceReference)ns).getRawSignature();
                                String nextNsRaw = this.findEnclosingNode((ISourceReference)nextNs).getRawSignature();
                                _contains = nextNsRaw.contains(nsRaw) ? 1 : 0;
                                if (_contains != 0) {
                                    isAnonEnumInstance = true;
                                }
                            }
                            catch (Throwable _t) {
                                if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                Exception e = (Exception)_t;
                                e.printStackTrace();
                            }
                        }
                        if (isAnonEnumInstance || (t_1 = (Type)(_createOrgetClassifier_1 = this.createOrgetClassifier((PackageableElement)tempType, ns, true))) == null) continue;
                        ret.add(t_1);
                    }
                }
            }
            if (istructure instanceof IStructureTemplate) {
                IStructureTemplate istructureTemplate = (IStructureTemplate)istructure;
                int ti = 0;
                while (ti < ((List)Conversions.doWrapArray((Object)istructureTemplate.getTemplateParameterTypes())).size()) {
                    this.createOrgetTemplateParameter((NamedElement)tempType, istructureTemplate.getTemplateParameterTypes()[ti], "class");
                    ++ti;
                }
            }
            boolean _greaterThan = (_size_1 = ret.size()) > 0;
            if (!_greaterThan) return ret;
            if (tempType instanceof Enumeration) return ret;
            if (tempType instanceof PrimitiveType) return ret;
            ITranslationUnit structureItu = istructure.getTranslationUnit();
            IParent file = parent;
            List<IInclude> excludedIncludes = null;
            if (structureItu instanceof IParent) {
                file = structureItu;
                String key = this.getExcludedIncludesMapKey(structureItu, (Element)tempType);
                excludedIncludes = this.excludedIncludesMap.get(key);
            }
            boolean bl = _not = !(_isApplied = StereotypeUtil.isApplied((Element)tempType, Include.class));
            if (_not) {
                StereotypeUtil.apply((Element)tempType, Include.class);
            }
            boolean _tripleNotEquals = (_stereotypeApplication = (Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class)) != null;
            if (!_tripleNotEquals) return ret;
            String header = ((Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class)).getHeader();
            String escape = "";
            ICElement[] iCElementArray = _children = file.getChildren();
            _contains = _children.length;
            int nextNsRaw = 0;
            while (true) {
                block37: {
                    ICElement j;
                    block38: {
                        if (nextNsRaw >= _contains) {
                            Include _stereotypeApplication_1 = (Include)UMLUtil.getStereotypeApplication((Element)tempType, Include.class);
                            _stereotypeApplication_1.setHeader(header);
                            if (!(file instanceof ITranslationUnit)) return ret;
                            try {
                                IPath sourcePath = ((ITranslationUnit)file).getPath().removeFileExtension().addFileExtension("cpp");
                                ICElement sourceFile = ((ITranslationUnit)file).getCProject().findElement(sourcePath);
                                if (!(sourceFile instanceof ITranslationUnit)) return ret;
                                BatchReverseFunctionBody.updateCppInclude((ITranslationUnit)sourceFile, tempType);
                                return ret;
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Exception) return ret;
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        }
                        j = iCElementArray[nextNsRaw];
                        if (!(j instanceof IInclude)) break block38;
                        boolean excluded = false;
                        if (excludedIncludes != null) {
                            excluded = excludedIncludes.contains(j);
                        }
                        if (!excluded && !header.contains(((IInclude)j).getElementName())) {
                            boolean _contains2 = ((IInclude)j).getElementName().contains("Pkg_");
                            if (_contains2) {
                                try {
                                    boolean _not_1;
                                    String[] includeTokens = ((IInclude)j).getElementName().split("/");
                                    String includeTrimmed = "";
                                    int _length = includeTokens.length;
                                    int _minus = _length - 1;
                                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _minus, true);
                                    for (Integer i_1 : _doubleDotLessThan_1) {
                                        String _includeTrimmed = includeTrimmed;
                                        String _get = includeTokens[i_1];
                                        includeTrimmed = String.valueOf(_includeTrimmed) + _get;
                                    }
                                    String[] typeQualifiedNameTokens = tempType.getQualifiedName().split("::");
                                    String typeQualifiedNameTrimmed = "";
                                    int _length_1 = typeQualifiedNameTokens.length;
                                    int _minus_1 = _length_1 - 1;
                                    ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(1, _minus_1, true);
                                    Iterator iterator = _doubleDotLessThan_2.iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            boolean _equals = includeTrimmed.equals(typeQualifiedNameTrimmed);
                                            boolean bl3 = _not_1 = !_equals;
                                        }
                                        Integer i_2 = (Integer)iterator.next();
                                        String _typeQualifiedNameTrimmed = typeQualifiedNameTrimmed;
                                        String _get_1 = typeQualifiedNameTokens[i_2];
                                        typeQualifiedNameTrimmed = String.valueOf(_typeQualifiedNameTrimmed) + _get_1;
                                    }
                                    if (_not_1) {
                                        String _plus_2;
                                        String _elementName_1 = ((IInclude)j).getElementName();
                                        String _plus_1 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_1;
                                        header = _plus_2 = String.valueOf(_plus_1) + "\"";
                                        escape = "\n";
                                    }
                                    break block37;
                                }
                                catch (Throwable _t) {
                                    String _plus_4;
                                    if (!(_t instanceof Exception)) throw Exceptions.sneakyThrow((Throwable)_t);
                                    Exception e = (Exception)_t;
                                    e.printStackTrace();
                                    String _elementName_2 = ((IInclude)j).getElementName();
                                    String _plus_3 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_2;
                                    header = _plus_4 = String.valueOf(_plus_3) + "\"";
                                    escape = "\n";
                                }
                                break block37;
                            } else {
                                String _plus_2;
                                String _elementName_1 = ((IInclude)j).getElementName();
                                String _plus_1 = String.valueOf(header) + escape + "#include " + "\"" + _elementName_1;
                                header = _plus_2 = String.valueOf(_plus_1) + "\"";
                                escape = "\n";
                            }
                        }
                        break block37;
                    }
                    if (j instanceof IMacro) {
                        IASTNode node;
                        boolean _not_1;
                        boolean _contains_1 = header.contains(((IMacro)j).getElementName());
                        boolean bl4 = _not_1 = !_contains_1;
                        if (_not_1 && (node = this.findEnclosingNode((ISourceReference)j)) != null) {
                            int _indexOf;
                            int _plus_3;
                            String nodeString = node.toString();
                            String value = nodeString.substring(_plus_3 = (_indexOf = nodeString.indexOf("=")) + 1);
                            if (value == null || value.equals("")) {
                                boolean _not_2;
                                boolean _contains_2 = ((IMacro)j).getElementName().contains(tempType.getName().replaceAll(" ", "").toUpperCase());
                                boolean bl5 = _not_2 = !_contains_2;
                                if (_not_2) {
                                    String _plus_6;
                                    String _elementName_2 = ((IMacro)j).getElementName();
                                    String _plus_4 = String.valueOf(header) + escape + "#define " + _elementName_2;
                                    String _plus_5 = String.valueOf(_plus_4) + " ";
                                    header = _plus_6 = String.valueOf(_plus_5) + value;
                                    escape = "\n";
                                }
                            } else {
                                String _plus_9;
                                String _elementName_3 = ((IMacro)j).getElementName();
                                String _plus_7 = String.valueOf(header) + escape + "#define " + _elementName_3;
                                String _plus_8 = String.valueOf(_plus_7) + " ";
                                header = _plus_9 = String.valueOf(_plus_8) + value;
                                escape = "\n";
                            }
                        }
                    }
                }
                ++nextNsRaw;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void syncTranslationUnit(ITranslationUnit itu) {
        try {
            Iterable structures = Iterables.filter(this.reverse_utils.getAllIStructures((IParent)itu, false, true, this.m_project), IStructure.class);
            for (IStructure structure : structures) {
                Type classifier = this.getClassifier(this.getCorrespondingModel(itu), (ICElement)structure, structure.getElementName(), itu);
                if (!(classifier instanceof Classifier)) continue;
                this.syncIStructureToModel((Classifier)classifier, structure);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object syncIStructureToModel(Classifier classifier, IStructure istructure) {
        try {
            Object _xblockexpression = null;
            List fields = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)istructure.getChildren())), IField.class));
            List attributes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class));
            this.mergeAttributes(classifier, attributes, fields);
            List methods = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)istructure.getChildren())), IMethodDeclaration.class));
            List operations = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Operation.class));
            this.mergeOperations(classifier, operations, methods);
            List declarations = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)istructure.getChildren())), IDeclaration.class));
            List nestedTypes = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Type.class));
            _xblockexpression = this.mergeNestedTypes(classifier, nestedTypes, declarations);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void mergeAttributes(Classifier parent, List<Property> attributes, List<IField> fields) {
        try {
            UniqueEList foundFieldList = new UniqueEList();
            UniqueEList notFoundFieldList = new UniqueEList();
            UniqueEList foundAttrList = new UniqueEList();
            UniqueEList notFoundAttrList = new UniqueEList();
            for (final IField field : fields) {
                boolean isModelObjectChanged;
                Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

                    public Boolean apply(Property it) {
                        return it.getName().equals(field.getElementName());
                    }
                };
                final Property attrFound = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter(attributes, (Functions.Function1)_function));
                if (attrFound == null) {
                    notFoundFieldList.add((Object)field);
                    continue;
                }
                foundAttrList.add((Object)attrFound);
                foundFieldList.add((Object)field);
                Functions.Function1<ModelChangeObject, Boolean> _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)attrFound);
                    }
                };
                ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_1));
                boolean bl = isModelObjectChanged = _head != null;
                if (isModelObjectChanged) {
                    this.syncAttributeWithMode(parent, attrFound, field, this.conflictResolveMode);
                    continue;
                }
                this.syncAttributeWithMode(parent, attrFound, field, ConflictResolutionMode.FROM_CODE);
            }
            for (Property attr : attributes) {
                boolean _not;
                boolean _contains = foundAttrList.contains((Object)attr);
                boolean bl = _not = !_contains;
                if (!_not) continue;
                notFoundAttrList.add((Object)attr);
            }
            Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return it.eventType == 3;
                }
            };
            List addChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
            UniqueEList tobeRemovedsInNotFound = new UniqueEList();
            for (final Property attr_1 : notFoundAttrList) {
                Functions.Function1<ModelChangeObject, Boolean> _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)attr_1);
                    }
                };
                ModelChangeObject modelChangeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)addChanges, (Functions.Function1)_function_1));
                if (modelChangeObj == null) continue;
                tobeRemovedsInNotFound.add((Object)attr_1);
            }
            for (Property i : tobeRemovedsInNotFound) {
                notFoundAttrList.remove((Object)i);
            }
            UniqueEList processedFields = new UniqueEList();
            UniqueEList remainingFields = new UniqueEList();
            UniqueEList remainingAttributes = new UniqueEList();
            for (IField notFoundField : notFoundFieldList) {
                boolean _lessThan;
                boolean _not_1;
                boolean _contains_1 = processedFields.contains((Object)notFoundField);
                boolean bl = _not_1 = !_contains_1;
                if (!_not_1) continue;
                final Type umlType = this.getUMLType((IVariableDeclaration)notFoundField, this.getContextNamespaces((ICElement)notFoundField));
                final String typeName = this.getCppTypeName(notFoundField.getTypeName());
                Functions.Function1<IField, Boolean> _function_1 = new Functions.Function1<IField, Boolean>(){

                    public Boolean apply(IField it) {
                        try {
                            return ReverseCpp2Uml.this.getCppTypeName(it.getTypeName()).equals(typeName);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                List sameTypeNameFields = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundFieldList, (Functions.Function1)_function_1));
                Functions.Function1<Property, Boolean> _function_2 = new Functions.Function1<Property, Boolean>(){

                    public Boolean apply(Property it) {
                        return it.getType().getName().equals(umlType.getName());
                    }
                };
                List sameTypeAttrs = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundAttrList, (Functions.Function1)_function_2));
                int i_1 = 0;
                i_1 = 0;
                while (i_1 < sameTypeNameFields.size()) {
                    boolean _greaterEqualsThan;
                    int _size = sameTypeAttrs.size();
                    boolean bl2 = _greaterEqualsThan = i_1 >= _size;
                    if (_greaterEqualsThan) {
                        remainingFields.add((Object)((IField)sameTypeNameFields.get(i_1)));
                    } else {
                        boolean isModelObjectChanged;
                        IField tobeProcessedField = (IField)sameTypeNameFields.get(i_1);
                        final Property tobeProcessedAttr = (Property)sameTypeAttrs.get(i_1);
                        Functions.Function1<ModelChangeObject, Boolean> _function_3 = new Functions.Function1<ModelChangeObject, Boolean>(){

                            public Boolean apply(ModelChangeObject it) {
                                return Objects.equal((Object)it.eObject, (Object)tobeProcessedAttr);
                            }
                        };
                        ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_3));
                        boolean bl3 = isModelObjectChanged = _head != null;
                        if (isModelObjectChanged) {
                            this.syncAttributeWithMode(parent, tobeProcessedAttr, tobeProcessedField, ConflictResolutionMode.FROM_MODEL);
                        } else {
                            this.syncAttributeWithMode(parent, tobeProcessedAttr, tobeProcessedField, ConflictResolutionMode.FROM_CODE);
                        }
                        processedFields.add((Object)tobeProcessedField);
                        notFoundAttrList.remove((Object)tobeProcessedAttr);
                    }
                    ++i_1;
                }
                List _converted_sameTypeAttrs = sameTypeAttrs;
                int _length = ((Object[])Conversions.unwrapArray((Object)_converted_sameTypeAttrs, Object.class)).length;
                boolean bl4 = _lessThan = i_1 < _length;
                if (!_lessThan) continue;
                int j = i_1;
                while (j < ((Object[])Conversions.unwrapArray((Object)sameTypeAttrs, Object.class)).length) {
                    remainingAttributes.add((Object)((Property)sameTypeAttrs.get(j)));
                    ++j;
                }
            }
            for (Property notFoundAttr : notFoundAttrList) {
                boolean _not_2;
                boolean _contains_2 = remainingAttributes.contains((Object)notFoundAttr);
                boolean bl = _not_2 = !_contains_2;
                if (!_not_2) continue;
                remainingAttributes.add((Object)notFoundAttr);
            }
            for (IField remaining : remainingFields) {
                this.createProperty(remaining, parent);
            }
            Functions.Function1<ModelChangeObject, Boolean> _function_3 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return it.eventType == 3 || it.eventType == 1;
                }
            };
            List remainingChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_3));
            for (final Property remaining_1 : remainingAttributes) {
                Functions.Function1<ModelChangeObject, Boolean> _function_4 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)remaining_1);
                    }
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)remainingChanges, (Functions.Function1)_function_4));
                if (!_isEmpty) continue;
                if (parent instanceof Class) {
                    EList _ownedAttributes = ((Class)parent).getOwnedAttributes();
                    _ownedAttributes.remove((Object)remaining_1);
                    continue;
                }
                if (!(parent instanceof DataType)) continue;
                EList _ownedAttributes_1 = ((DataType)parent).getOwnedAttributes();
                _ownedAttributes_1.remove((Object)remaining_1);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Boolean syncAttributeWithMode(Classifier parent, final Property attribute, IField field, ConflictResolutionMode resolveMode) {
        Boolean _switchResult = null;
        if (resolveMode != null) {
            switch (resolveMode) {
                case FROM_MODEL: {
                    _switchResult = null;
                    break;
                }
                case FROM_CODE: {
                    boolean _xblockexpression = false;
                    Type type = this.getUMLType((IVariableDeclaration)field, this.getContextNamespaces((ICElement)field));
                    attribute.setType(type);
                    attribute.setName(field.getElementName());
                    this.updateProperty(field, attribute);
                    Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

                        public Boolean apply(ModelChangeObject it) {
                            return Objects.equal((Object)it.eObject, (Object)attribute);
                        }
                    };
                    ModelChangeObject changeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
                    boolean _xifexpression = false;
                    if (changeObj != null) {
                        _xifexpression = modelChangeList.remove(changeObj);
                    }
                    _xblockexpression = _xifexpression;
                    _switchResult = _xblockexpression;
                    break;
                }
                case UI_INTERACTION: {
                    _switchResult = null;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private Boolean syncOperationWithMode(Classifier parent, final Operation op, IMethodDeclaration method, ConflictResolutionMode resolveMode) {
        Boolean _switchResult = null;
        if (resolveMode != null) {
            switch (resolveMode) {
                case FROM_MODEL: {
                    _switchResult = null;
                    break;
                }
                case FROM_CODE: {
                    boolean _xblockexpression = false;
                    op.setName(method.getElementName());
                    this.updateMethod((Class)parent, op, method);
                    Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

                        public Boolean apply(ModelChangeObject it) {
                            return Objects.equal((Object)it.eObject, (Object)op);
                        }
                    };
                    ModelChangeObject changeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
                    boolean _xifexpression = false;
                    if (changeObj != null) {
                        _xifexpression = modelChangeList.remove(changeObj);
                    }
                    _xblockexpression = _xifexpression;
                    _switchResult = _xblockexpression;
                    break;
                }
                case UI_INTERACTION: {
                    _switchResult = null;
                    break;
                }
            }
        }
        return _switchResult;
    }

    private boolean isSameOperation(Operation op, IMethodDeclaration method) {
        boolean ret = true;
        boolean _equals = op.getName().equals(method.getElementName());
        boolean _not = !_equals;
        ret = _not ? false : this.isSameSignature(op, method);
        return ret;
    }

    private boolean isSameSignature(Operation op, IMethodDeclaration method) {
        int _size;
        boolean _notEquals;
        boolean ret = true;
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            }
        };
        List params = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function));
        int _numberOfParameters = method.getNumberOfParameters();
        boolean bl = _notEquals = _numberOfParameters != (_size = params.size());
        if (_notEquals) {
            ret = false;
        } else {
            int i = 0;
            while (i < method.getNumberOfParameters()) {
                boolean _not;
                boolean _equals = this.getCppTypeName(method.getParameterTypes()[i]).equals(((Parameter)params.get(i)).getType().getName());
                boolean bl2 = _not = !_equals;
                if (_not) {
                    ret = false;
                }
                ++i;
            }
            if (ret) {
                Functions.Function1<Parameter, Boolean> _function_1 = new Functions.Function1<Parameter, Boolean>(){

                    public Boolean apply(Parameter it) {
                        ParameterDirectionKind _direction = it.getDirection();
                        return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                    }
                };
                Parameter returnParam = (Parameter)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function_1));
                if (returnParam == null) {
                    boolean _not;
                    boolean _equals = this.getCppTypeName(method.getReturnType()).equals("void");
                    boolean bl3 = _not = !_equals;
                    if (_not) {
                        ret = false;
                    }
                } else if (returnParam.getType() != null && !this.getCppTypeName(method.getReturnType()).equals(returnParam.getType().getName())) {
                    ret = false;
                }
            }
        }
        return ret;
    }

    private boolean isSameMethodDeclaration(IMethodDeclaration method1, IMethodDeclaration method2) {
        try {
            boolean result = true;
            result = result && method1.getSignature().equals(method2.getSignature());
            result = result && Objects.equal((Object)this.convertVisibility(method1.getVisibility()), (Object)this.convertVisibility(method2.getVisibility()));
            result = result && method1.isStatic() == method2.isStatic();
            result = result && method1.isVirtual() == method2.isVirtual();
            result = result && method1.isVirtual() == method2.isVirtual();
            result = result && method1.isInline() == method2.isInline();
            result = result && method1.isFriend() == method2.isFriend();
            result = result && method1.isVolatile() == method2.isVolatile();
            result = result && method1.isConstructor() == method2.isConstructor();
            result = result && method1.isDestructor() == method2.isDestructor();
            boolean bl = result = result && method1.getReturnType() != null && method2.getReturnType() != null;
            if (method1.getReturnType() != null && method2.getReturnType() != null) {
                result = result && method1.getReturnType().equals(method2.getReturnType());
            }
            boolean bl2 = result = result && method1.getNumberOfParameters() == method2.getNumberOfParameters();
            if (!result) {
                return result;
            }
            try {
                IASTFunctionDeclarator declarator1 = this.getDeclarator(method1);
                IASTFunctionDeclarator declarator2 = this.getDeclarator(method2);
                result = result && declarator1.getRawSignature().equals(declarator2.getRawSignature());
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                    return result;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private int getNumberOfSameParameters(Operation op, IMethodDeclaration method) {
        int ret = 0;
        Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

            public Boolean apply(Parameter it) {
                ParameterDirectionKind _direction = it.getDirection();
                return !Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            }
        };
        List params = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)op.getOwnedParameters(), (Functions.Function1)_function));
        int i = 0;
        while (i < method.getNumberOfParameters()) {
            boolean _lessEqualsThan;
            int _size = params.size();
            boolean bl = _lessEqualsThan = i <= _size;
            if (_lessEqualsThan && ((Parameter)params.get(i)).getType() != null && this.getCppTypeName(method.getParameterTypes()[i]).equals(((Parameter)params.get(i)).getType().getName())) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    private Operation findMostSameOperation(List<Operation> ops, IMethodDeclaration method) {
        boolean _isEmpty = ops.isEmpty();
        if (_isEmpty) {
            return null;
        }
        Operation ret = (Operation)IterableExtensions.head(ops);
        for (Operation op : ops) {
            int _numberOfSameParameters_1;
            boolean _greaterThan;
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)ret, (Object)op);
            if (!_notEquals) continue;
            int _numberOfSameParameters = this.getNumberOfSameParameters(op, method);
            boolean bl2 = _greaterThan = _numberOfSameParameters > (_numberOfSameParameters_1 = this.getNumberOfSameParameters(ret, method));
            if (!_greaterThan) continue;
            ret = op;
        }
        return ret;
    }

    private void mergeOperations(Classifier parent, List<Operation> operations, List<IMethodDeclaration> methods) {
        UniqueEList foundMethodList = new UniqueEList();
        UniqueEList notFoundMethodList = new UniqueEList();
        UniqueEList foundOperationList = new UniqueEList();
        UniqueEList notFoundOperationList = new UniqueEList();
        for (final IMethodDeclaration method : methods) {
            boolean bl;
            Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return ReverseCpp2Uml.this.isSameOperation(it, method);
                }
            };
            final Operation opFound = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter(operations, (Functions.Function1)_function));
            if (opFound == null) {
                notFoundMethodList.add((Object)method);
                continue;
            }
            foundOperationList.add((Object)opFound);
            foundMethodList.add((Object)method);
            Functions.Function1<ModelChangeObject, Boolean> _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)opFound);
                }
            };
            ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_1));
            boolean bl2 = bl = _head != null;
        }
        for (Operation op : operations) {
            boolean _not;
            boolean _contains = foundOperationList.contains((Object)op);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            notFoundOperationList.add((Object)op);
        }
        Functions.Function1<ModelChangeObject, Boolean> _function = new Functions.Function1<ModelChangeObject, Boolean>(){

            public Boolean apply(ModelChangeObject it) {
                return it.eventType == 3;
            }
        };
        List addChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function));
        UniqueEList tobeRemovedsInNotFound = new UniqueEList();
        for (final Operation op_1 : notFoundOperationList) {
            Functions.Function1<ModelChangeObject, Boolean> _function_1 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)op_1);
                }
            };
            ModelChangeObject modelChangeObj = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)addChanges, (Functions.Function1)_function_1));
            if (modelChangeObj == null) continue;
            tobeRemovedsInNotFound.add((Object)op_1);
        }
        for (Operation i : tobeRemovedsInNotFound) {
            notFoundOperationList.remove((Object)i);
        }
        UniqueEList processedMethods = new UniqueEList();
        UniqueEList remainingMethods = new UniqueEList();
        UniqueEList remainingOperations = new UniqueEList();
        for (final IMethodDeclaration notFoundMethod : notFoundMethodList) {
            boolean isModelObjectChanged_1;
            boolean _greaterThan;
            boolean _not_1;
            boolean _contains_1 = processedMethods.contains((Object)notFoundMethod);
            boolean bl = _not_1 = !_contains_1;
            if (!_not_1) continue;
            final String functionName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)notFoundMethod.getElementName().split("::"))));
            Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return ReverseCpp2Uml.this.isSameSignature(it, notFoundMethod);
                }
            };
            final Operation sameSignatureOperation = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)notFoundOperationList, (Functions.Function1)_function_1));
            if (sameSignatureOperation != null) {
                boolean isModelObjectChanged;
                Functions.Function1<ModelChangeObject, Boolean> _function_2 = new Functions.Function1<ModelChangeObject, Boolean>(){

                    public Boolean apply(ModelChangeObject it) {
                        return Objects.equal((Object)it.eObject, (Object)sameSignatureOperation);
                    }
                };
                ModelChangeObject _head = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_2));
                boolean bl3 = isModelObjectChanged = _head != null;
                if (isModelObjectChanged) {
                    this.syncOperationWithMode(parent, sameSignatureOperation, notFoundMethod, ConflictResolutionMode.FROM_MODEL);
                } else {
                    this.syncOperationWithMode(parent, sameSignatureOperation, notFoundMethod, ConflictResolutionMode.FROM_CODE);
                }
                notFoundOperationList.remove((Object)sameSignatureOperation);
                processedMethods.add((Object)notFoundMethod);
                continue;
            }
            Functions.Function1<IMethodDeclaration, Boolean> _function_3 = new Functions.Function1<IMethodDeclaration, Boolean>(){

                public Boolean apply(IMethodDeclaration it) {
                    return it.getElementName().equals(functionName);
                }
            };
            List sameNameMethods = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundMethodList, (Functions.Function1)_function_3));
            Functions.Function1<Operation, Boolean> _function_4 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return it.getName().equals(functionName);
                }
            };
            List sameNameOperations = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)notFoundOperationList, (Functions.Function1)_function_4));
            int _size = sameNameOperations.size();
            boolean bl4 = _greaterThan = _size > 0;
            if (_greaterThan) {
                boolean _lessThan;
                int i_1 = 0;
                i_1 = 0;
                while (i_1 < sameNameMethods.size()) {
                    boolean _greaterEqualsThan;
                    int _size_1 = sameNameOperations.size();
                    boolean bl5 = _greaterEqualsThan = i_1 >= _size_1;
                    if (_greaterEqualsThan) {
                        remainingMethods.add((Object)((IMethodDeclaration)sameNameMethods.get(i_1)));
                    } else {
                        boolean isModelObjectChanged_12;
                        IMethodDeclaration tobeProcessedMethod = (IMethodDeclaration)sameNameMethods.get(i_1);
                        final Operation tobeProcessedOp = (Operation)sameNameOperations.get(i_1);
                        Functions.Function1<ModelChangeObject, Boolean> _function_5 = new Functions.Function1<ModelChangeObject, Boolean>(){

                            public Boolean apply(ModelChangeObject it) {
                                return Objects.equal((Object)it.eObject, (Object)tobeProcessedOp);
                            }
                        };
                        ModelChangeObject _head_1 = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_5));
                        boolean bl6 = isModelObjectChanged_12 = _head_1 != null;
                        if (isModelObjectChanged_12) {
                            this.syncOperationWithMode(parent, tobeProcessedOp, tobeProcessedMethod, ConflictResolutionMode.FROM_MODEL);
                        } else {
                            this.syncOperationWithMode(parent, tobeProcessedOp, tobeProcessedMethod, ConflictResolutionMode.FROM_CODE);
                        }
                        processedMethods.add((Object)tobeProcessedMethod);
                        notFoundOperationList.remove((Object)tobeProcessedOp);
                    }
                    ++i_1;
                }
                int _length = ((Object[])Conversions.unwrapArray((Object)sameNameOperations, Object.class)).length;
                boolean bl7 = _lessThan = i_1 < _length;
                if (!_lessThan) continue;
                int j = i_1;
                while (j < ((Object[])Conversions.unwrapArray((Object)sameNameOperations, Object.class)).length) {
                    remainingOperations.add((Object)((Operation)sameNameOperations.get(j)));
                    ++j;
                }
                continue;
            }
            final Operation mostSameOp = this.findMostSameOperation((List<Operation>)notFoundOperationList, notFoundMethod);
            if (mostSameOp == null) continue;
            Functions.Function1<ModelChangeObject, Boolean> _function_5 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)mostSameOp);
                }
            };
            ModelChangeObject _head_1 = (ModelChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_5));
            boolean bl8 = isModelObjectChanged_1 = _head_1 != null;
            if (isModelObjectChanged_1) {
                this.syncOperationWithMode(parent, mostSameOp, notFoundMethod, ConflictResolutionMode.FROM_MODEL);
            } else {
                this.syncOperationWithMode(parent, mostSameOp, notFoundMethod, ConflictResolutionMode.FROM_CODE);
            }
            processedMethods.add((Object)notFoundMethod);
            notFoundOperationList.remove((Object)mostSameOp);
        }
        for (Operation notFoundOp : notFoundOperationList) {
            boolean _not_2;
            boolean _contains_2 = remainingOperations.contains((Object)notFoundOp);
            boolean bl = _not_2 = !_contains_2;
            if (!_not_2) continue;
            remainingOperations.add((Object)notFoundOp);
        }
        for (IMethodDeclaration remaining : remainingMethods) {
            this.createMethod(remaining, (Class)parent);
        }
        Functions.Function1<ModelChangeObject, Boolean> _function_6 = new Functions.Function1<ModelChangeObject, Boolean>(){

            public Boolean apply(ModelChangeObject it) {
                return it.eventType == 3 || it.eventType == 1;
            }
        };
        List remainingChanges = IterableExtensions.toList((Iterable)IterableExtensions.filter(modelChangeList, (Functions.Function1)_function_6));
        for (final Operation remaining_1 : remainingOperations) {
            Functions.Function1<ModelChangeObject, Boolean> _function_7 = new Functions.Function1<ModelChangeObject, Boolean>(){

                public Boolean apply(ModelChangeObject it) {
                    return Objects.equal((Object)it.eObject, (Object)remaining_1);
                }
            };
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)remainingChanges, (Functions.Function1)_function_7));
            if (!_isEmpty) continue;
            if (parent instanceof Class) {
                EList _ownedOperations = ((Class)parent).getOwnedOperations();
                _ownedOperations.remove((Object)remaining_1);
                continue;
            }
            if (!(parent instanceof DataType)) continue;
            EList _ownedOperations_1 = ((DataType)parent).getOwnedOperations();
            _ownedOperations_1.remove((Object)remaining_1);
        }
    }

    private Object mergeNestedTypes(Classifier parent, List<Type> nestedTypes, List<IDeclaration> declarations) {
        return null;
    }

    private void reverseIncrementalChanges() {
        this.changeList.clear();
        this.optimizeChangeList();
        for (CppChangeObject change : this.changeList) {
            int _switchValue = change.changeKind;
            switch (_switchValue) {
                case 1: {
                    this.addToModel(change);
                    break;
                }
                case 4: {
                    this.updateToModel(change);
                    break;
                }
                case 2: {
                    this.removeFromModel(change);
                }
            }
        }
        this.changeList.clear();
    }

    private List<CElementChange> getRawChangeList() {
        if (ChangeMapStore.changesMap != null && ChangeMapStore.changesMap.get(this.m_project.getElementName()) != null && ChangeMapStore.changesMap.get(this.m_project.getElementName()).size() > 0) {
            return ChangeMapStore.changesMap.get(this.m_project.getElementName());
        }
        return null;
    }

    private void clearRawChangeList() {
        if (ChangeMapStore.changesMap != null && this.m_project != null && ChangeMapStore.changesMap.get(this.m_project.getElementName()) != null) {
            ChangeMapStore.changesMap.get(this.m_project.getElementName()).clear();
        }
    }

    private void optimizeChangeList() {
        List<CElementChange> rawChangeList = this.getRawChangeList();
        this.changeList.clear();
        UniqueEList processedList = new UniqueEList();
        UniqueEList remainList = new UniqueEList();
        int i = 0;
        while (i < rawChangeList.size()) {
            CElementChange change = rawChangeList.get(i);
            boolean _isInSourceContainers = this.isInSourceContainers(change.getElement());
            if (_isInSourceContainers) {
                boolean _contains_1;
                boolean _not_1;
                boolean _not;
                boolean _contains = processedList.contains(change);
                boolean bl = _not = !_contains;
                if (_not) {
                    int _changeKind = change.getChangeKind();
                    switch (_changeKind) {
                        case 1: {
                            boolean _greaterThan;
                            List<CElementChange> inter = this.findIntermediateEvent(rawChangeList, i, change);
                            int _size = inter.size();
                            boolean bl2 = _greaterThan = _size > 0;
                            if (!_greaterThan) break;
                            processedList.add(change);
                            processedList.addAll(inter);
                            break;
                        }
                        case 4: {
                            boolean _greaterThan_1;
                            List<CElementChange> inter_1 = this.findIntermediateEvent(rawChangeList, i, change);
                            int _size_1 = inter_1.size();
                            boolean bl3 = _greaterThan_1 = _size_1 > 0;
                            if (!_greaterThan_1) break;
                            processedList.addAll(inter_1);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            processedList.add(change);
                        }
                    }
                }
                boolean bl4 = _not_1 = !(_contains_1 = processedList.contains(change));
                if (_not_1) {
                    remainList.add(change);
                }
            }
            ++i;
        }
        HashMap doubtChangeListMap = new HashMap();
        int i2 = 0;
        while (i2 < remainList.size()) {
            CElementChange change = (CElementChange)remainList.get(i2);
            CppChangeObject cppChangeObject = null;
            int _changeKind = change.getChangeKind();
            switch (_changeKind) {
                case 1: {
                    CppChangeObject _cppChangeObject;
                    boolean found = false;
                    int j = i2 + 1;
                    while (j < remainList.size() && !found) {
                        if (((CElementChange)remainList.get(j)).getChangeKind() == 2 && change.getElement().getElementType() == ((CElementChange)remainList.get(j)).getElement().getElementType() && Objects.equal((Object)((CElementChange)remainList.get(j)).getParent(), (Object)change.getParent())) {
                            boolean _tripleEquals;
                            CppChangeObject _cppChangeObject2;
                            ICElement _element = ((CElementChange)remainList.get(j)).getElement();
                            ICElement _element_1 = change.getElement();
                            ITranslationUnit _translationUnitFromElement = this.reverse_utils.getTranslationUnitFromElement(change.getElement());
                            ICElement _parent = change.getParent();
                            cppChangeObject = _cppChangeObject2 = new CppChangeObject(_element, _element_1, _translationUnitFromElement, _parent, 4);
                            List _get = (List)doubtChangeListMap.get(change.getParent());
                            boolean bl = _tripleEquals = _get == null;
                            if (_tripleEquals) {
                                ICElement _parent_1 = change.getParent();
                                ArrayList _arrayList = new ArrayList();
                                doubtChangeListMap.put(_parent_1, _arrayList);
                            }
                            if (change.getElement() instanceof IField || change.getElement() instanceof IMethodDeclaration || change.getElement() instanceof IEnumerator) {
                                ((List)doubtChangeListMap.get(change.getParent())).add(cppChangeObject);
                            }
                            remainList.remove(j);
                            --j;
                            found = true;
                        }
                        ++j;
                    }
                    if (found) break;
                    ICElement _element = change.getElement();
                    ITranslationUnit _translationUnitFromElement = this.reverse_utils.getTranslationUnitFromElement(change.getElement());
                    ICElement _parent = change.getParent();
                    cppChangeObject = _cppChangeObject = new CppChangeObject(null, _element, _translationUnitFromElement, _parent, 1);
                    break;
                }
                case 4: {
                    CppChangeObject _cppChangeObject_1;
                    ICElement _element_1 = ((CElementChange)remainList.get(i2)).getElement();
                    ICElement _element_2 = change.getElement();
                    ITranslationUnit _translationUnitFromElement_1 = this.reverse_utils.getTranslationUnitFromElement(change.getElement());
                    ICElement _parent_1 = change.getParent();
                    cppChangeObject = _cppChangeObject_1 = new CppChangeObject(_element_1, _element_2, _translationUnitFromElement_1, _parent_1, 4);
                    break;
                }
                case 2: {
                    CppChangeObject _cppChangeObject_2;
                    ICElement _element_3;
                    boolean found_1 = false;
                    int j_1 = i2 + 1;
                    while (j_1 < remainList.size() && !found_1) {
                        if (((CElementChange)remainList.get(j_1)).getChangeKind() == 1 && change.getElement().getElementType() == ((CElementChange)remainList.get(j_1)).getElement().getElementType()) {
                            boolean _tripleEquals;
                            CppChangeObject _cppChangeObject_22;
                            _element_3 = change.getElement();
                            ICElement _element_4 = ((CElementChange)remainList.get(j_1)).getElement();
                            ITranslationUnit _translationUnitFromElement_2 = this.reverse_utils.getTranslationUnitFromElement(change.getElement());
                            ICElement _parent_2 = change.getParent();
                            cppChangeObject = _cppChangeObject_22 = new CppChangeObject(_element_3, _element_4, _translationUnitFromElement_2, _parent_2, 4);
                            List _get = (List)doubtChangeListMap.get(change.getParent());
                            boolean bl = _tripleEquals = _get == null;
                            if (_tripleEquals) {
                                ICElement _parent_3 = change.getParent();
                                ArrayList _arrayList = new ArrayList();
                                doubtChangeListMap.put(_parent_3, _arrayList);
                            }
                            if (change.getElement() instanceof IField || change.getElement() instanceof IMethodDeclaration || change.getElement() instanceof IEnumerator) {
                                ((List)doubtChangeListMap.get(change.getParent())).add(cppChangeObject);
                            }
                            remainList.remove(j_1);
                            --j_1;
                            found_1 = true;
                        }
                        ++j_1;
                    }
                    if (found_1) break;
                    _element_3 = change.getElement();
                    ITranslationUnit _translationUnitFromElement_2 = this.reverse_utils.getTranslationUnitFromElement(change.getElement());
                    ICElement _parent_2 = change.getParent();
                    cppChangeObject = _cppChangeObject_2 = new CppChangeObject(null, _element_3, _translationUnitFromElement_2, _parent_2, 2);
                }
            }
            if (cppChangeObject != null) {
                this.changeList.add(cppChangeObject);
            }
            ++i2;
        }
        Set _entrySet = doubtChangeListMap.entrySet();
        for (Map.Entry doubtMap : _entrySet) {
            boolean _greaterThan;
            int _size = ((List)doubtMap.getValue()).size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            this.alignChangedElements((ICElement)doubtMap.getKey(), (List)doubtMap.getValue());
        }
        this.clearRawChangeList();
    }

    private void alignChangedElements(ICElement parent, final List<CppChangeObject> changes) {
        try {
            int _size_1;
            int _size;
            boolean _equals;
            final ArrayList oldNamedElementsList = new ArrayList();
            final HashMap oldNamedElementToChangeMap = new HashMap();
            Consumer<CppChangeObject> _function = new Consumer<CppChangeObject>(){

                @Override
                public void accept(CppChangeObject it) {
                    NamedElement oldNamedElement = ReverseCpp2Uml.this.getNamedElement(it.parent, it.oldElement);
                    oldNamedElementToChangeMap.put(oldNamedElement, it);
                    oldNamedElementsList.add(oldNamedElement);
                }
            };
            changes.forEach(_function);
            EObject namedElementParent = ((NamedElement)IterableExtensions.head(oldNamedElementsList)).eContainer();
            final ArrayList alignedOldNamedElements = new ArrayList();
            Consumer<NamedElement> _function_1 = new Consumer<NamedElement>(){

                @Override
                public void accept(NamedElement it) {
                    boolean _contains = oldNamedElementsList.contains(it);
                    if (_contains) {
                        alignedOldNamedElements.add(it);
                    }
                }
            };
            Iterables.filter((Iterable)namedElementParent.eContents(), NamedElement.class).forEach(_function_1);
            final ArrayList newICElements = new ArrayList();
            if (parent instanceof IParent) {
                Consumer<ICElement> _function_2 = new Consumer<ICElement>(){

                    @Override
                    public void accept(ICElement it) {
                        final ICElement childInParent = it;
                        Functions.Function1<CppChangeObject, Boolean> _function = new Functions.Function1<CppChangeObject, Boolean>(){

                            public Boolean apply(CppChangeObject it) {
                                return Objects.equal((Object)it.newElement, (Object)childInParent);
                            }
                        };
                        CppChangeObject founded = (CppChangeObject)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)changes, (Functions.Function1)_function));
                        if (founded != null) {
                            newICElements.add(founded.newElement);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)((IParent)parent).getChildren())).forEach(_function_2);
            }
            boolean bl = _equals = (_size = alignedOldNamedElements.size()) == (_size_1 = newICElements.size());
            if (_equals) {
                int i = 0;
                while (i < alignedOldNamedElements.size()) {
                    boolean _notEquals;
                    CppChangeObject change = (CppChangeObject)oldNamedElementToChangeMap.get(alignedOldNamedElements.get(i));
                    ICElement _get = (ICElement)newICElements.get(i);
                    boolean bl2 = _notEquals = !Objects.equal((Object)change.newElement, (Object)_get);
                    if (_notEquals) {
                        boolean sameElementType = change.newElement instanceof IField && newICElements.get(i) instanceof IField;
                        sameElementType = sameElementType || change.newElement instanceof IMethodDeclaration && newICElements.get(i) instanceof IMethodDeclaration;
                        boolean bl3 = sameElementType = sameElementType || change.newElement instanceof IEnumerator && newICElements.get(i) instanceof IEnumerator;
                        if (sameElementType) {
                            change.newElement = (ICElement)newICElements.get(i);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private NamedElement getNamedElement(ICElement parent, final ICElement child) {
        try {
            Property ret = null;
            boolean _matched = false;
            if (child instanceof IField) {
                boolean _isExist;
                IStructure parentStructure;
                Type classifier;
                _matched = true;
                if (parent instanceof IStructure && (classifier = this.getClassifier(this.getCorrespondingModel((parentStructure = (IStructure)parent).getTranslationUnit()), (ICElement)parentStructure, parentStructure.getElementName(), parentStructure.getTranslationUnit())) != null && (_isExist = this.isExist((NamedElement)classifier, child.getElementName()))) {
                    Property prop;
                    Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

                        public Boolean apply(Property it) {
                            return it.getName().equals(child.getElementName());
                        }
                    };
                    ret = prop = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class), (Functions.Function1)_function));
                }
            }
            if (!_matched && child instanceof IMethodDeclaration) {
                boolean _isExist_1;
                IStructure parentStructure_1;
                Type classifier_1;
                _matched = true;
                if (parent instanceof IStructure && (classifier_1 = this.getClassifier(this.getCorrespondingModel((parentStructure_1 = (IStructure)parent).getTranslationUnit()), (ICElement)parentStructure_1, parentStructure_1.getElementName(), parentStructure_1.getTranslationUnit())) != null && (_isExist_1 = this.isExist((NamedElement)classifier_1, child.getElementName()))) {
                    IMethodDeclaration oldMethod;
                    Functions.Function1<Operation, Boolean> _function_2;
                    Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                        public Boolean apply(Operation it) {
                            return it.getName().equals(child.getElementName());
                        }
                    };
                    List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier_1.getOwnedElements(), Operation.class), (Functions.Function1)_function_1));
                    Operation op = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)(_function_2 = new Functions.Function1<Operation, Boolean>(oldMethod = (IMethodDeclaration)child){
                        private final /* synthetic */ IMethodDeclaration val$oldMethod;
                        {
                            this.val$oldMethod = iMethodDeclaration;
                        }

                        public Boolean apply(Operation it) {
                            return ReverseCpp2Uml.this.isSameSignature(it, this.val$oldMethod);
                        }
                    })));
                    if (op != null) {
                        ret = op;
                    }
                }
            }
            if (!_matched && child instanceof IEnumerator) {
                _matched = true;
                IEnumeration cppEnumeration = (IEnumeration)parent;
                Type enumeration = this.getClassifier(this.getCorrespondingModel(cppEnumeration.getTranslationUnit()), (ICElement)cppEnumeration, cppEnumeration.getElementName(), cppEnumeration.getTranslationUnit());
                if (enumeration != null && enumeration instanceof Enumeration) {
                    Functions.Function1<EnumerationLiteral, Boolean> _function_3 = new Functions.Function1<EnumerationLiteral, Boolean>(){

                        public Boolean apply(EnumerationLiteral it) {
                            String _name = it.getName();
                            String _elementName = child.getElementName();
                            return Objects.equal((Object)_name, (Object)_elementName);
                        }
                    };
                    EnumerationLiteral enumerator = (EnumerationLiteral)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Enumeration)enumeration).getOwnedLiterals(), EnumerationLiteral.class), (Functions.Function1)_function_3));
                    if (enumerator != null) {
                        ret = enumerator;
                    }
                }
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean isInSourceContainers(ICElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ICContainer && this.containers.contains(element)) {
            return true;
        }
        return this.isInSourceContainers(element.getParent());
    }

    private List<CElementChange> findIntermediateEvent(List<CElementChange> list, int position, CElementChange change) {
        boolean _greaterThan;
        UniqueEList ret = new UniqueEList();
        int i = position + 1;
        while (i < list.size()) {
            if (change.getChangeKind() == 1 && list.get(i).getChangeKind() == 2 && this.isSameICElement(change.getElement(), list.get(i).getElement())) {
                if (change.getElement() instanceof IMethodDeclaration && list.get(i).getElement() instanceof IMethodDeclaration) {
                    ICElement _element_1;
                    ICElement _element = change.getElement();
                    IMethodDeclaration method = (IMethodDeclaration)_element;
                    boolean _isSameMethodDeclaration = this.isSameMethodDeclaration(method, (IMethodDeclaration)(_element_1 = list.get(i).getElement()));
                    if (_isSameMethodDeclaration) {
                        ret.add(list.get(i));
                    }
                } else {
                    ret.add(list.get(i));
                }
            } else if (change.getChangeKind() == 4 && this.isSameICElement(change.getElement(), list.get(i).getElement())) {
                ret.add(list.get(i));
            }
            ++i;
        }
        Functions.Function1<CElementChange, Boolean> _function = new Functions.Function1<CElementChange, Boolean>(){

            public Boolean apply(CElementChange it) {
                int _changeKind = it.getChangeKind();
                return _changeKind == 4;
            }
        };
        List changed = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)ret, (Functions.Function1)_function));
        int _size = changed.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            ret.remove(IterableExtensions.last((Iterable)changed));
        }
        return ret;
    }

    private ICElement getSameICelement(ICElement element, int fromPos, int changeKind) {
        boolean _greaterEqualsThan;
        int _size = this.getRawChangeList().size();
        boolean bl = _greaterEqualsThan = fromPos >= _size;
        if (_greaterEqualsThan) {
            return null;
        }
        ICElement ret = null;
        int i = fromPos;
        while (i < this.getRawChangeList().size()) {
            CElementChange change = this.getRawChangeList().get(i);
            if (ret == null) {
                if (changeKind == 1) {
                    if (change.getChangeKind() == 2 && this.isSameICElement(element, change.getElement())) {
                        ret = change.getElement();
                    }
                } else if (changeKind == 2) {
                    if (change.getChangeKind() == 1 && this.isSameICElement(element, change.getElement())) {
                        ret = change.getElement();
                    }
                } else if (changeKind == 4 && change.getChangeKind() == 4 && this.isSameICElement(element, change.getElement())) {
                    ret = change.getElement();
                }
            }
            ++i;
        }
        return ret;
    }

    private boolean isSameICElement(ICElement e1, ICElement e2) {
        boolean ret = false;
        if (e1.getElementName().equals(e2.getElementName()) && e1.getElementType() == e2.getElementType() && e1.getParent().getElementName().equals(e2.getParent().getElementName())) {
            ret = true;
        }
        return ret;
    }

    private boolean isExist(NamedElement parent, final String childName) {
        Functions.Function1<NamedElement, Boolean> _function = new Functions.Function1<NamedElement, Boolean>(){

            public Boolean apply(NamedElement it) {
                return it.getName().equals(childName);
            }
        };
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)parent.getOwnedElements(), NamedElement.class), (Functions.Function1)_function));
        return !_isEmpty;
    }

    private Object addToModel(CppChangeObject change) {
        try {
            ICElement _parent_2;
            EObject _xifexpression;
            EObject _switchResult = null;
            ICElement _switchValue = change.newElement;
            boolean _matched = false;
            if (change.newElement instanceof IField) {
                ICElement _parent_1;
                IStructure parentStructure;
                Type classifier;
                _matched = true;
                IField field = (IField)change.newElement;
                ICElement _parent = field.getParent();
                if (_parent instanceof IStructure && (classifier = this.getClassifier(this.getCorrespondingModel((parentStructure = (IStructure)(_parent_1 = field.getParent())).getTranslationUnit()), (ICElement)parentStructure, parentStructure.getElementName(), parentStructure.getTranslationUnit())) != null) {
                    boolean _not;
                    boolean _isExist = this.isExist((NamedElement)classifier, field.getElementName());
                    boolean bl = _not = !_isExist;
                    if (_not) {
                        this.createProperty(field, (Classifier)classifier);
                    }
                }
            }
            if (!_matched && change.newElement instanceof IMethodDeclaration) {
                _matched = true;
                EObject _xblockexpression = null;
                final IMethodDeclaration method = (IMethodDeclaration)change.newElement;
                _xifexpression = null;
                _parent_2 = method.getParent();
                if (_parent_2 instanceof IStructure) {
                    ICElement _parent_3 = method.getParent();
                    IStructure parentStructure_1 = (IStructure)_parent_3;
                    Type classifier_1 = this.getClassifier(this.getCorrespondingModel(parentStructure_1.getTranslationUnit()), (ICElement)parentStructure_1, parentStructure_1.getElementName(), parentStructure_1.getTranslationUnit());
                    if (classifier_1 != null) {
                        Functions.Function1<Operation, Boolean> _function_1;
                        Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                            public Boolean apply(Operation it) {
                                return it.getName().equals(method.getElementName());
                            }
                        };
                        List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier_1.getOwnedElements(), Operation.class), (Functions.Function1)_function));
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)(_function_1 = new Functions.Function1<Operation, Boolean>(){

                            public Boolean apply(Operation it) {
                                return ReverseCpp2Uml.this.isSameSignature(it, method);
                            }
                        })));
                        if (_isEmpty) {
                            this.createMethod(method, (Class)classifier_1);
                        }
                    }
                } else {
                    EObject _xifexpression_1 = null;
                    ICElement _parent_4 = method.getParent();
                    if (_parent_4 instanceof ITranslationUnit) {
                        _xifexpression_1 = null;
                    }
                    _xifexpression = _xifexpression_1;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            if (!_matched) {
                if (change.newElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.newElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.newElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    EObject _xblockexpression_1 = null;
                    IDeclaration declaration = (IDeclaration)change.newElement;
                    _xifexpression = null;
                    _parent_2 = declaration.getParent();
                    if (_parent_2 instanceof IStructure) {
                        EObject _xblockexpression_2 = null;
                        ICElement _parent_3 = declaration.getParent();
                        IStructure parentStructure_1 = (IStructure)_parent_3;
                        Type parentClassifier = this.getClassifier(this.getCorrespondingModel(parentStructure_1.getTranslationUnit()), (ICElement)parentStructure_1, parentStructure_1.getElementName(), parentStructure_1.getTranslationUnit());
                        _xifexpression = _xblockexpression_2 = this.createOrgetClassifier((PackageableElement)parentClassifier, (ICElement)declaration, true);
                    } else {
                        EObject _xblockexpression_3 = null;
                        Package containerPackage = this.getContainerPackage(declaration.getTranslationUnit());
                        _xifexpression = _xblockexpression_3 = this.createOrgetClassifier((PackageableElement)containerPackage, (ICElement)declaration, true);
                    }
                    _switchResult = _xblockexpression_1 = _xifexpression;
                }
            }
            if (!_matched && change.newElement instanceof IEnumerator) {
                _matched = true;
                EnumerationLiteral _xblockexpression_2 = null;
                IEnumerator enumerator = (IEnumerator)change.newElement;
                IPath _path = enumerator.getPath();
                IEnumeration cppEnumeration = (IEnumeration)_path;
                Type enumeration = this.getClassifier(this.getCorrespondingModel(cppEnumeration.getTranslationUnit()), (ICElement)cppEnumeration, cppEnumeration.getElementName(), cppEnumeration.getTranslationUnit());
                EnumerationLiteral _xifexpression2 = null;
                if (enumeration instanceof Enumeration) {
                    _xifexpression2 = ((Enumeration)enumeration).createOwnedLiteral(enumerator.getElementName());
                }
                _xblockexpression_2 = _xifexpression2;
                _switchResult = _xblockexpression_2;
            }
            if (!_matched && change.newElement instanceof ITranslationUnit) {
                _matched = true;
                EObject _xblockexpression_3 = null;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                _switchResult = _xblockexpression_3 = this.getOrCreateClassifier(this.getCorrespondingModel(itu), (IParent)itu);
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private List<Type> updateToModel(final CppChangeObject change) {
        try {
            List<Type> _switchResult = null;
            ICElement _switchValue = change.newElement;
            boolean _matched = false;
            if (change.oldElement instanceof IField) {
                boolean _isExist;
                ICElement _parent_1;
                IStructure parentStructure;
                Type classifier;
                _matched = true;
                IField field = (IField)change.newElement;
                ICElement _parent = field.getParent();
                if (_parent instanceof IStructure && (classifier = this.getClassifier(this.getCorrespondingModel((parentStructure = (IStructure)(_parent_1 = field.getParent())).getTranslationUnit()), (ICElement)parentStructure, parentStructure.getElementName(), parentStructure.getTranslationUnit())) != null && (_isExist = this.isExist((NamedElement)classifier, change.oldElement.getElementName()))) {
                    Functions.Function1<Property, Boolean> _function = new Functions.Function1<Property, Boolean>(){

                        public Boolean apply(Property it) {
                            return it.getName().equals(change.oldElement.getElementName());
                        }
                    };
                    Property prop = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class), (Functions.Function1)_function));
                    if (prop != null) {
                        this.updateProperty((IField)change.newElement, prop);
                    }
                }
            }
            if (!_matched && change.oldElement instanceof IMethodDeclaration) {
                _matched = true;
                IMethodDeclaration method = (IMethodDeclaration)change.newElement;
                ICElement _parent_2 = method.getParent();
                if (_parent_2 instanceof IStructure) {
                    boolean _isExist_1;
                    ICElement _parent_3 = method.getParent();
                    IStructure parentStructure_1 = (IStructure)_parent_3;
                    Type classifier_1 = this.getClassifier(this.getCorrespondingModel(parentStructure_1.getTranslationUnit()), (ICElement)parentStructure_1, parentStructure_1.getElementName(), parentStructure_1.getTranslationUnit());
                    if (classifier_1 != null && (_isExist_1 = this.isExist((NamedElement)classifier_1, change.oldElement.getElementName()))) {
                        IMethodDeclaration oldMethod;
                        Functions.Function1<Operation, Boolean> _function_2;
                        Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                            public Boolean apply(Operation it) {
                                return it.getName().equals(change.oldElement.getElementName());
                            }
                        };
                        List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier_1.getOwnedElements(), Operation.class), (Functions.Function1)_function_1));
                        Operation op = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)(_function_2 = new Functions.Function1<Operation, Boolean>(oldMethod = (IMethodDeclaration)change.oldElement){
                            private final /* synthetic */ IMethodDeclaration val$oldMethod;
                            {
                                this.val$oldMethod = iMethodDeclaration;
                            }

                            public Boolean apply(Operation it) {
                                return ReverseCpp2Uml.this.isSameSignature(it, this.val$oldMethod);
                            }
                        })));
                        if (op != null) {
                            this.updateMethod((Class)classifier_1, op, (IMethodDeclaration)change.newElement);
                        }
                    }
                } else {
                    ICElement _parent_4 = method.getParent();
                    if (_parent_4 instanceof ITranslationUnit) {
                        ICElement _parent_5 = method.getParent();
                        this.reverseSource((ITranslationUnit)_parent_5);
                    }
                }
            }
            if (!_matched) {
                IDeclaration declaration;
                Type umlClassifier;
                if (change.oldElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched && (umlClassifier = this.getClassifier(this.getCorrespondingModel((declaration = (IDeclaration)change.newElement).getTranslationUnit()), (ICElement)((IDeclaration)change.oldElement), change.oldElement.getElementName(), declaration.getTranslationUnit())) != null) {
                    umlClassifier.setName(declaration.getElementName());
                }
            }
            if (!_matched && change.oldElement instanceof IEnumerator) {
                _matched = true;
                IEnumerator cppEnumerator = (IEnumerator)change.newElement;
                ICElement _parent_6 = cppEnumerator.getParent();
                IEnumeration cppEnumeration = (IEnumeration)_parent_6;
                Type enumeration = this.getClassifier(this.getCorrespondingModel(cppEnumeration.getTranslationUnit()), (ICElement)cppEnumeration, cppEnumeration.getElementName(), cppEnumeration.getTranslationUnit());
                if (enumeration != null && enumeration instanceof Enumeration) {
                    Functions.Function1<EnumerationLiteral, Boolean> _function_3 = new Functions.Function1<EnumerationLiteral, Boolean>(){

                        public Boolean apply(EnumerationLiteral it) {
                            String _name = it.getName();
                            String _elementName = change.oldElement.getElementName();
                            return Objects.equal((Object)_name, (Object)_elementName);
                        }
                    };
                    EnumerationLiteral enumerator = (EnumerationLiteral)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Enumeration)enumeration).getOwnedLiterals(), EnumerationLiteral.class), (Functions.Function1)_function_3));
                    if (enumerator != null) {
                        enumerator.setName(cppEnumerator.getElementName());
                    }
                }
            }
            if (!_matched && change.oldElement instanceof ITranslationUnit) {
                _matched = true;
                List<Type> _xblockexpression = null;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                List<Type> _xifexpression = null;
                boolean _isSourceUnit = itu.isSourceUnit();
                if (_isSourceUnit) {
                    this.reverseSource(itu);
                } else {
                    List<Type> _xifexpression_1 = null;
                    boolean _isHeaderUnit = itu.isHeaderUnit();
                    if (_isHeaderUnit) {
                        _xifexpression_1 = this.reverseHeader(itu);
                    }
                    _xifexpression = _xifexpression_1;
                }
                _switchResult = _xblockexpression = _xifexpression;
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object removeFromModel(final CppChangeObject change) {
        try {
            Object _function;
            boolean _isExist;
            boolean _xifexpression_2;
            boolean _xifexpression_1;
            Type classifier;
            IStructure parentStructure;
            ICElement _parent_1;
            ICElement _parent;
            boolean _xifexpression;
            Object _switchResult = null;
            ICElement _switchValue = change.oldElement;
            boolean _matched = false;
            if (change.oldElement instanceof IField) {
                _matched = true;
                boolean _xblockexpression = false;
                IField field = (IField)change.oldElement;
                _xifexpression = false;
                _parent = field.getParent();
                if (_parent instanceof IStructure) {
                    boolean _xblockexpression_1 = false;
                    _parent_1 = field.getParent();
                    parentStructure = (IStructure)_parent_1;
                    classifier = this.getClassifier(this.getCorrespondingModel(parentStructure.getTranslationUnit()), (ICElement)parentStructure, parentStructure.getElementName(), parentStructure.getTranslationUnit());
                    _xifexpression_1 = false;
                    if (classifier != null) {
                        _xifexpression_2 = false;
                        _isExist = this.isExist((NamedElement)classifier, change.oldElement.getElementName());
                        if (_isExist) {
                            boolean _xblockexpression_2 = false;
                            _function = new Functions.Function1<Property, Boolean>(){

                                public Boolean apply(Property it) {
                                    return it.getName().equals(change.oldElement.getElementName());
                                }
                            };
                            Property prop = (Property)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Property.class), (Functions.Function1)_function));
                            boolean _xifexpression_3 = false;
                            if (prop != null) {
                                boolean _xifexpression_4 = false;
                                if (classifier instanceof Class) {
                                    EList _ownedAttributes = ((Class)classifier).getOwnedAttributes();
                                    _xifexpression_4 = _ownedAttributes.remove((Object)prop);
                                } else {
                                    boolean _xifexpression_5 = false;
                                    if (classifier instanceof DataType) {
                                        EList _ownedAttributes_1 = ((DataType)classifier).getOwnedAttributes();
                                        _xifexpression_5 = _ownedAttributes_1.remove((Object)prop);
                                    }
                                    _xifexpression_4 = _xifexpression_5;
                                }
                                _xifexpression_3 = _xifexpression_4;
                            }
                            _xifexpression_2 = _xblockexpression_2 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_1 = _xifexpression_1;
                }
                _xblockexpression = _xifexpression;
                _switchResult = _xblockexpression;
            }
            if (!_matched && change.oldElement instanceof IMethodDeclaration) {
                _matched = true;
                boolean _xblockexpression_1 = false;
                final IMethodDeclaration method = (IMethodDeclaration)change.oldElement;
                _xifexpression = false;
                _parent = method.getParent();
                if (_parent instanceof IStructure) {
                    boolean _xblockexpression_2 = false;
                    _parent_1 = method.getParent();
                    parentStructure = (IStructure)_parent_1;
                    classifier = this.getClassifier(this.getCorrespondingModel(parentStructure.getTranslationUnit()), (ICElement)parentStructure, parentStructure.getElementName(), parentStructure.getTranslationUnit());
                    _xifexpression_1 = false;
                    if (classifier != null) {
                        _xifexpression_2 = false;
                        _isExist = this.isExist((NamedElement)classifier, change.oldElement.getElementName());
                        if (_isExist) {
                            boolean _xblockexpression_3 = false;
                            _function = new Functions.Function1<Operation, Boolean>(){

                                public Boolean apply(Operation it) {
                                    return it.getName().equals(method.getElementName());
                                }
                            };
                            List samenames = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)classifier.getOwnedElements(), Operation.class), (Functions.Function1)_function));
                            Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                                public Boolean apply(Operation it) {
                                    return ReverseCpp2Uml.this.isSameSignature(it, method);
                                }
                            };
                            Operation op = (Operation)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)samenames, (Functions.Function1)_function_1));
                            boolean _xifexpression_3 = false;
                            if (op != null) {
                                boolean _xifexpression_4 = false;
                                if (classifier instanceof Class) {
                                    EList _ownedOperations = ((Class)classifier).getOwnedOperations();
                                    _xifexpression_4 = _ownedOperations.remove((Object)op);
                                }
                                _xifexpression_3 = _xifexpression_4;
                            }
                            _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                        }
                        _xifexpression_1 = _xifexpression_2;
                    }
                    _xifexpression = _xblockexpression_2 = _xifexpression_1;
                }
                _xblockexpression_1 = _xifexpression;
                _switchResult = _xblockexpression_1;
            }
            if (!_matched) {
                if (change.oldElement instanceof IStructure) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof IEnumeration) {
                    _matched = true;
                }
                if (!_matched && change.oldElement instanceof ITypeDef) {
                    _matched = true;
                }
                if (_matched) {
                    boolean _xblockexpression_2 = false;
                    final IDeclaration declaration = (IDeclaration)change.oldElement;
                    _xifexpression = false;
                    if (change.parent instanceof IStructure) {
                        boolean _xblockexpression_3 = false;
                        IStructure parentStructure2 = (IStructure)change.parent;
                        Type parentClassifier = this.getClassifier(this.getCorrespondingModel(parentStructure2.getTranslationUnit()), (ICElement)parentStructure2, parentStructure2.getElementName(), parentStructure2.getTranslationUnit());
                        Functions.Function1<Type, Boolean> _function2 = new Functions.Function1<Type, Boolean>(){

                            public Boolean apply(Type it) {
                                String _name = it.getName();
                                String _elementName = declaration.getElementName();
                                return Objects.equal((Object)_name, (Object)_elementName);
                            }
                        };
                        Type childClassifier = (Type)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)parentClassifier.getOwnedElements(), Type.class), (Functions.Function1)_function2));
                        _xifexpression_1 = false;
                        if (childClassifier != null && parentClassifier instanceof Class) {
                            EList _nestedClassifiers = ((Class)parentClassifier).getNestedClassifiers();
                            _xifexpression_1 = _nestedClassifiers.remove((Object)((Classifier)childClassifier));
                        }
                        _xifexpression = _xblockexpression_3 = _xifexpression_1;
                    } else {
                        boolean _xblockexpression_4 = false;
                        Package containerPackage = this.getContainerPackage(declaration.getTranslationUnit());
                        Functions.Function1<Type, Boolean> _function3 = new Functions.Function1<Type, Boolean>(){

                            public Boolean apply(Type it) {
                                String _name = it.getName();
                                String _elementName = declaration.getElementName();
                                return Objects.equal((Object)_name, (Object)_elementName);
                            }
                        };
                        Type childClassifier = (Type)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)containerPackage.getOwnedElements(), Type.class), (Functions.Function1)_function3));
                        EList _ownedTypes = containerPackage.getOwnedTypes();
                        _xifexpression = _xblockexpression_4 = _ownedTypes.remove((Object)childClassifier);
                    }
                    _xblockexpression_2 = _xifexpression;
                    _switchResult = _xblockexpression_2;
                }
            }
            if (!_matched && change.oldElement instanceof IEnumerator) {
                _matched = true;
                boolean _xblockexpression_3 = false;
                IEnumerator cppEnumerator = (IEnumerator)change.oldElement;
                IPath _path = cppEnumerator.getPath();
                IEnumeration cppEnumeration = (IEnumeration)_path;
                Type enumeration = this.getClassifier(this.getCorrespondingModel(cppEnumeration.getTranslationUnit()), (ICElement)cppEnumeration, cppEnumeration.getElementName(), cppEnumeration.getTranslationUnit());
                boolean _xifexpression2 = false;
                if (enumeration != null && enumeration instanceof Enumeration) {
                    boolean _xblockexpression_4 = false;
                    EnumerationLiteral enumerator = ((Enumeration)enumeration).getOwnedLiteral(change.oldElement.getElementName());
                    _xifexpression_1 = false;
                    if (enumerator != null) {
                        EList _ownedLiterals = ((Enumeration)enumeration).getOwnedLiterals();
                        _xifexpression_1 = _ownedLiterals.remove((Object)enumerator);
                    }
                    _xifexpression2 = _xblockexpression_4 = _xifexpression_1;
                }
                _xblockexpression_3 = _xifexpression2;
                _switchResult = _xblockexpression_3;
            }
            if (!_matched && change.oldElement instanceof ITranslationUnit) {
                _matched = true;
                List<Type> _xblockexpression_4 = null;
                ITranslationUnit itu = (ITranslationUnit)change.newElement;
                _xblockexpression_4 = this.getOrCreateClassifier(this.getCorrespondingModel(itu), (IParent)itu);
                _switchResult = _xblockexpression_4;
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Object compareUml2Cpp(Element umlElement, ICElement icElement) {
        Object _xifexpression = null;
        if (umlElement instanceof Package && icElement instanceof ICContainer) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    private Object comparePackage(Package pack, ICContainer container) {
        try {
            boolean _notEquals;
            Object _xblockexpression = null;
            List containerChildren = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)container.getChildren())), ICContainer.class));
            Object _xifexpression = null;
            int _size = pack.getNestedPackages().size();
            int _size_1 = containerChildren.size();
            boolean bl = _notEquals = _size != _size_1;
            if (_notEquals) {
                _xifexpression = null;
            } else {
                Iterator iterator = containerChildren.iterator();
                EList _nestedPackages = pack.getNestedPackages();
                for (Package child : _nestedPackages) {
                    this.syncName((NamedElement)child, (ICElement)iterator.next());
                }
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void syncName(NamedElement umlElement, ICElement icElement) {
        boolean _not;
        boolean _equals = icElement.getElementName().equals(umlElement.getName());
        boolean bl = _not = !_equals;
        if (_not) {
            umlElement.setName(icElement.getElementName());
        }
    }

    private void comparePackageableElement(PackageableElement umlElement, IParent parent) {
        int _size_1;
        if (!(umlElement instanceof Package) || !(umlElement instanceof Classifier)) {
            return;
        }
        Iterable typeChildren = Iterables.filter((Iterable)umlElement.getOwnedElements(), Type.class);
        List<ICElement> structureChildren = this.reverse_utils.getAllIStructures(parent, false, false, this.m_project);
        int _size = IterableExtensions.size((Iterable)typeChildren);
        boolean _notEquals = _size != (_size_1 = structureChildren.size());
    }

    private Package getContainerPackage(ITranslationUnit unit) {
        Model _xblockexpression = null;
        Model model = this.getCorrespondingModel(unit);
        String unitPath = unit.getFile().getProjectRelativePath().toString();
        if (unitPath == null || unitPath.equals("")) {
            unitPath = unit.getLocation().toString();
        }
        String _name = model.getName();
        String _plus = "/" + _name;
        String _plus_1 = String.valueOf(_plus) + "/";
        String[] arrayNames = ((String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)unitPath.split(_plus_1))))).split("/");
        final ArrayList names = new ArrayList();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String it) {
                names.add(it);
            }
        };
        ((List)Conversions.doWrapArray((Object)arrayNames)).forEach(_function);
        Model parentPack = model;
        for (String name : names) {
            boolean _tripleEquals;
            boolean _not;
            boolean _equals = name.equals(unit.getElementName());
            boolean bl = _not = !_equals;
            if (!_not) continue;
            Package _nestedPackage = parentPack.getNestedPackage(name);
            boolean bl2 = _tripleEquals = _nestedPackage == null;
            if (_tripleEquals) {
                parentPack.createNestedPackage(name);
            }
            parentPack = parentPack.getNestedPackage(name);
        }
        _xblockexpression = parentPack;
        return _xblockexpression;
    }

    private Type getClassifier(Model model, ICElement declaration, String name, ITranslationUnit unit) throws Exception {
        if (this.map.get(declaration) != null && this.map.get(declaration) instanceof Type) {
            EObject _get = this.map.get(declaration);
            return (Type)_get;
        }
        Type ret = null;
        Package parentPack = this.getContainerPackage(unit);
        Classifier parentClass = null;
        ICElement _parent = declaration.getParent();
        if (_parent instanceof IStructure) {
            Type _uMLType = this.getUMLType(declaration.getParent().getElementName(), unit, this.getContextNamespaces(declaration));
            parentClass = (Classifier)_uMLType;
            EObject _createOrgetClassifier = this.createOrgetClassifier((PackageableElement)parentClass, declaration, false);
            ret = (Type)_createOrgetClassifier;
        } else {
            EObject _createOrgetClassifier_1 = this.createOrgetClassifier((PackageableElement)parentPack, declaration, false);
            ret = (Type)_createOrgetClassifier_1;
        }
        return ret;
    }

    private EObject createOrgetClassifier(PackageableElement packagebleElement, final ICElement ideclaration, boolean createContent) {
        Type existing;
        PackageableElement packageble;
        EObject _xblockexpression;
        block39: {
            block38: {
                _xblockexpression = null;
                packageble = packagebleElement;
                if (ideclaration.getElementType() == 65 || ideclaration.getElementType() == 83 || ideclaration.getElementType() == 63 || ideclaration.getElementType() == 67 || ideclaration.getElementType() == 69 || ideclaration instanceof ITypeDef) break block38;
                return null;
            }
            existing = null;
            if (packageble instanceof Package || packageble instanceof Class) break block39;
            if (packageble instanceof DataType && ideclaration instanceof ITypeDef) {
                packageble = packagebleElement.getNearestPackage();
                break block39;
            }
            return null;
        }
        try {
            boolean _equals_1;
            if (this.map.get(ideclaration) != null && this.map.get(ideclaration) instanceof Type) {
                EObject _get = this.map.get(ideclaration);
                existing = (Type)_get;
            }
            if (existing == null) {
                boolean _not;
                Functions.Function1<Type, Boolean> _function = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        return it.getName().equals(ideclaration.getElementName());
                    }
                };
                Iterable namedElements = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)packageble.getOwnedElements(), Type.class), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)namedElements);
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    existing = (NamedElement)IterableExtensions.head((Iterable)namedElements);
                }
            }
            if (existing != null) {
                return existing;
            }
            String _elementName = ideclaration.getElementName();
            String _plus = "Creating type " + _elementName;
            this.m_monitor.subTask(_plus);
            if (ideclaration instanceof ITypeDef) {
                if (existing != null) {
                    return existing;
                }
                final ITypeDef typedef = (ITypeDef)ideclaration;
                PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
                Procedures.Procedure1<PrimitiveType> _function_1 = new Procedures.Procedure1<PrimitiveType>(){

                    public void apply(PrimitiveType it) {
                        it.setName(typedef.getElementName());
                    }
                };
                PrimitiveType prinmitiveType = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType, (Procedures.Procedure1)_function_1);
                if (packageble instanceof Package) {
                    EList _ownedTypes = ((Package)packageble).getOwnedTypes();
                    _ownedTypes.add((Object)prinmitiveType);
                } else {
                    EList _nestedClassifiers = ((Class)packageble).getNestedClassifiers();
                    _nestedClassifiers.add((Object)prinmitiveType);
                }
                StereotypeUtil.apply((Element)prinmitiveType, Typedef.class);
                if (Objects.equal((Object)typedef.getTypeName(), (Object)"struct") || Objects.equal((Object)typedef.getTypeName(), (Object)"class") || Objects.equal((Object)typedef.getTypeName(), (Object)"enum")) {
                    ICElement _parent_1;
                    ICElement childStruct;
                    ICElement _parent = typedef.getParent();
                    int pos = ((List)Conversions.doWrapArray((Object)((IParent)_parent).getChildren())).indexOf(typedef);
                    if (pos > 0 && ((childStruct = ((IParent)(_parent_1 = typedef.getParent())).getChildren()[pos - 1]) instanceof IStructure || childStruct instanceof IEnumeration) && Objects.equal((Object)childStruct.getElementName(), (Object)"")) {
                        String source = ((ISourceReference)childStruct).getSource();
                        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)prinmitiveType, Typedef.class);
                        String _replace = source.replace("typedef", "");
                        String _plus_1 = String.valueOf(_replace) + " typeName";
                        _stereotypeApplication.setDefinition(_plus_1);
                    }
                } else {
                    IASTNode typedefNode = this.findEnclosingNode((ISourceReference)typedef);
                    String rawSignature = typedefNode.getRawSignature().replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
                    Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
                    Matcher matcher = pattern.matcher(rawSignature);
                    boolean _find = matcher.find();
                    if (_find) {
                        String typeName = rawSignature.replaceFirst(Pattern.quote(typedef.getElementName()), "typeName");
                        Typedef _stereotypeApplication_1 = (Typedef)UMLUtil.getStereotypeApplication((Element)prinmitiveType, Typedef.class);
                        _stereotypeApplication_1.setDefinition(typeName);
                    } else {
                        Typedef _stereotypeApplication_2 = (Typedef)UMLUtil.getStereotypeApplication((Element)prinmitiveType, Typedef.class);
                        _stereotypeApplication_2.setDefinition(typedef.getTypeName());
                    }
                }
                this.map.put(ideclaration, (EObject)prinmitiveType);
                return prinmitiveType;
            }
            boolean structIsClassLike = false;
            if (ideclaration.getElementType() == 67 || ideclaration.getElementType() == 69) {
                IStructure iStructure = (IStructure)ideclaration;
                int i = 0;
                while (!structIsClassLike && i < ((List)Conversions.doWrapArray((Object)iStructure.getChildren())).size()) {
                    ICElement child = iStructure.getChildren()[i];
                    if (child instanceof IMethodDeclaration || child instanceof IStructure) {
                        structIsClassLike = true;
                    }
                    ++i;
                }
            }
            EObject _xifexpression = null;
            if (ideclaration.getElementType() == 65 || ideclaration.getElementType() == 83 || structIsClassLike) {
                boolean _equals;
                final IStructure iStructure_1 = (IStructure)ideclaration;
                Class temp = null;
                if (existing != null) {
                    temp = (Class)existing;
                } else if (packageble instanceof Package) {
                    temp = ((Package)packageble).createOwnedClass(iStructure_1.getElementName(), iStructure_1.isAbstract());
                } else {
                    Classifier _createNestedClassifier = ((Class)packageble).createNestedClassifier(iStructure_1.getElementName(), UMLPackage.Literals.CLASS);
                    temp = (Class)_createNestedClassifier;
                    temp.setIsAbstract(iStructure_1.isAbstract());
                }
                final Class classifier = temp;
                Consumer<ICElement> _function_2 = new Consumer<ICElement>(){

                    @Override
                    public void accept(ICElement it) {
                        boolean _equals;
                        int _elementType = it.getElementType();
                        boolean bl = _equals = _elementType == 72;
                        if (_equals) {
                            ReverseCpp2Uml.this.createProperty((IField)it, (Classifier)classifier);
                        } else if (it instanceof IMethodDeclaration) {
                            ReverseCpp2Uml.this.createMethod((IMethodDeclaration)it, classifier);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)iStructure_1.getChildren())).forEach(_function_2);
                Functions.Function1<String, Type> _function_3 = new Functions.Function1<String, Type>(){

                    public Type apply(String it) {
                        return ReverseCpp2Uml.this.getUMLType(it, iStructure_1.getTranslationUnit(), ReverseCpp2Uml.this.getContextNamespaces((ICElement)iStructure_1));
                    }
                };
                List superTypes = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)iStructure_1.getSuperClassesNames())), (Functions.Function1)_function_3);
                Consumer<Type> _function_4 = new Consumer<Type>(){

                    @Override
                    public void accept(Type it) {
                        if (it != null && it instanceof Classifier) {
                            ASTAccessVisibility visibility;
                            Generalization generalization = classifier.createGeneralization((Classifier)it);
                            Visibility visibilitySt = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                            if (visibilitySt == null) {
                                StereotypeUtil.apply((Element)generalization, Visibility.class);
                                visibilitySt = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                            }
                            if ((visibility = iStructure_1.getSuperClassAccess(it.getName())) != null) {
                                visibilitySt.setValue(visibility.name().toLowerCase());
                            }
                        }
                    }
                };
                superTypes.forEach(_function_4);
                this.map.put(ideclaration, (EObject)classifier);
                int _elementType = iStructure_1.getElementType();
                boolean bl = _equals = _elementType == 83;
                if (_equals) {
                    IStructureTemplate istructureTemplate = (IStructureTemplate)iStructure_1;
                    StereotypeUtil.apply((Element)classifier, Template.class);
                    Template _stereotypeApplication_3 = (Template)UMLUtil.getStereotypeApplication((Element)classifier, Template.class);
                    _stereotypeApplication_3.setDeclaration(istructureTemplate.getTemplateSignature());
                }
                return classifier;
            }
            EObject _xifexpression_1 = null;
            int _elementType_1 = ideclaration.getElementType();
            boolean bl = _equals_1 = _elementType_1 == 63;
            if (_equals_1) {
                EObject _xblockexpression_1 = null;
                Enumeration temp_1 = null;
                IEnumeration iStructure_2 = (IEnumeration)ideclaration;
                if (existing != null) {
                    temp_1 = (Enumeration)existing;
                } else if (packageble instanceof Package) {
                    temp_1 = ((Package)packageble).createOwnedEnumeration(iStructure_2.getElementName());
                } else {
                    Classifier _createNestedClassifier_1 = ((Class)packageble).createNestedClassifier(iStructure_2.getElementName(), UMLPackage.Literals.ENUMERATION);
                    temp_1 = (Enumeration)_createNestedClassifier_1;
                }
                final Enumeration enumeration = temp_1;
                Consumer<ICElement> _function_5 = new Consumer<ICElement>(){

                    @Override
                    public void accept(ICElement it) {
                        if (it instanceof IEnumerator) {
                            boolean _tripleNotEquals;
                            EnumerationLiteral literal = enumeration.createOwnedLiteral(((IEnumerator)it).getElementName());
                            String _constantExpression = ((IEnumerator)it).getConstantExpression();
                            boolean bl = _tripleNotEquals = _constantExpression != null;
                            if (_tripleNotEquals) {
                                ValueSpecification valueSpecification;
                                EList _ownedElements = literal.getOwnedElements();
                                for (Element element : _ownedElements) {
                                    boolean _equals;
                                    if (!(element instanceof ValueSpecification) || !(_equals = ((ValueSpecification)element).getName().equals("defaultValue"))) continue;
                                    ((ValueSpecification)element).destroy();
                                }
                                if (((IEnumerator)it).getConstantExpression() != null && !((IEnumerator)it).getConstantExpression().equals("") && (valueSpecification = literal.createSpecification("defaultValue", (Type)literal.getEnumeration(), UMLPackage.Literals.OPAQUE_EXPRESSION)) instanceof OpaqueExpression) {
                                    OpaqueExpression opaqueExpression = (OpaqueExpression)valueSpecification;
                                    opaqueExpression.getLanguages().add((Object)Cpp_LangID);
                                    opaqueExpression.getBodies().add((Object)((IEnumerator)it).getConstantExpression());
                                }
                            }
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)iStructure_2.getChildren())).forEach(_function_5);
                _xifexpression_1 = _xblockexpression_1 = this.map.put(ideclaration, (EObject)enumeration);
            } else {
                EObject _xifexpression_2 = null;
                if (!(structIsClassLike || ideclaration.getElementType() != 67 && ideclaration.getElementType() != 69)) {
                    EObject _xblockexpression_2 = null;
                    DataType temp_1 = null;
                    final IStructure iStructure_2 = (IStructure)ideclaration;
                    if (existing != null) {
                        temp_1 = (DataType)existing;
                    } else if (packageble instanceof Package) {
                        Type _createOwnedType = ((Package)packageble).createOwnedType(iStructure_2.getElementName(), UMLPackage.Literals.DATA_TYPE);
                        temp_1 = (DataType)_createOwnedType;
                    } else {
                        Classifier _createNestedClassifier_1 = ((Class)packageble).createNestedClassifier(iStructure_2.getElementName(), UMLPackage.Literals.DATA_TYPE);
                        temp_1 = (DataType)_createNestedClassifier_1;
                    }
                    final DataType dataType = temp_1;
                    Consumer<ICElement> _function_5 = new Consumer<ICElement>(){

                        @Override
                        public void accept(ICElement it) {
                            boolean _equals;
                            int _elementType = it.getElementType();
                            boolean bl = _equals = _elementType == 72;
                            if (_equals) {
                                ReverseCpp2Uml.this.createProperty((IField)it, (Classifier)dataType);
                            }
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)iStructure_2.getChildren())).forEach(_function_5);
                    Functions.Function1<String, Type> _function_6 = new Functions.Function1<String, Type>(){

                        public Type apply(String it) {
                            return ReverseCpp2Uml.this.getUMLType(it, iStructure_2.getTranslationUnit(), ReverseCpp2Uml.this.getContextNamespaces((ICElement)iStructure_2));
                        }
                    };
                    List superTypes_1 = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)iStructure_2.getSuperClassesNames())), (Functions.Function1)_function_6);
                    Consumer<Type> _function_7 = new Consumer<Type>(){

                        @Override
                        public void accept(Type it) {
                            if (it != null && it instanceof Classifier) {
                                ASTAccessVisibility visibility;
                                Generalization generalization = dataType.createGeneralization((Classifier)it);
                                Visibility visibilitySt = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                                if (visibilitySt == null) {
                                    StereotypeUtil.apply((Element)generalization, Visibility.class);
                                    visibilitySt = (Visibility)UMLUtil.getStereotypeApplication((Element)generalization, Visibility.class);
                                }
                                if ((visibility = iStructure_2.getSuperClassAccess(it.getName())) != null) {
                                    visibilitySt.setValue(visibility.name().toLowerCase());
                                }
                            }
                        }
                    };
                    superTypes_1.forEach(_function_7);
                    _xifexpression_2 = _xblockexpression_2 = this.map.put(ideclaration, (EObject)dataType);
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xblockexpression = _xifexpression = _xifexpression_1;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Classifier createOrgetTemplateParameter(NamedElement element, final String parameterTypeName, String keyWord) {
        Classifier ret = null;
        RedefinableTemplateSignature templateSignature = null;
        if (element instanceof Classifier) {
            Classifier classifier = (Classifier)element;
            if (classifier.getOwnedTemplateSignature() == null || !(classifier.getOwnedTemplateSignature() instanceof RedefinableTemplateSignature)) {
                TemplateSignature _createOwnedTemplateSignature = classifier.createOwnedTemplateSignature(UMLPackage.Literals.REDEFINABLE_TEMPLATE_SIGNATURE);
                templateSignature = (RedefinableTemplateSignature)_createOwnedTemplateSignature;
                templateSignature.setName(TEMPLATE_PARAMETER_SIGNATURE_NAME);
            }
            TemplateSignature _ownedTemplateSignature = classifier.getOwnedTemplateSignature();
            templateSignature = (RedefinableTemplateSignature)_ownedTemplateSignature;
        } else if (element instanceof Operation) {
            Operation operation = (Operation)element;
            if (operation.getOwnedTemplateSignature() == null || !(operation.getOwnedTemplateSignature() instanceof TemplateSignature)) {
                TemplateSignature _createOwnedTemplateSignature_1 = operation.createOwnedTemplateSignature(UMLPackage.Literals.TEMPLATE_SIGNATURE);
                templateSignature = _createOwnedTemplateSignature_1;
            }
            TemplateSignature _ownedTemplateSignature_1 = operation.getOwnedTemplateSignature();
            templateSignature = _ownedTemplateSignature_1;
        } else {
            return null;
        }
        Iterable classifierTemplates = Iterables.filter((Iterable)templateSignature.getOwnedParameters(), ClassifierTemplateParameter.class);
        Functions.Function1<ClassifierTemplateParameter, Boolean> _function = new Functions.Function1<ClassifierTemplateParameter, Boolean>(){

            public Boolean apply(ClassifierTemplateParameter it) {
                ParameterableElement _ownedParameteredElement = it.getOwnedParameteredElement();
                return _ownedParameteredElement instanceof Classifier;
            }
        };
        Iterable classifierTemplatesContainClassifier = IterableExtensions.filter((Iterable)classifierTemplates, (Functions.Function1)_function);
        Functions.Function1<ClassifierTemplateParameter, ParameterableElement> _function_1 = new Functions.Function1<ClassifierTemplateParameter, ParameterableElement>(){

            public ParameterableElement apply(ClassifierTemplateParameter it) {
                return it.getOwnedParameteredElement();
            }
        };
        Iterable containedClassifiers = IterableExtensions.map((Iterable)classifierTemplatesContainClassifier, (Functions.Function1)_function_1);
        Functions.Function1<Classifier, Boolean> _function_2 = new Functions.Function1<Classifier, Boolean>(){

            public Boolean apply(Classifier it) {
                return it.getName().equals(parameterTypeName);
            }
        };
        ret = (Classifier)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)containedClassifiers, Classifier.class), (Functions.Function1)_function_2));
        if (ret == null) {
            TemplateParameter _createOwnedParameter = templateSignature.createOwnedParameter(UMLPackage.Literals.CLASSIFIER_TEMPLATE_PARAMETER);
            ClassifierTemplateParameter classifierTemplate = (ClassifierTemplateParameter)_createOwnedParameter;
            ParameterableElement _createOwnedParameteredElement = classifierTemplate.createOwnedParameteredElement(UMLPackage.Literals.CLASS);
            ret = (Classifier)_createOwnedParameteredElement;
            ret.setName(parameterTypeName);
            classifierTemplate.addKeyword(keyWord);
        }
        return ret;
    }

    private IASTNodeSelector getSelector(ITranslationUnit unit) {
        try {
            IASTTranslationUnit ast = null;
            if (unit != null) {
                boolean _tripleNotEquals;
                IASTTranslationUnit _get = this.translationUnitToASTTranslationUnitMap.get(unit);
                boolean bl = _tripleNotEquals = _get != null;
                if (_tripleNotEquals) {
                    return this.translationUnitToASTTranslationUnitMap.get(unit).getNodeSelector(null);
                }
                ast = unit.getAST(this.index, 32);
                if (ast != null) {
                    this.translationUnitToASTTranslationUnitMap.put(unit, ast);
                    return ast.getNodeSelector(null);
                }
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void createMethod(IMethodDeclaration method, Class classifier) {
        IASTFunctionDeclarator declarator = this.getDeclarator(method);
        if (declarator != null) {
            Operation op = classifier.createOwnedOperation(method.getElementName(), null, null);
            this.updateMethod(classifier, op, method);
        }
    }

    private IASTNode findEnclosingNode(ISourceReference source) {
        try {
            IASTNode _xblockexpression = null;
            IASTNodeSelector selector = this.getSelector(source.getTranslationUnit());
            ISourceRange range = source.getSourceRange();
            _xblockexpression = selector.findEnclosingNode(range.getStartPos(), range.getLength());
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private IASTFunctionDeclarator getDeclarator(IMethodDeclaration method) {
        IASTFunctionDeclarator declarator = null;
        IASTNode node = this.findEnclosingNode((ISourceReference)method);
        if (node instanceof ICPPASTFunctionDefinition) {
            declarator = ((ICPPASTFunctionDefinition)node).getDeclarator();
        } else if (node instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration declaration = (IASTSimpleDeclaration)node;
            declarator = (IASTFunctionDeclarator)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declaration.getDeclarators())), IASTFunctionDeclarator.class));
        } else if (node instanceof ICPPASTTemplateDeclaration) {
            IASTNode[] chidren;
            ICPPASTTemplateDeclaration declaration_1 = (ICPPASTTemplateDeclaration)node;
            IASTNode[] iASTNodeArray = chidren = declaration_1.getChildren();
            int n = chidren.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode child = iASTNodeArray[n2];
                if (child instanceof IASTSimpleDeclaration) {
                    declarator = (IASTFunctionDeclarator)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IASTSimpleDeclaration)child).getDeclarators())), IASTFunctionDeclarator.class));
                }
                ++n2;
            }
        }
        return declarator;
    }

    private List<String> getKeywords(IMethodDeclaration method) {
        try {
            IASTNode node = this.findEnclosingNode((ISourceReference)method);
            ArrayList<String> keywords = new ArrayList<String>();
            if (node instanceof ICPPASTTemplateDeclaration) {
                IASTNode[] chidren;
                ICPPASTTemplateDeclaration declaration = (ICPPASTTemplateDeclaration)node;
                IASTNode[] iASTNodeArray = chidren = declaration.getChildren();
                int n = chidren.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode child = iASTNodeArray[n2];
                    if (child instanceof ICPPASTTemplateParameter) {
                        IToken token = ((ICPPASTTemplateParameter)child).getSyntax();
                        String keyword = "class";
                        while (token != null) {
                            boolean _equals;
                            int _type = token.getType();
                            boolean bl = _equals = _type == 118;
                            if (_equals) {
                                keyword = "typename";
                            }
                            token = token.getNext();
                        }
                        keywords.add(keyword);
                    }
                    ++n2;
                }
            }
            return keywords;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getBody(IMethodDeclaration method) {
        IASTFunctionDeclarator declarator = null;
        IASTNode node = this.findEnclosingNode((ISourceReference)method);
        String body = null;
        if (node instanceof ICPPASTFunctionDefinition) {
            declarator = ((ICPPASTFunctionDefinition)node).getDeclarator();
            body = BatchReverseFunctionBody.getBody(method.getTranslationUnit(), (IASTFunctionDefinition)((ICPPASTFunctionDefinition)node));
        } else {
            boolean cfr_ignored_0 = node instanceof IASTFunctionDeclarator;
        }
        return body;
    }

    private IASTNode getRootNode(IASTNode fromNode) {
        boolean _tripleEquals;
        IASTNode _parent = fromNode.getParent();
        boolean bl = _tripleEquals = _parent == null;
        if (_tripleEquals) {
            return fromNode;
        }
        return this.getRootNode(fromNode.getParent());
    }

    private String getMemberInit(IMethodDeclaration method) {
        return ReverseCpp2Uml.getMemberInit(this.findEnclosingNode((ISourceReference)method));
    }

    public static String getMemberInit(IASTNode methodNode) {
        ICPPASTConstructorChainInitializer[] inits;
        String ret = "";
        if (methodNode instanceof ICPPASTFunctionDefinition && (inits = ((ICPPASTFunctionDefinition)methodNode).getMemberInitializers()) != null) {
            StringConcatenation _builder = new StringConcatenation();
            boolean _hasElements = false;
            ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = inits;
            int n = inits.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTConstructorChainInitializer i = iCPPASTConstructorChainInitializerArray[n2];
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                IASTName _memberInitializerId = i.getMemberInitializerId();
                _builder.append((Object)_memberInitializerId);
                String _rawSignature = i.getInitializer().getRawSignature();
                _builder.append(_rawSignature);
                ++n2;
            }
            ret = _builder.toString();
        }
        return ret.toString();
    }

    private void updateMethod(Class classifier, Operation op, IMethodDeclaration method) {
        try {
            boolean _equals;
            op.setName(method.getElementName());
            StereotypeUtil.unapply((Element)op, Inline.class);
            StereotypeUtil.unapply((Element)op, Friend.class);
            StereotypeUtil.unapply((Element)op, Virtual.class);
            StereotypeUtil.unapply((Element)op, Volatile.class);
            StereotypeUtil.unapply((Element)op, Create.class);
            StereotypeUtil.unapply((Element)op, Destroy.class);
            StereotypeUtil.unapply((Element)op, Const.class);
            op.getOwnedParameters().clear();
            IASTFunctionDeclarator declarator = this.getDeclarator(method);
            List<String> keywords = this.getKeywords(method);
            String body = this.getBody(method);
            op.setVisibility(this.convertVisibility(method.getVisibility()));
            op.setIsStatic(method.isStatic());
            this.reverse_utils.applyStereotype((Element)op, method.isInline(), ReverseUtils.StereotypeType.INLINE, "");
            this.reverse_utils.applyStereotype((Element)op, method.isFriend(), ReverseUtils.StereotypeType.FRIENDLINE, "");
            this.reverse_utils.applyStereotype((Element)op, method.isVirtual(), ReverseUtils.StereotypeType.VIRTUAL, "");
            this.reverse_utils.applyStereotype((Element)op, method.isVolatile(), ReverseUtils.StereotypeType.VOLATILE, "");
            this.reverse_utils.applyStereotype((Element)op, method.isConst(), ReverseUtils.StereotypeType.CONST, "");
            boolean _isVirtual = method.isVirtual();
            if (_isVirtual) {
                this.reverse_utils.applyStereotype((Element)op, method.isVirtual(), ReverseUtils.StereotypeType.VIRTUAL, "");
                boolean _isPureVirtual = method.isPureVirtual();
                if (_isPureVirtual) {
                    op.setIsAbstract(true);
                }
            }
            this.reverse_utils.applyStereotype((Element)op, method.isConstructor(), ReverseUtils.StereotypeType.CREATE, "");
            this.reverse_utils.applyStereotype((Element)op, method.isDestructor(), ReverseUtils.StereotypeType.DESTROY, "");
            try {
                String signature = method.getSignature();
                Pattern pattern = Pattern.compile("([\\s]*)(\\.\\.\\.)([\\s]*)(\\))");
                Matcher matcher = pattern.matcher(signature);
                this.reverse_utils.applyStereotype((Element)op, matcher.find(), ReverseUtils.StereotypeType.VARIADIC, "");
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            if (method instanceof IMethodTemplateDeclaration) {
                int i = 0;
                while (i < ((List)Conversions.doWrapArray((Object)((IMethodTemplateDeclaration)method).getTemplateParameterTypes())).size()) {
                    this.createOrgetTemplateParameter((NamedElement)op, ((IMethodTemplateDeclaration)method).getTemplateParameterTypes()[i], keywords.get(i));
                    ++i;
                }
            }
            if (!method.isConstructor() && !method.isDestructor()) {
                boolean _tripleNotEquals;
                String _returnType = method.getReturnType();
                boolean bl = _tripleNotEquals = _returnType != null;
                if (_tripleNotEquals) {
                    Type parameterType = this.getParameterTemplateType(op, method, this.getCppTypeName(method.getReturnType()));
                    if (parameterType == null) {
                        parameterType = this.getUMLType(this.getCppTypeName(method.getReturnType()), method.getTranslationUnit(), this.getContextNamespaces((ICElement)method));
                    }
                    Parameter ret = op.createOwnedParameter("ret", parameterType);
                    ret.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                    this.reverse_utils.analyzeDeclaration((IASTDeclarator)declarator, ret.getType(), (TypedElement)ret, this.langID);
                    if (parameterType.getName().equals("void") && ret.getAppliedStereotypes().isEmpty()) {
                        ret.destroy();
                    }
                    this.reverse_utils.applyStereotype((Element)ret, method.getReturnType().contains("const "), ReverseUtils.StereotypeType.CONST, "");
                    this.reverse_utils.applyStereotype((Element)ret, method.getReturnType().contains("volatile "), ReverseUtils.StereotypeType.VOLATILE, "");
                } else {
                    Parameter ret_1 = op.createOwnedParameter("ret", this.getUMLType("void", method.getTranslationUnit(), this.getContextNamespaces((ICElement)method)));
                    ret_1.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                    this.reverse_utils.analyzeDeclaration((IASTDeclarator)declarator, ret_1.getType(), (TypedElement)ret_1, this.langID);
                    boolean _isEmpty = ret_1.getAppliedStereotypes().isEmpty();
                    if (_isEmpty) {
                        ret_1.destroy();
                    }
                }
            }
            boolean noArguments = false;
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class));
            boolean bl = _equals = _size == 1;
            if (_equals) {
                boolean _tripleNotEquals_1;
                IASTParameterDeclaration parameterNode = ((IASTParameterDeclaration[])Conversions.unwrapArray((Object)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class), IASTParameterDeclaration.class))[0];
                IASTDeclSpecifier _declSpecifier = parameterNode.getDeclSpecifier();
                boolean bl2 = _tripleNotEquals_1 = _declSpecifier != null;
                if (_tripleNotEquals_1) {
                    String type = "";
                    IToken tokens = parameterNode.getDeclSpecifier().getSyntax();
                    while (tokens != null) {
                        String _type = type;
                        String _string = tokens.toString();
                        type = String.valueOf(_type) + _string;
                        tokens = tokens.getNext();
                    }
                    boolean _equals_1 = type.trim().equals("void");
                    if (_equals_1) {
                        noArguments = true;
                    }
                }
            }
            if (!noArguments) {
                Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)declarator.getChildren())), IASTParameterDeclaration.class);
                for (IASTParameterDeclaration param : _filter) {
                    this.excludeIncludFromTranslationUnit(param, method, op);
                    Type parameterType_1 = this.getParameterTemplateType(op, method, this.reverse_utils.getCppTypeName(param.getDeclSpecifier()));
                    if (parameterType_1 == null) {
                        parameterType_1 = this.getUMLType(param.getDeclSpecifier(), method.getTranslationUnit(), this.getContextNamespaces((ICElement)method));
                    }
                    Parameter opParam = op.createOwnedParameter(param.getDeclarator().getName().toString(), parameterType_1);
                    this.reverse_utils.applyStereotype((Element)opParam, param.getDeclSpecifier().isConst(), ReverseUtils.StereotypeType.CONST, "");
                    this.reverse_utils.analyzeDeclaration(param.getDeclarator(), opParam.getType(), (TypedElement)opParam, this.langID);
                    this.reverse_utils.applyStereotype((Element)opParam, param.getDeclSpecifier().isVolatile(), ReverseUtils.StereotypeType.VOLATILE, "");
                }
            }
            if (body != null) {
                boolean _equals_4;
                boolean _equals_2;
                boolean _isConstructor = method.isConstructor();
                if (_isConstructor) {
                    boolean _not;
                    String initStr = this.getMemberInit(method);
                    boolean _isEmpty_1 = initStr.isEmpty();
                    boolean bl3 = _not = !_isEmpty_1;
                    if (_not) {
                        StereotypeUtil.apply((Element)op, ConstInit.class);
                        ConstInit _stereotypeApplication = (ConstInit)UMLUtil.getStereotypeApplication((Element)op, ConstInit.class);
                        _stereotypeApplication.setInitialisation(initStr);
                    }
                }
                OpaqueBehavior ob = null;
                int _size_1 = op.getMethods().size();
                boolean bl4 = _equals_2 = _size_1 == 0;
                if (_equals_2) {
                    Behavior _createOwnedBehavior = classifier.createOwnedBehavior(op.getName(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
                    ob = (OpaqueBehavior)_createOwnedBehavior;
                    ob.setSpecification((BehavioralFeature)op);
                    ob.setIsReentrant(false);
                } else {
                    boolean _not_1;
                    Behavior _get = (Behavior)op.getMethods().get(0);
                    ob = (OpaqueBehavior)_get;
                    boolean _equals_3 = ob.getName().equals(op.getName());
                    boolean bl5 = _not_1 = !_equals_3;
                    if (_not_1) {
                        ob.setName(op.getName());
                    }
                }
                int _size_2 = ob.getBodies().size();
                boolean bl6 = _equals_4 = _size_2 == 0;
                if (_equals_4) {
                    ob.getLanguages().add((Object)this.langID);
                    ob.getBodies().add((Object)"");
                }
                int i = 0;
                while (i < ob.getLanguages().size()) {
                    boolean _equals_5 = ((String)ob.getLanguages().get(i)).equals(this.langID);
                    if (_equals_5) {
                        boolean _lessThan;
                        int _size_3 = ob.getBodies().size();
                        boolean bl7 = _lessThan = i < _size_3;
                        if (_lessThan) {
                            ob.getBodies().set(i, (Object)body);
                        }
                    }
                    ++i;
                }
                IASTNode node = this.findEnclosingNode((ISourceReference)method);
                if (node instanceof IASTFunctionDefinition) {
                    ITranslationUnit _translationUnit = method.getTranslationUnit();
                    new DependencyAnalysis(op, (IASTFunctionDefinition)node, _translationUnit, this).analyzeDependencies();
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Type getParameterTemplateType(Operation op, IMethodDeclaration imethod, final String typeName) {
        Classifier ret = null;
        if (imethod instanceof IMethodTemplateDeclaration) {
            boolean _not;
            Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                public Boolean apply(String it) {
                    return it.equals(typeName);
                }
            };
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IMethodTemplateDeclaration)imethod).getTemplateParameterTypes())), (Functions.Function1)_function));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ret = this.createOrgetTemplateParameter((NamedElement)op, typeName, "class");
            }
        }
        return ret;
    }

    private boolean isSimpleAssociation(Property prop) {
        return (StereotypeUtil.isApplied((Element)prop, Ptr.class) || StereotypeUtil.isApplied((Element)prop, Ref.class)) && !StereotypeUtil.isApplied((Element)prop, Array.class);
    }

    private boolean isAggregation(Property prop) {
        return (StereotypeUtil.isApplied((Element)prop, Ptr.class) || StereotypeUtil.isApplied((Element)prop, Ref.class)) && StereotypeUtil.isApplied((Element)prop, Array.class);
    }

    private boolean isComposition(Property prop) {
        return !StereotypeUtil.isApplied((Element)prop, Ptr.class) && !StereotypeUtil.isApplied((Element)prop, Ref.class);
    }

    private void createProperty(final IField field, Classifier classifier) {
        Property _createProperty = UMLFactory.eINSTANCE.createProperty();
        Procedures.Procedure1<Property> _function = new Procedures.Procedure1<Property>(){

            public void apply(Property it) {
                it.setName(field.getElementName());
            }
        };
        Property prop = (Property)ObjectExtensions.operator_doubleArrow((Object)_createProperty, (Procedures.Procedure1)_function);
        if (classifier instanceof DataType) {
            EList _ownedAttributes = ((DataType)classifier).getOwnedAttributes();
            _ownedAttributes.add((Object)prop);
        } else if (classifier instanceof Class) {
            EList _ownedAttributes_1 = ((Class)classifier).getOwnedAttributes();
            _ownedAttributes_1.add((Object)prop);
        }
        this.updateProperty(field, prop);
    }

    private void updateProperty(final IField field, Property prop) {
        try {
            IASTNode node;
            this.reverse_utils.unapplyAllStereotypes((Element)prop);
            Type type = null;
            boolean doNotAnalyzeDeclaration = false;
            try {
                IASTNode fieldNode = this.findEnclosingNode((ISourceReference)field);
                if (fieldNode != null) {
                    String rawSignature = fieldNode.getRawSignature().replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
                    Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
                    Matcher matcher = pattern.matcher(rawSignature);
                    boolean _find = matcher.find();
                    if (_find) {
                        String typeName = rawSignature.replaceFirst(Pattern.quote(field.getElementName()), "typeName").replaceFirst("typedef", "");
                        Package packageable = null;
                        Element _owner = prop.getOwner();
                        if (_owner instanceof Class) {
                            Element _owner_1 = prop.getOwner();
                            packageable = (Class)_owner_1;
                        } else {
                            packageable = prop.getNearestPackage();
                        }
                        final String ownerName = packageable.getName();
                        PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
                        Procedures.Procedure1<PrimitiveType> _function = new Procedures.Procedure1<PrimitiveType>(){

                            public void apply(PrimitiveType it) {
                                String _elementName = field.getElementName();
                                String _plus = String.valueOf(ownerName) + "_" + _elementName;
                                String _plus_1 = String.valueOf(_plus) + "_funcptr";
                                it.setName(_plus_1);
                            }
                        };
                        PrimitiveType primitiveType = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType, (Procedures.Procedure1)_function);
                        if (packageable instanceof Package) {
                            EList _ownedTypes = packageable.getOwnedTypes();
                            _ownedTypes.add((Object)primitiveType);
                        } else {
                            EList _nestedClassifiers = ((Class)packageable).getNestedClassifiers();
                            _nestedClassifiers.add((Object)primitiveType);
                        }
                        StereotypeUtil.apply((Element)primitiveType, Typedef.class);
                        Typedef _stereotypeApplication = (Typedef)UMLUtil.getStereotypeApplication((Element)primitiveType, Typedef.class);
                        _stereotypeApplication.setDefinition(typeName);
                        type = primitiveType;
                        doNotAnalyzeDeclaration = true;
                    }
                }
                if (type == null && (field.getTypeName().equals("enum") || field.getTypeName().equals("struct") || field.getTypeName().equals("class"))) {
                    String rawSignature_1 = fieldNode.getRawSignature();
                    String trimmedRawSignature = rawSignature_1.replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
                    Pattern pattern_1 = Pattern.compile("(\\{)(.*)(\\})");
                    Matcher matcher_1 = pattern_1.matcher(trimmedRawSignature);
                    boolean _find_1 = matcher_1.find();
                    if (_find_1) {
                        boolean _greaterThan;
                        String[] tokens = rawSignature_1.split("}");
                        String[] _converted_tokens = tokens;
                        int _size = ((List)Conversions.doWrapArray((Object)_converted_tokens)).size();
                        boolean bl = _greaterThan = _size > 0;
                        if (_greaterThan) {
                            String[] _converted_tokens_1 = tokens;
                            int _size_1 = ((List)Conversions.doWrapArray((Object)_converted_tokens_1)).size();
                            int _minus = _size_1 - 1;
                            String lastToken = tokens[_minus];
                            boolean _contains = lastToken.contains(field.getElementName());
                            if (_contains) {
                                lastToken = lastToken.replaceFirst(Pattern.quote(field.getElementName()), "typeName");
                            }
                            String typeName_1 = "";
                            String[] _converted_tokens_2 = tokens;
                            int _size_2 = ((List)Conversions.doWrapArray((Object)_converted_tokens_2)).size();
                            int _minus_1 = _size_2 - 1;
                            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
                            for (Integer i : _doubleDotLessThan) {
                                String _typeName = typeName_1;
                                String _get = tokens[i];
                                typeName_1 = String.valueOf(_typeName) + _get;
                            }
                            String _typeName_1 = typeName_1;
                            typeName_1 = String.valueOf(_typeName_1) + lastToken;
                            Package packageable_1 = null;
                            Element _owner_2 = prop.getOwner();
                            if (_owner_2 instanceof Class) {
                                Element _owner_3 = prop.getOwner();
                                packageable_1 = (Class)_owner_3;
                            } else {
                                packageable_1 = prop.getNearestPackage();
                            }
                            final String ownerName_1 = packageable_1.getName();
                            PrimitiveType _createPrimitiveType_1 = UMLFactory.eINSTANCE.createPrimitiveType();
                            Procedures.Procedure1<PrimitiveType> _function_1 = new Procedures.Procedure1<PrimitiveType>(){

                                public void apply(PrimitiveType it) {
                                    try {
                                        String _elementName = field.getElementName();
                                        String _plus = String.valueOf(ownerName_1) + "_" + _elementName;
                                        String _plus_1 = String.valueOf(_plus) + "_anon_";
                                        String _typeName = field.getTypeName();
                                        String _plus_2 = String.valueOf(_plus_1) + _typeName;
                                        it.setName(_plus_2);
                                    }
                                    catch (Throwable _e) {
                                        throw Exceptions.sneakyThrow((Throwable)_e);
                                    }
                                }
                            };
                            PrimitiveType primitiveType_1 = (PrimitiveType)ObjectExtensions.operator_doubleArrow((Object)_createPrimitiveType_1, (Procedures.Procedure1)_function_1);
                            if (packageable_1 instanceof Package) {
                                EList _ownedTypes_1 = packageable_1.getOwnedTypes();
                                _ownedTypes_1.add((Object)primitiveType_1);
                            } else {
                                EList _nestedClassifiers_1 = ((Class)packageable_1).getNestedClassifiers();
                                _nestedClassifiers_1.add((Object)primitiveType_1);
                            }
                            StereotypeUtil.apply((Element)primitiveType_1, Typedef.class);
                            Typedef _stereotypeApplication_1 = (Typedef)UMLUtil.getStereotypeApplication((Element)primitiveType_1, Typedef.class);
                            _stereotypeApplication_1.setDefinition(typeName_1);
                            type = primitiveType_1;
                            doNotAnalyzeDeclaration = true;
                        }
                    }
                }
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception e = (Exception)_t;
                    e.printStackTrace();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            this.excludeIncludFromTranslationUnit(field, prop);
            if (type == null) {
                type = this.getUMLType((IVariableDeclaration)field, this.reverse_utils.getContextNamespaces((ICElement)field));
            }
            prop.setType(type);
            prop.setName(field.getElementName());
            if (!doNotAnalyzeDeclaration && (node = this.getSelector(field.getTranslationUnit()).findEnclosingNode(field.getSourceRange().getStartPos(), field.getSourceRange().getLength())) instanceof IASTSimpleDeclaration) {
                this.reverse_utils.analyzeDeclaration((List)Conversions.doWrapArray((Object)((IASTSimpleDeclaration)node).getDeclarators()), prop.getType(), (TypedElement)prop, this.langID);
            }
            prop.setIsStatic(field.isStatic());
            prop.setVisibility(this.convertVisibility(field.getVisibility()));
            this.reverse_utils.applyStereotype((Element)prop, field.isConst(), ReverseUtils.StereotypeType.CONST, "");
            this.reverse_utils.applyStereotype((Element)prop, field.isVolatile(), ReverseUtils.StereotypeType.VOLATILE, "");
            this.reverse_utils.applyStereotype((Element)prop, field.isMutable(), ReverseUtils.StereotypeType.MUTABLE, "");
            EObject _eContainer = prop.eContainer();
            Association asso = TypeOperationsEnhanced.createAssociationFromProperty(prop, true, AggregationKind.NONE_LITERAL, false, AggregationKind.NONE_LITERAL, StringExtensions.toFirstLower((String)((Classifier)_eContainer).getName()), 1, 1);
            String _name = prop.getName();
            String _plus = "A_" + _name;
            String _plus_1 = String.valueOf(_plus) + "_";
            EObject _eContainer_1 = prop.eContainer();
            String _firstLower = StringExtensions.toFirstLower((String)((Classifier)_eContainer_1).getName());
            String _plus_2 = String.valueOf(_plus_1) + _firstLower;
            asso.setName(_plus_2);
            boolean _isSimpleAssociation = this.isSimpleAssociation(prop);
            if (_isSimpleAssociation) {
                prop.setAggregation(AggregationKind.NONE_LITERAL);
            } else {
                boolean _isAggregation = this.isAggregation(prop);
                if (_isAggregation) {
                    prop.setAggregation(AggregationKind.SHARED_LITERAL);
                } else {
                    boolean _isComposition = this.isComposition(prop);
                    if (_isComposition) {
                        prop.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    }
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private VisibilityKind convertVisibility(ASTAccessVisibility visibility) {
        boolean _equals = Objects.equal((Object)visibility, (Object)ASTAccessVisibility.PRIVATE);
        if (_equals) {
            return VisibilityKind.PRIVATE_LITERAL;
        }
        boolean _equals_1 = Objects.equal((Object)visibility, (Object)ASTAccessVisibility.PUBLIC);
        if (_equals_1) {
            return VisibilityKind.PUBLIC_LITERAL;
        }
        boolean _equals_2 = Objects.equal((Object)visibility, (Object)ASTAccessVisibility.PROTECTED);
        if (_equals_2) {
            return VisibilityKind.PROTECTED_LITERAL;
        }
        return VisibilityKind.PUBLIC_LITERAL;
    }

    public List<String> getContextNamespaces(ICElement element) {
        return this.reverse_utils.getContextNamespaces(element);
    }

    private Type getUMLType(IVariableDeclaration varDecl, List<String> contextNamespaces) {
        try {
            Type ret = null;
            ret = this.getUMLType(this.getCppTypeName(varDecl.getTypeName()), varDecl.getTranslationUnit(), contextNamespaces);
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String getCppTypeName(String name) {
        String trimName = name.trim();
        trimName = trimName.replace("*", "");
        trimName = trimName.replace("&", "");
        trimName = trimName.replace("[", "");
        trimName = trimName.replace("]", "");
        trimName = trimName.replace("const ", "");
        trimName = trimName.replace(" const", "");
        trimName = trimName.replace("volatile", "");
        trimName = trimName.replace(" volatile", "");
        trimName = trimName.trim();
        return trimName;
    }

    private Type getUMLType(IASTDeclSpecifier declarator, ITranslationUnit itu, List<String> contextNamespaces) {
        Type ret = null;
        ret = this.getUMLType(this.reverse_utils.getCppTypeName(declarator), itu, contextNamespaces);
        return ret;
    }

    private List<Map.Entry<ICElement, EObject>> getElementsSameName(final String name) {
        Functions.Function1<Map.Entry<ICElement, EObject>, Boolean> _function = new Functions.Function1<Map.Entry<ICElement, EObject>, Boolean>(){

            public Boolean apply(Map.Entry<ICElement, EObject> it) {
                return it.getKey().getElementName().equals(name);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(this.map.entrySet(), (Functions.Function1)_function));
    }

    private ICElement lookTypeInContainer(ICContainer container, final String typeName) {
        try {
            ICElement[] _children;
            ICElement ret = null;
            ICElement[] iCElementArray = _children = container.getChildren();
            int n = _children.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement child = iCElementArray[n2];
                if (child instanceof ITranslationUnit) {
                    List<ICElement> nesteds = this.reverse_utils.getAllIStructures((IParent)child, false, true, this.m_project);
                    Functions.Function1<ICElement, Boolean> _function = new Functions.Function1<ICElement, Boolean>(){

                        public Boolean apply(ICElement it) {
                            return it instanceof IStructure || it instanceof IEnumeration || it instanceof ITypeDef;
                        }
                    };
                    Functions.Function1<ICElement, Boolean> _function_1 = new Functions.Function1<ICElement, Boolean>(){

                        public Boolean apply(ICElement it) {
                            return it.getElementName().equals(typeName);
                        }
                    };
                    ret = (ICElement)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(nesteds, (Functions.Function1)_function), (Functions.Function1)_function_1));
                } else if (child instanceof ICContainer) {
                    ret = this.lookTypeInContainer((ICContainer)child, typeName);
                }
                if (ret != null) {
                    return ret;
                }
                ++n2;
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Type lookForATypeByName(String typeName) {
        try {
            ITranslationUnit itu;
            Type ret = null;
            ICElement cType = null;
            for (ICContainer container : this.containers) {
                if (cType != null) continue;
                cType = this.lookTypeInContainer(container, typeName);
            }
            if (cType != null && (itu = this.reverse_utils.getTranslationUnitFromElement(cType)) != null) {
                ret = this.getClassifier(this.getCorrespondingModel(itu), cType, cType.getElementName(), itu);
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Type getUMLType(String typeName, ITranslationUnit itu, List<String> contextNamespaces) {
        try {
            Package externalPackage;
            Functions.Function1<ICElement, Boolean> _function_1;
            ICElement sameNameType;
            boolean _greaterThan_1;
            boolean _greaterThan;
            Type ret = null;
            boolean _isPrimitiveCppType = RoundtripCppUtils.isPrimitiveCppType(typeName);
            if (_isPrimitiveCppType) {
                return RoundtripCppUtils.getPrimitiveType(typeName, this.getCorrespondingModel(itu));
            }
            String[] token = typeName.split("::");
            int _length = token.length;
            int _minus = _length - 1;
            final String simpleTypeName = token[_minus].trim();
            ArrayList<String> iUsings = new ArrayList<String>();
            iUsings.addAll(contextNamespaces);
            Functions.Function1<IUsing, String> _function = new Functions.Function1<IUsing, String>(){

                public String apply(IUsing it) {
                    return it.getElementName();
                }
            };
            Iterables.addAll(iUsings, (Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)itu.getChildren())), IUsing.class), (Functions.Function1)_function));
            List<Map.Entry<ICElement, EObject>> sameNames = this.getElementsSameName(simpleTypeName);
            if (sameNames.size() == 1 && ((Map.Entry)IterableExtensions.head(sameNames)).getValue() instanceof Type) {
                EObject _value = (EObject)((Map.Entry)IterableExtensions.head(sameNames)).getValue();
                return (Type)_value;
            }
            List<ICElement> nestedStructures = this.reverse_utils.getAllIStructures((IParent)itu, false, true, this.m_project);
            int _size = sameNames.size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                for (final Map.Entry<ICElement, EObject> sameName : sameNames) {
                    Functions.Function1<ICElement, Boolean> _function_12 = new Functions.Function1<ICElement, Boolean>(){

                        public Boolean apply(ICElement it) {
                            return it.getElementName().equals(((ICElement)sameName.getKey()).getElementName());
                        }
                    };
                    Iterable withinITU = IterableExtensions.filter(nestedStructures, (Functions.Function1)_function_12);
                    int _size_1 = IterableExtensions.size((Iterable)withinITU);
                    boolean bl2 = _greaterThan_1 = _size_1 > 0;
                    if (_greaterThan_1) {
                        EObject _value_1 = sameName.getValue();
                        return (Type)_value_1;
                    }
                    boolean _isSatisfyNamespace = this.reverse_utils.isSatisfyNamespace(iUsings, sameName.getKey());
                    if (!_isSatisfyNamespace) continue;
                    EObject _value_2 = sameName.getValue();
                    return (Type)_value_2;
                }
            }
            if ((sameNameType = (ICElement)IterableExtensions.head((Iterable)IterableExtensions.filter(nestedStructures, (Functions.Function1)(_function_1 = new Functions.Function1<ICElement, Boolean>(){

                public Boolean apply(ICElement it) {
                    return it.getElementName().trim().equals(simpleTypeName.trim());
                }
            })))) == null) {
                Functions.Function1<IStructureTemplate, Boolean> _function_2;
                Iterable structureTemplates = Iterables.filter(nestedStructures, IStructureTemplate.class);
                final IStructureTemplate match = (IStructureTemplate)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)structureTemplates, (Functions.Function1)(_function_2 = new Functions.Function1<IStructureTemplate, Boolean>(){

                    public Boolean apply(IStructureTemplate it) {
                        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

                            public Boolean apply(String it) {
                                return it.equals(simpleTypeName);
                            }
                        };
                        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getTemplateParameterTypes())), (Functions.Function1)_function));
                        return _size > 0;
                    }
                })));
                if (match != null) {
                    ICElement _parent = match.getParent();
                    Functions.Function1<Type, Boolean> _function_3 = new Functions.Function1<Type, Boolean>(){

                        public Boolean apply(Type it) {
                            return it.getName().equals(match.getElementName());
                        }
                    };
                    Type templatClassifier = (Type)IterableExtensions.head((Iterable)IterableExtensions.filter(this.getOrCreateClassifier(this.getCorrespondingModel(itu), (IParent)_parent), (Functions.Function1)_function_3));
                    ret = this.createOrgetTemplateParameter((NamedElement)((Classifier)templatClassifier), simpleTypeName, "class");
                }
            } else {
                ret = sameNameType instanceof IStructureDeclaration && !(sameNameType instanceof IStructure) ? this.lookForATypeByName(sameNameType.getElementName()) : this.getClassifier(this.getCorrespondingModel(itu), sameNameType, sameNameType.getElementName(), itu);
            }
            if ((externalPackage = RoundtripCppUtils.getOrcreateExternalPackage((Package)this.getCorrespondingModel(itu), false)) != null && externalPackage.getOwnedMember(simpleTypeName.trim()) != null && externalPackage.getOwnedMember(simpleTypeName.trim()) instanceof Type) {
                NamedElement _ownedMember = externalPackage.getOwnedMember(simpleTypeName.trim());
                ret = (Type)_ownedMember;
            }
            if (ret == null) {
                String[] _converted_token = token;
                int _size_1 = ((List)Conversions.doWrapArray((Object)_converted_token)).size();
                boolean bl3 = _greaterThan_1 = _size_1 > 1;
                if (_greaterThan_1) {
                    int i = 0;
                    while (i < ((List)Conversions.doWrapArray((Object)token)).size() - 1) {
                        iUsings.add(token[i].trim());
                        if (i > 0) {
                            String[] _converted_token_1 = token;
                            String n = ((String)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_token_1)))).trim();
                            int j = 1;
                            while (j <= i) {
                                String _plus;
                                String _trim = token[j].trim();
                                n = _plus = String.valueOf(n) + "::" + _trim;
                                ++j;
                            }
                            iUsings.add(n);
                        }
                        ++i;
                    }
                }
                UniqueEList includes = new UniqueEList();
                final UniqueEList istructures = new UniqueEList();
                ICElement _parent_1 = itu.getParent();
                if (_parent_1 instanceof ICContainer) {
                    ICElement _parent_2 = itu.getParent();
                    ICContainer container = (ICContainer)_parent_2;
                    Consumer<ITranslationUnit> _function_4 = new Consumer<ITranslationUnit>((List)includes){
                        private final /* synthetic */ List val$includes;
                        {
                            this.val$includes = list;
                        }

                        @Override
                        public void accept(ITranslationUnit it) {
                            try {
                                Functions.Function1<ICElement, Boolean> _function = new Functions.Function1<ICElement, Boolean>(){

                                    public Boolean apply(ICElement it) {
                                        return it.getElementName().trim().equals(simpleTypeName.trim());
                                    }
                                };
                                Iterables.addAll((Collection)istructures, (Iterable)IterableExtensions.filter(ReverseCpp2Uml.this.reverse_utils.getAllIStructures((IParent)it, false, true, ReverseCpp2Uml.this.m_project), (Functions.Function1)_function));
                                Iterable includesOfItu = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)it.getChildren())), IInclude.class);
                                Consumer<IInclude> _function_1 = new Consumer<IInclude>(){

                                    @Override
                                    public void accept(IInclude it) {
                                        final String nameOfIncludeItu = it.getElementName();
                                        Functions.Function1<IInclude, Boolean> _function = new Functions.Function1<IInclude, Boolean>(){

                                            public Boolean apply(IInclude it) {
                                                String _elementName = it.getElementName();
                                                return Objects.equal((Object)_elementName, (Object)nameOfIncludeItu);
                                            }
                                        };
                                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)val$includes, (Functions.Function1)_function));
                                        if (_isEmpty) {
                                            val$includes.add(it);
                                        }
                                    }
                                };
                                includesOfItu.forEach(_function_1);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)container.getChildren())), ITranslationUnit.class).forEach(_function_4);
                    for (ICElement structure : istructures) {
                        boolean _equals;
                        Functions.Function1<Type, Boolean> _function_5;
                        boolean _isSatisfyNamespace;
                        if (ret != null || !(_isSatisfyNamespace = this.reverse_utils.isSatisfyNamespace(iUsings, structure))) continue;
                        List<Type> tmp = this.getOrCreateClassifier(this.getCorrespondingModel(this.reverse_utils.getTranslationUnitFromElement(structure)), (IParent)this.reverse_utils.getTranslationUnitFromElement(structure));
                        Iterable sames = IterableExtensions.filter(tmp, (Functions.Function1)(_function_5 = new Functions.Function1<Type, Boolean>(){

                            public Boolean apply(Type it) {
                                return it != null && it.getName().trim().equals(simpleTypeName);
                            }
                        }));
                        int _size_2 = IterableExtensions.size((Iterable)sames);
                        boolean bl4 = _equals = _size_2 == 1;
                        if (_equals) {
                            ret = (Type)IterableExtensions.head((Iterable)sames);
                            continue;
                        }
                        boolean bl5 = this.reverse_utils.isSatisfyNamespace(iUsings, structure);
                    }
                }
                Iterables.addAll((Collection)includes, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)itu.getChildren())), IInclude.class));
                UniqueEList includes_level2 = new UniqueEList();
                while (ret == null && !includes.isEmpty()) {
                    for (IInclude include : includes) {
                        if (ret == null) {
                            boolean _contains = include.getFullFileName().contains(this.m_project.getElementName());
                            if (!_contains) continue;
                            ret = this.lookupTypeInInclude(simpleTypeName, include, iUsings);
                            continue;
                        }
                        ITranslationUnit translationUnit = this.reverse_utils.getTranslationUnitFromInclude(include, this.m_project);
                        if (translationUnit == null) continue;
                        Iterables.addAll((Collection)includes_level2, (Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)translationUnit.getChildren())), IInclude.class));
                    }
                    if (ret != null) continue;
                    includes.clear();
                    includes.addAll(includes_level2);
                    includes_level2.clear();
                }
            }
            if (ret == null) {
                LOGGER.log(Level.WARNING, String.valueOf(typeName) + " is not found, it will be created dynamically");
                externalPackage = RoundtripCppUtils.getOrcreateExternalPackage((Package)this.getCorrespondingModel(itu), true);
                ret = externalPackage.getOwnedType(typeName.trim());
                if (ret == null) {
                    ret = externalPackage.createOwnedType(typeName.trim(), UMLPackage.Literals.DATA_TYPE);
                    StereotypeUtil.apply((Element)ret, External.class);
                }
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void excludeIncludFromTranslationUnit(IField field, Property property) {
        try {
            if (field != null) {
                String type = field.getTypeName();
                List<String> context = this.reverse_utils.getContextNamespaces((ICElement)field);
                ITranslationUnit translationUnit = field.getTranslationUnit();
                Classifier structure = null;
                Element owner = property.getOwner();
                while (owner != null && !(owner instanceof Classifier)) {
                    owner = owner.getOwner();
                }
                if (owner instanceof Classifier) {
                    structure = (Classifier)owner;
                }
                this.excludeIncludFromTranslationUnit(type, (Element)structure, translationUnit, context);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void excludeIncludFromTranslationUnit(IASTParameterDeclaration param, IMethodDeclaration method, Operation operation) {
        if (param != null && method != null) {
            ITranslationUnit translationUnit = method.getTranslationUnit();
            String type = this.reverse_utils.getCppTypeName(param.getDeclSpecifier());
            List<String> context = this.reverse_utils.getContextNamespaces((ICElement)method);
            Classifier structure = null;
            Element owner = operation.getOwner();
            while (owner != null && !(owner instanceof Classifier)) {
                owner = owner.getOwner();
            }
            if (owner instanceof Classifier) {
                structure = (Classifier)owner;
            }
            this.excludeIncludFromTranslationUnit(type, (Element)structure, translationUnit, context);
        }
    }

    private void excludeIncludFromTranslationUnit(String excludedType, Element fromStructure, ITranslationUnit translationUnit, List<String> context) {
        List<IInclude> includes;
        if (excludedType != null && fromStructure != null && translationUnit != null && context != null && (includes = this.getIncludesFromType(excludedType, translationUnit, context)) != null && !includes.isEmpty()) {
            String key = this.getExcludedIncludesMapKey(translationUnit, fromStructure);
            UniqueEList includesInTranslationUnit = this.excludedIncludesMap.get(key);
            if (includesInTranslationUnit == null) {
                UniqueEList _uniqueEList;
                includesInTranslationUnit = _uniqueEList = new UniqueEList();
                this.excludedIncludesMap.put(key, (List<IInclude>)includesInTranslationUnit);
            }
            includesInTranslationUnit.addAll(includes);
        }
    }

    private String getExcludedIncludesMapKey(ITranslationUnit translationUnit, Element umlElement) {
        int _hashCode = translationUnit.hashCode();
        String _plus = "" + Integer.valueOf(_hashCode);
        int _hashCode_1 = umlElement.hashCode();
        return String.valueOf(_plus) + Integer.valueOf(_hashCode_1);
    }

    private List<IInclude> getIncludesFromType(String typeName, ITranslationUnit itu, List<String> iUsings) {
        try {
            UniqueEList includes = new UniqueEList();
            if (typeName == null || itu == null || iUsings == null) {
                return includes;
            }
            boolean _contains = ArrayExtensions.contains((Object[])BatchReverseFunctionBody.ansiTypes, (Object)typeName);
            if (_contains) {
                return includes;
            }
            String[] token = typeName.split("::");
            int _length = token.length;
            int _minus = _length - 1;
            String simpleTypeName = token[_minus].trim();
            Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)itu.getChildren())), IInclude.class);
            for (IInclude include : _filter) {
                boolean _contains_1 = include.getFullFileName().contains(this.m_project.getElementName());
                if (!_contains_1) continue;
                includes.add(include);
            }
            return includes;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type lookupTypeInInclude(final String simpleTypeName, IInclude include, List<String> iUsings) {
        ITranslationUnit unit;
        UniqueEList istructures;
        Type ret;
        block7: {
            block6: {
                boolean _contains = include.getFullFileName().contains(this.m_project.getElementName());
                if (!_contains) return null;
                boolean bl = false;
                boolean _not = bl;
                if (!_not) break block6;
                return null;
            }
            ret = null;
            istructures = new UniqueEList();
            if (ret != null) return ret;
            istructures.clear();
            unit = this.reverse_utils.getTranslationUnitFromInclude(include, this.m_project);
            if (unit != null) break block7;
            return null;
        }
        try {
            Functions.Function1<ICElement, Boolean> _function = new Functions.Function1<ICElement, Boolean>(){

                public Boolean apply(ICElement it) {
                    return it.getElementName().trim().equals(simpleTypeName.trim());
                }
            };
            Iterables.addAll((Collection)istructures, (Iterable)IterableExtensions.filter(this.reverse_utils.getAllIStructures((IParent)unit, false, true, this.m_project), (Functions.Function1)_function));
            for (ICElement structure : istructures) {
                boolean _equals;
                Functions.Function1<Type, Boolean> _function_1;
                if (ret != null) continue;
                List<Type> tmp = this.getOrCreateClassifier(this.getCorrespondingModel(this.reverse_utils.getTranslationUnitFromElement(structure)), (IParent)this.reverse_utils.getTranslationUnitFromElement(structure));
                Iterable sameNames = IterableExtensions.filter(tmp, (Functions.Function1)(_function_1 = new Functions.Function1<Type, Boolean>(){

                    public Boolean apply(Type it) {
                        return it != null && it.getName().trim().equals(simpleTypeName);
                    }
                }));
                int _size = IterableExtensions.size((Iterable)sameNames);
                boolean bl = _equals = _size == 1;
                if (_equals) {
                    ret = (Type)IterableExtensions.head((Iterable)sameNames);
                    continue;
                }
                boolean bl2 = this.reverse_utils.isSatisfyNamespace(iUsings, structure);
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private UniqueEList<Classifier> getTypeByQualifiedName(ICElement element, ITranslationUnit translationUnit, List<String> contextNames) {
        boolean _contains;
        UniqueEList results = new UniqueEList();
        if ((element instanceof IVariableDeclaration || element instanceof IMethod) && (_contains = element.getElementName().contains("::"))) {
            Type typeRet;
            boolean _greaterThan;
            String[] classifierNameTokens = element.getElementName().split("::");
            String classifierName = "";
            int _length = classifierNameTokens.length;
            boolean bl = _greaterThan = _length > 1;
            if (_greaterThan) {
                int _length_1 = classifierNameTokens.length;
                int _minus = _length_1 - 2;
                classifierName = classifierNameTokens[_minus];
            } else {
                classifierName = classifierNameTokens[0];
            }
            boolean isFound = false;
            int i = 0;
            while (i < results.size() && !isFound) {
                boolean _equals;
                Classifier classifier = (Classifier)results.get(i);
                if (classifier != null && (_equals = classifier.getName().equals(classifierName))) {
                    isFound = true;
                }
                ++i;
            }
            if (!isFound && (typeRet = this.getUMLType(classifierName, translationUnit, contextNames)) instanceof Classifier) {
                results.add((Object)((Classifier)typeRet));
            }
        }
        return results;
    }

    public static enum ConflictResolutionMode {
        FROM_MODEL,
        FROM_CODE,
        UI_INTERACTION;

    }

    public static enum ReverseMode {
        BATCH,
        INCREMENTAL;

    }
}

