/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.AcslScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.BehaviorScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.InterfaceScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.StateMachineScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.variableScript;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlOperationServices;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.EStorageClass;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.StorageClass;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FunctionScript {
    public static final Pattern CLANGUAGE = Pattern.compile("C|C\\/C\\+\\+|c");

    public static CharSequence genFunctionPrototype(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ownedComments = operation.getOwnedComments();
        for (Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment((Element)comment);
            _builder.append((Object)_genComment);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        CharSequence _genDeclarator = FunctionScript.genDeclarator(operation);
        _builder.append((Object)_genDeclarator);
        CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(operation, true);
        _builder.append((Object)_genReturnArgumentType);
        String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(operation);
        _builder.append(_genFunctionDeclarator);
        _builder.append("(");
        String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(operation, true);
        _builder.append(_genArgumentDeclarator);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genFunctionPrototype(Reception reception) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ownedComments = reception.getOwnedComments();
        for (Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment((Element)comment);
            _builder.append((Object)_genComment);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("void ");
        String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(reception);
        _builder.append(_genFunctionDeclarator);
        _builder.append("(");
        String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(reception);
        _builder.append(_genArgumentDeclarator);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genFunctionImplementation(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genComment = CommonScript.genComment((Element)operation);
        _builder.append((Object)_genComment);
        _builder.newLineIfNotEmpty();
        String _genPrePostConditions = AcslScript.genPrePostConditions(operation);
        _builder.append(_genPrePostConditions);
        _builder.newLineIfNotEmpty();
        CharSequence _genDeclarator = FunctionScript.genDeclarator(operation);
        _builder.append((Object)_genDeclarator);
        CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(operation, false);
        _builder.append((Object)_genReturnArgumentType);
        String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(operation);
        _builder.append(_genFunctionDeclarator);
        _builder.append("(");
        String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(operation, false);
        _builder.append(_genArgumentDeclarator);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        Iterable _filter = Iterables.filter((Iterable)operation.getModel().allOwnedElements(), CallEvent.class);
        for (CallEvent callevent : _filter) {
            Operation _operation = callevent.getOperation();
            boolean _equals = Objects.equal((Object)_operation, (Object)operation);
            if (!_equals) continue;
            _builder.append("\t");
            _builder.append("/* it is an operation of a call event : only one event associated with this operation*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _genDeclarator_1 = FunctionScript.genDeclarator(callevent.getOperation());
            _builder.append((Object)_genDeclarator_1, "\t\t");
            String _genCallEventOperationDeclarator = FunctionScript.genCallEventOperationDeclarator(callevent);
            _builder.append(_genCallEventOperationDeclarator, "\t\t");
            _builder.append("(");
            String _genCallArgumentDeclarator = FunctionScript.genCallArgumentDeclarator(callevent.getOperation());
            _builder.append(_genCallArgumentDeclarator, "\t\t");
            _builder.append(");\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* original code*/\t\t\t");
            _builder.newLine();
        }
        _builder.append("\t");
        String _body = GenUtils.getBody((Operation)operation, (Pattern)CLANGUAGE);
        _builder.append(_body, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genFunctionImplementation(Reception reception) {
        StringConcatenation _xblockexpression = null;
        String body = "";
        if (reception.getOwner() instanceof Class && ((Class)reception.getOwner()).getClassifierBehavior() instanceof StateMachine) {
            Element _owner = reception.getOwner();
            Class clazz = (Class)_owner;
            SignalEvent signalEvent = null;
            int i = 0;
            Iterable triggers = Iterables.filter((Iterable)clazz.getClassifierBehavior().allOwnedElements(), Trigger.class);
            while (signalEvent == null && i < IterableExtensions.size((Iterable)triggers)) {
                Iterable _converted_triggers = triggers;
                Trigger trigger = ((Trigger[])Conversions.unwrapArray((Object)_converted_triggers, Trigger.class))[i];
                if (trigger.getEvent() instanceof SignalEvent && ((SignalEvent)trigger.getEvent()).getSignal() == reception.getSignal()) {
                    Event _event = trigger.getEvent();
                    signalEvent = (SignalEvent)_event;
                }
                ++i;
            }
            if (signalEvent != null) {
                StringConcatenation _builder = new StringConcatenation();
                String _genSignalEventOperationDeclarator = FunctionScript.genSignalEventOperationDeclarator(signalEvent);
                _builder.append(_genSignalEventOperationDeclarator);
                _builder.append("(self, signal);");
                _builder.newLineIfNotEmpty();
                body = _builder.toString();
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        EList _ownedComments = reception.getOwnedComments();
        for (Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment((Element)comment);
            _builder_1.append((Object)_genComment);
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("void ");
        String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(reception);
        _builder_1.append(_genFunctionDeclarator);
        _builder_1.append("(");
        String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(reception);
        _builder_1.append(_genArgumentDeclarator);
        _builder_1.append(") {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append(body, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.newLine();
        _xblockexpression = _builder_1;
        return _xblockexpression;
    }

    public static CharSequence genCallEventProcessFunctionImplementation(CallEvent callevent, Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ownedComments = callevent.getOwnedComments();
        for (Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment((Element)comment);
            _builder.append((Object)_genComment);
            _builder.newLineIfNotEmpty();
        }
        CharSequence _genDeclarator = FunctionScript.genDeclarator(callevent.getOperation());
        _builder.append((Object)_genDeclarator);
        CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(callevent.getOperation(), false);
        _builder.append((Object)_genReturnArgumentType);
        String _genCallEventOperationDeclarator = FunctionScript.genCallEventOperationDeclarator(callevent);
        _builder.append(_genCallEventOperationDeclarator);
        _builder.append("(");
        String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(callevent.getOperation(), false);
        _builder.append(_genArgumentDeclarator);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _genProcessMethodBody = StateMachineScript.genProcessMethodBody((Event)callevent, clazz);
        _builder.append(_genProcessMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genProcessCompletionEventFunctionImplementation(Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("void ProcessCompletionEvent(");
        CharSequence _genName = CommonScript.genName((NamedElement)clazz);
        _builder.append((Object)_genName);
        _builder.append("* self){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _genProcessCompletionEventMethodBody = StateMachineScript.genProcessCompletionEventMethodBody(clazz);
        _builder.append(_genProcessCompletionEventMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genSignalEventProcessFunctionImplementation(SignalEvent signalEvent, Class clazz) {
        StringConcatenation _xblockexpression = null;
        boolean triggersClassTransition = false;
        int i = 0;
        Iterable triggers = Iterables.filter((Iterable)clazz.allOwnedElements(), Trigger.class);
        while (!triggersClassTransition && i < IterableExtensions.size((Iterable)triggers)) {
            if (((Trigger[])Conversions.unwrapArray((Object)triggers, Trigger.class))[i].getEvent() != null && ((Trigger[])Conversions.unwrapArray((Object)triggers, Trigger.class))[i].getEvent() == signalEvent) {
                triggersClassTransition = true;
            }
            ++i;
        }
        StringConcatenation _xifexpression = null;
        if (triggersClassTransition) {
            StringConcatenation _builder = new StringConcatenation();
            EList _ownedComments = signalEvent.getOwnedComments();
            for (Comment comment : _ownedComments) {
                CharSequence _genComment = CommonScript.genComment((Element)comment);
                _builder.append((Object)_genComment);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("void ");
            String _genSignalEventOperationDeclarator = FunctionScript.genSignalEventOperationDeclarator(signalEvent);
            _builder.append(_genSignalEventOperationDeclarator);
            _builder.append("(");
            CharSequence _genName = CommonScript.genName((NamedElement)clazz);
            _builder.append((Object)_genName);
            _builder.append("* self, ");
            CharSequence _genName_1 = CommonScript.genName((NamedElement)signalEvent.getSignal());
            _builder.append((Object)_genName_1);
            _builder.append(" *sig) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            String _genProcessMethodBody = StateMachineScript.genProcessMethodBody((Event)signalEvent, clazz);
            _builder.append(_genProcessMethodBody, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static CharSequence genFunctionPrototype(CallEvent callEvent) {
        StringConcatenation _builder = new StringConcatenation();
        EList _ownedComments = callEvent.getOwnedComments();
        for (Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment((Element)comment);
            _builder.append((Object)_genComment);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        CharSequence _genDeclarator = FunctionScript.genDeclarator(callEvent.getOperation());
        _builder.append((Object)_genDeclarator);
        CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(callEvent.getOperation(), true);
        _builder.append((Object)_genReturnArgumentType);
        String _genCallEventOperationDeclarator = FunctionScript.genCallEventOperationDeclarator(callEvent);
        _builder.append(_genCallEventOperationDeclarator);
        _builder.append("(");
        String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(callEvent.getOperation(), true);
        _builder.append(_genArgumentDeclarator);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence genFunctionPrototype(SignalEvent signalEvent, Class clazz) {
        StringConcatenation _xblockexpression = null;
        boolean triggersClassTransition = false;
        int i = 0;
        Iterable triggers = Iterables.filter((Iterable)clazz.allOwnedElements(), Trigger.class);
        while (!triggersClassTransition && i < IterableExtensions.size((Iterable)triggers)) {
            if (((Trigger[])Conversions.unwrapArray((Object)triggers, Trigger.class))[i].getEvent() != null && ((Trigger[])Conversions.unwrapArray((Object)triggers, Trigger.class))[i].getEvent() == signalEvent) {
                triggersClassTransition = true;
            }
            ++i;
        }
        StringConcatenation _xifexpression = null;
        if (triggersClassTransition) {
            StringConcatenation _builder = new StringConcatenation();
            EList _ownedComments = signalEvent.getOwnedComments();
            for (Comment comment : _ownedComments) {
                CharSequence _genComment = CommonScript.genComment((Element)comment);
                _builder.append((Object)_genComment);
                _builder.append(" ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("void ");
            String _genSignalEventOperationDeclarator = FunctionScript.genSignalEventOperationDeclarator(signalEvent);
            _builder.append(_genSignalEventOperationDeclarator);
            _builder.append("(");
            CharSequence _genName = CommonScript.genName((NamedElement)clazz);
            _builder.append((Object)_genName);
            _builder.append("* self, struct ");
            String _name = signalEvent.getSignal().getName();
            _builder.append(_name);
            _builder.append(" *sig);");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _xifexpression = _builder;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static CharSequence genDeclarator(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genStorageClass = FunctionScript.genStorageClass(operation);
        _builder.append((Object)_genStorageClass);
        CharSequence _genVolatile = FunctionScript.genVolatile(operation);
        _builder.append((Object)_genVolatile);
        CharSequence _genConstant = FunctionScript.genConstant(operation);
        _builder.append((Object)_genConstant);
        return _builder;
    }

    public static CharSequence genPointer(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, Ptr.class);
        if (_hasStereotype) {
            _builder.append("* ");
        }
        return _builder;
    }

    public static CharSequence genStorageClass(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, StorageClass.class);
        if (_hasStereotype) {
            EStorageClass _storageClass = ((StorageClass)UMLUtil.getStereotypeApplication((Element)operation, StorageClass.class)).getStorageClass();
            _builder.append((Object)_storageClass);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence genConstant(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, Const.class);
        if (_hasStereotype) {
            _builder.append("const ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence genVolatile(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, StorageClass.class);
        if (_hasStereotype) {
            EStorageClass _storageClass = ((StorageClass)UMLUtil.getStereotypeApplication((Element)operation, StorageClass.class)).getStorageClass();
            boolean _equals = Objects.equal((Object)_storageClass, (Object)EStorageClass.VOLATILE);
            if (_equals) {
                _builder.append("volatile ");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static String genArgumentDeclarator(Operation operation, boolean isHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (!operation.isStatic() && !GenUtils.hasStereotype((Element)operation, Create.class)) {
            boolean _greaterThan;
            String _genClassArgument = FunctionScript.genClassArgument(operation);
            _builder.append(_genClassArgument);
            int _size = UmlOperationServices.getArguments(operation).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append(", ");
            }
            _builder.newLineIfNotEmpty();
        }
        String _genArguments = FunctionScript.genArguments(operation, isHeader);
        _builder.append(_genArguments);
        _builder.newLineIfNotEmpty();
        return _builder.toString().trim();
    }

    public static String genArgumentDeclarator(Reception reception) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isStatic = reception.isStatic();
        if (_isStatic) {
            String _genArguments = FunctionScript.genArguments(reception);
            _builder.append(_genArguments);
            _builder.newLineIfNotEmpty();
        } else {
            String _genClassArgument = FunctionScript.genClassArgument(reception);
            _builder.append(_genClassArgument);
            _builder.append(", ");
            String _genArguments_1 = FunctionScript.genArguments(reception);
            _builder.append(_genArguments_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString().trim();
    }

    public static String genCallArgumentDeclarator(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        if (!operation.isStatic() && !GenUtils.hasStereotype((Element)operation, Create.class)) {
            boolean _greaterThan;
            _builder.append("self");
            int _size = UmlOperationServices.getArguments(operation).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append(", ");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
        }
        String _genCallArguments = FunctionScript.genCallArguments(operation);
        _builder.append(_genCallArguments);
        _builder.newLineIfNotEmpty();
        return _builder.toString().trim();
    }

    public static String genFunctionDeclarator(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, Ptr.class);
        if (_hasStereotype) {
            _builder.append("(*");
            CharSequence _genName = FunctionScript.genName(operation);
            _builder.append((Object)_genName);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _genName_1 = FunctionScript.genName(operation);
            _builder.append((Object)_genName_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString().trim();
    }

    public static String genFunctionDeclarator(Reception reception) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)reception, Ptr.class);
        if (_hasStereotype) {
            _builder.append("(*");
            CharSequence _genName = CommonScript.genName((NamedElement)reception);
            _builder.append((Object)_genName);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _genName_1 = CommonScript.genName((NamedElement)reception);
            _builder.append((Object)_genName_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString().trim();
    }

    public static String genCallEventOperationDeclarator(CallEvent callevent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genName = FunctionScript.genName(callevent.getOperation());
        String _plus = "ProcessCE_" + _genName;
        _builder.append(_plus, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder.toString().trim();
    }

    public static String genEntryPrototype(State state) {
        String _xblockexpression = null;
        String _name = state.getName();
        String name = String.valueOf(_name) + "_entry";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _behaviorDeclaration = BehaviorScript.behaviorDeclaration(name, state.getEntry());
        _builder.append((Object)_behaviorDeclaration);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString().trim();
        return _xblockexpression;
    }

    public static String genExitPrototype(State state) {
        String _xblockexpression = null;
        String _name = state.getName();
        String name = String.valueOf(_name) + "_exit";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _behaviorDeclaration = BehaviorScript.behaviorDeclaration(name, state.getExit());
        _builder.append((Object)_behaviorDeclaration, "\t");
        _builder.append("\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString().trim();
        return _xblockexpression;
    }

    public static String genDoActivityPrototype(State state) {
        String _xblockexpression = null;
        String _name = state.getName();
        String name = String.valueOf(_name) + "_doActivity";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _behaviorDeclaration = BehaviorScript.behaviorDeclaration(name, state.getDoActivity());
        _builder.append((Object)_behaviorDeclaration, "\t");
        _builder.append("\t\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString().trim();
        return _xblockexpression;
    }

    public static String genEntryImplementation(State state) {
        String _xblockexpression = null;
        String _name = state.getName();
        String name = String.valueOf(_name) + "_entry";
        StringConcatenation _builder = new StringConcatenation();
        Behavior _entry = state.getEntry();
        CharSequence _behaviorImplementation = BehaviorScript.behaviorImplementation(name, (OpaqueBehavior)_entry);
        _builder.append((Object)_behaviorImplementation);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString().trim();
        return _xblockexpression;
    }

    public static String genExitImplementation(State state) {
        String _xblockexpression = null;
        String _name = state.getName();
        String name = String.valueOf(_name) + "_exit";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        Behavior _exit = state.getExit();
        CharSequence _behaviorImplementation = BehaviorScript.behaviorImplementation(name, (OpaqueBehavior)_exit);
        _builder.append((Object)_behaviorImplementation, "\t");
        _builder.append("\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString().trim();
        return _xblockexpression;
    }

    public static String genDoActivityImplementation(State state) {
        String _xblockexpression = null;
        String _name = state.getName();
        String name = String.valueOf(_name) + "_doActivity";
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        Behavior _doActivity = state.getDoActivity();
        CharSequence _behaviorImplementation = BehaviorScript.behaviorImplementation(name, (OpaqueBehavior)_doActivity);
        _builder.append((Object)_behaviorImplementation, "\t");
        _builder.append("\t\t");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder.toString().trim();
        return _xblockexpression;
    }

    public static String genSignalEventOperationDeclarator(SignalEvent signalEvent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _genName = CommonScript.genName((NamedElement)signalEvent.getSignal());
        String _plus = "ProcessSE_" + _genName;
        _builder.append(_plus, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder.toString().trim();
    }

    public static String genClassArgument(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        Namespace _namespace = operation.getNamespace();
        if (_namespace instanceof Interface) {
            Functions.Function1<EList<NamedElement>, CharSequence> _function = new Functions.Function1<EList<NamedElement>, CharSequence>(){

                public CharSequence apply(EList<NamedElement> it) {
                    return CommonScript.genName((NamedElement)it);
                }
            };
            Iterable _map = IterableExtensions.map(InterfaceScript.getInterfaceRealizationClass((Classifier)operation.getInterface()), (Functions.Function1)_function);
            _builder.append((Object)_map);
            _builder.append(" *self");
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _genName = CommonScript.genName((NamedElement)operation.getNamespace());
            _builder.append((Object)_genName);
            _builder.append(" *self");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString().trim();
    }

    public static String genClassArgument(Reception reception) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _genName = CommonScript.genName((NamedElement)reception.getNamespace());
        _builder.append((Object)_genName);
        _builder.append(" *self");
        _builder.newLineIfNotEmpty();
        return _builder.toString().trim();
    }

    public static String genArguments(Operation operation, boolean isHeader) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Parameter> _arguments = UmlOperationServices.getArguments(operation);
        boolean _hasElements = false;
        for (Parameter parameter : _arguments) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.append(" ");
            String _genType = variableScript.genType((TypedElement)parameter);
            _builder.append(_genType);
            _builder.append(" ");
            CharSequence _genPointer = variableScript.genPointer((TypedElement)parameter);
            _builder.append((Object)_genPointer);
            CharSequence _genName = CommonScript.genName((NamedElement)parameter);
            _builder.append((Object)_genName);
            _builder.append(" ");
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString().trim();
    }

    public static String genArguments(Reception reception) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct ");
        CharSequence _genName = CommonScript.genName((NamedElement)reception.getSignal());
        _builder.append((Object)_genName);
        _builder.append(" *signal");
        _builder.newLineIfNotEmpty();
        return _builder.toString().trim();
    }

    public static String genCallArguments(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Parameter> _arguments = UmlOperationServices.getArguments(operation);
        boolean _hasElements = false;
        for (Parameter parameter : _arguments) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _genName = CommonScript.genName((NamedElement)parameter);
            _builder.append((Object)_genName);
            _builder.append(" ");
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString().trim();
    }

    public static CharSequence genReturnArgumentType(Operation operation, boolean isHeader) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        Parameter _returnResult = operation.getReturnResult();
        boolean bl = _tripleNotEquals = _returnResult != null;
        if (_tripleNotEquals) {
            String _genType = variableScript.genType((TypedElement)operation.getReturnResult());
            _builder.append(_genType);
            CharSequence _genPointer = variableScript.genPointer((TypedElement)operation.getReturnResult());
            _builder.append((Object)_genPointer);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, Create.class);
            if (_hasStereotype) {
                CharSequence _genName = CommonScript.genName((NamedElement)operation.getClass_());
                _builder.append((Object)_genName);
                _builder.append("*");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("void");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public static CharSequence genName(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isStatic = operation.isStatic();
        if (_isStatic) {
            String _genVisibility = CommonScript.genVisibility((NamedElement)operation);
            _builder.append(_genVisibility);
            CharSequence _genCoreName = CommonScript.genCoreName((NamedElement)operation);
            _builder.append((Object)_genCoreName);
            _builder.newLineIfNotEmpty();
        } else {
            Namespace _namespace = operation.getNamespace();
            if (_namespace instanceof Interface) {
                String _genVisibility_1 = CommonScript.genVisibility((NamedElement)operation);
                _builder.append(_genVisibility_1);
                Functions.Function1<EList<NamedElement>, CharSequence> _function = new Functions.Function1<EList<NamedElement>, CharSequence>(){

                    public CharSequence apply(EList<NamedElement> it) {
                        return CommonScript.genName((NamedElement)it);
                    }
                };
                Iterable _map = IterableExtensions.map(InterfaceScript.getInterfaceRealizationClass((Classifier)operation.getInterface()), (Functions.Function1)_function);
                _builder.append((Object)_map);
                _builder.append("_");
                CharSequence _genCoreName_1 = CommonScript.genCoreName((NamedElement)operation);
                _builder.append((Object)_genCoreName_1);
                _builder.newLineIfNotEmpty();
            } else {
                String _genVisibility_2 = CommonScript.genVisibility((NamedElement)operation);
                _builder.append(_genVisibility_2);
                CharSequence _genName = CommonScript.genName((NamedElement)operation.getNamespace());
                _builder.append((Object)_genName);
                _builder.append("_");
                CharSequence _genCoreName_2 = CommonScript.genCoreName((NamedElement)operation);
                _builder.append((Object)_genCoreName_2);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }
}

