/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.io.java.binding;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.java.discoverer.internal.Messages;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.Binding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.ClassBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.FieldBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.IBindingFactory;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.MethodBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.PackageBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.ParameterBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.UnresolvedBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.VariableBinding;

public final class JDTDelegateBindingFactory
implements IBindingFactory {
    private boolean logJDTBindingsIssues = false;
    private static IBindingFactory instance = new JDTDelegateBindingFactory();

    private JDTDelegateBindingFactory() {
    }

    public static IBindingFactory getInstance() {
        return instance;
    }

    public void setLogJDTBindingsIssues(boolean newValue) {
        this.logJDTBindingsIssues = newValue;
    }

    public Binding getBindingForName(Name name) {
        Binding result = this.getBinding(name.resolveBinding());
        if (result == null) {
            result = new UnresolvedBinding(name.getFullyQualifiedName());
        }
        return result;
    }

    public Binding getBindingForPrimitiveType(PrimitiveType type) {
        Binding result = new Binding(type.getPrimitiveTypeCode().toString());
        return result;
    }

    public Binding getBindingForParameterizedType(ParameterizedType type) {
        Binding result = null;
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            if (this.logJDTBindingsIssues) {
                MoDiscoLogger.logWarning((String)("*** WARNING : binding '" + type.toString() + "' unresolved."), (Plugin)JavaActivator.getDefault());
            }
            result = new UnresolvedBinding(type.toString());
        } else {
            String bindingId = binding.getQualifiedName();
            result = bindingId.indexOf(60) > 0 ? new Binding(bindingId) : new UnresolvedBinding(type.toString());
        }
        return result;
    }

    public Binding getBindingForWildCardType(WildcardType type) {
        Binding result = null;
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            if (this.logJDTBindingsIssues) {
                MoDiscoLogger.logWarning((String)("*** WARNING : binding '" + type.toString() + "' unresolved."), (Plugin)JavaActivator.getDefault());
            }
            result = new UnresolvedBinding(type.toString());
        } else {
            result = new Binding(binding.getQualifiedName());
        }
        return result;
    }

    public Binding getBindingForArrayType(ArrayType type) {
        Binding result = null;
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            if (this.logJDTBindingsIssues) {
                MoDiscoLogger.logWarning((String)("*** WARNING : binding '" + type.toString() + "' unresolved."), (Plugin)JavaActivator.getDefault());
            }
            result = new UnresolvedBinding(type.toString());
        } else {
            result = new ClassBinding();
            result.setName(binding.getQualifiedName());
        }
        return result;
    }

    public Binding getBindingForClassInstanceCreation(ClassInstanceCreation constructorCall) {
        Binding result = null;
        IMethodBinding binding = constructorCall.resolveConstructorBinding();
        if (binding == null || binding.getDeclaringClass() == null) {
            if (this.logJDTBindingsIssues) {
                MoDiscoLogger.logWarning((String)("*** WARNING : binding '" + constructorCall.toString() + Messages.JDTDelegateBindingFactory_10), (Plugin)JavaActivator.getDefault());
            }
            result = new UnresolvedBinding(constructorCall.toString());
        } else {
            result = this.getMethodBinding(binding);
        }
        return result;
    }

    public Binding getBindingForConstructorInvocation(ConstructorInvocation constructorCall) {
        Binding result = null;
        IMethodBinding binding = constructorCall.resolveConstructorBinding();
        if (binding == null || binding.getDeclaringClass() == null) {
            if (this.logJDTBindingsIssues) {
                MoDiscoLogger.logWarning((String)("*** WARNING : binding '" + constructorCall.toString() + "' unresolved."), (Plugin)JavaActivator.getDefault());
            }
            result = new UnresolvedBinding(constructorCall.toString());
        } else {
            result = this.getMethodBinding(binding);
        }
        return result;
    }

    public Binding getBindingForSuperConstructorInvocation(SuperConstructorInvocation constructorCall) {
        Binding result = null;
        IMethodBinding binding = constructorCall.resolveConstructorBinding();
        if (binding == null || binding.getDeclaringClass() == null) {
            if (this.logJDTBindingsIssues) {
                MoDiscoLogger.logWarning((String)("*** WARNING : binding '" + constructorCall.toString() + "' unresolved."), (Plugin)JavaActivator.getDefault());
            }
            result = new UnresolvedBinding(constructorCall.toString());
        } else {
            result = this.getMethodBinding(binding);
        }
        return result;
    }

    private Binding getBinding(IBinding binding) {
        Binding result = null;
        if (binding instanceof IMethodBinding) {
            result = this.getMethodBinding((IMethodBinding)binding);
        } else if (binding instanceof ITypeBinding) {
            result = this.getClassBinding((ITypeBinding)binding, false);
        } else if (binding instanceof IPackageBinding) {
            result = JDTDelegateBindingFactory.getPackageBinding((IPackageBinding)binding);
        } else if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            result = this.getFieldBinding((IVariableBinding)binding);
        } else if (binding instanceof IVariableBinding && !((IVariableBinding)binding).isField()) {
            result = JDTDelegateBindingFactory.getVariableBinding((IVariableBinding)binding);
        }
        return result;
    }

    private MethodBinding getMethodBinding(IMethodBinding methodBinding) {
        IMethodBinding binding = methodBinding.getMethodDeclaration();
        MethodBinding result = new MethodBinding();
        result.setName(binding.getName());
        result.setDeclaringClass(this.getClassBinding(binding.getDeclaringClass(), false));
        result.setConstructor(binding.isConstructor());
        result.setAnnotationMember(binding.isAnnotationMember());
        int i = 0;
        while (i < binding.getParameterTypes().length) {
            result.getParameters().add(this.getParameterBinding(binding.getParameterTypes()[i]));
            ++i;
        }
        return result;
    }

    private ParameterBinding getParameterBinding(ITypeBinding binding) {
        ParameterBinding result = new ParameterBinding();
        result.setDimensions(binding.getDimensions());
        if (binding.isArray()) {
            result.setElementType(this.getClassBinding(binding.getElementType(), true));
        } else {
            result.setElementType(this.getClassBinding(binding, true));
        }
        return result;
    }

    private static PackageBinding getPackageBinding(IPackageBinding binding) {
        PackageBinding result = new PackageBinding();
        result.setName(binding.getName());
        return result;
    }

    private ClassBinding getClassBinding(ITypeBinding bindingParameter, boolean isParameterBinding) {
        ITypeBinding binding = bindingParameter.getTypeDeclaration();
        ClassBinding result = new ClassBinding();
        if (binding.isTypeVariable() && isParameterBinding) {
            if (binding.getErasure() != null) {
                result = this.getClassBinding(binding.getErasure(), isParameterBinding);
            } else {
                result.setName(binding.getName());
                result.setTypeVariable(binding.isTypeVariable());
            }
        } else if (binding.isAnonymous()) {
            result.setName(binding.getKey());
        } else {
            int n;
            int n2;
            ITypeBinding[] iTypeBindingArray;
            result.setName(binding.getName());
            result.setTypeVariable(binding.isTypeVariable());
            result.setInterface(binding.isInterface());
            result.setEnum(binding.isEnum());
            result.setAnnotation(binding.isAnnotation());
            if (binding.getPackage() != null) {
                result.setOwnerPackage(JDTDelegateBindingFactory.getPackageBinding(binding.getPackage()));
            }
            if (binding.getDeclaringClass() != null) {
                result.setDeclaringClass(this.getClassBinding(binding.getDeclaringClass(), false));
            }
            ITypeBinding superClass = binding.getSuperclass();
            if (binding.isClass() && superClass != null && !superClass.getQualifiedName().equals("java.lang.Object")) {
                result.setSuperClass(this.getClassBinding(superClass, false));
            }
            if (!binding.isAnnotation() && binding.getInterfaces() != null) {
                iTypeBindingArray = binding.getInterfaces();
                n2 = iTypeBindingArray.length;
                n = 0;
                while (n < n2) {
                    ITypeBinding anInterface = iTypeBindingArray[n];
                    if (!anInterface.getQualifiedName().equals("java.lang.Object")) {
                        result.getSuperInterfaces().add(this.getClassBinding(anInterface, false));
                    }
                    ++n;
                }
            }
            if (binding.getTypeParameters() != null) {
                iTypeBindingArray = binding.getTypeParameters();
                n2 = iTypeBindingArray.length;
                n = 0;
                while (n < n2) {
                    ITypeBinding typeParameter = iTypeBindingArray[n];
                    result.addTypeParameters(typeParameter.getName());
                    ++n;
                }
            }
        }
        return result;
    }

    private FieldBinding getFieldBinding(IVariableBinding binding) {
        FieldBinding result = new FieldBinding();
        result.setName(binding.getName());
        result.setEnumConstant(binding.isEnumConstant());
        if (binding.getDeclaringClass() != null) {
            result.setDeclaringClass(this.getClassBinding(binding.getDeclaringClass(), false));
        }
        return result;
    }

    private static VariableBinding getVariableBinding(IVariableBinding binding) {
        VariableBinding result = new VariableBinding();
        result.setName(String.valueOf(binding.getVariableId()));
        return result;
    }

    public boolean isLocal(Name name) {
        return JDTDelegateBindingFactory.isLocalVariable(name) || JDTDelegateBindingFactory.isLocalMethod(name);
    }

    private static boolean isLocalVariable(Name name) {
        boolean result = false;
        IBinding binding = name.resolveBinding();
        if (binding != null) {
            result = binding instanceof IVariableBinding && !((IVariableBinding)binding).isField();
        }
        return result;
    }

    private static boolean isLocalMethod(Name name) {
        ITypeBinding declaringClass;
        boolean result = false;
        IBinding binding = name.resolveBinding();
        if (binding != null && binding instanceof IMethodBinding && (declaringClass = ((IMethodBinding)binding).getDeclaringClass()) != null) {
            result = declaringClass.isAnonymous();
        }
        return result;
    }
}

