/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jet.internal.taglib.format.BundleTag;
import org.eclipse.jet.internal.taglib.format.FormatNowTag;
import org.eclipse.jet.internal.taglib.format.IndentTag;
import org.eclipse.jet.internal.taglib.format.LowerCaseTag;
import org.eclipse.jet.internal.taglib.format.MessageTag;
import org.eclipse.jet.internal.taglib.format.MillisecondsTag;
import org.eclipse.jet.internal.taglib.format.ParamTag;
import org.eclipse.jet.internal.taglib.format.ReplaceAllTag;
import org.eclipse.jet.internal.taglib.format.SetBundleTag;
import org.eclipse.jet.internal.taglib.format.SetLocaleTag;
import org.eclipse.jet.internal.taglib.format.StripTag;
import org.eclipse.jet.internal.taglib.format.UniqueTag;
import org.eclipse.jet.internal.taglib.format.UpperCaseTag;
import org.eclipse.jet.internal.taglib.format.UuidTag;
import org.eclipse.jet.internal.taglib.format.XPathTag;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

public class TagFactory
implements TagInstanceFactory {
    private final Map tagOrdinalByName = new HashMap(15);

    public TagFactory() {
        this.tagOrdinalByName.put("bundle", new Integer(1));
        this.tagOrdinalByName.put("formatNow", new Integer(2));
        this.tagOrdinalByName.put("indent", new Integer(3));
        this.tagOrdinalByName.put("lc", new Integer(4));
        this.tagOrdinalByName.put("message", new Integer(5));
        this.tagOrdinalByName.put("milliseconds", new Integer(6));
        this.tagOrdinalByName.put("param", new Integer(7));
        this.tagOrdinalByName.put("replaceAll", new Integer(8));
        this.tagOrdinalByName.put("setBundle", new Integer(9));
        this.tagOrdinalByName.put("setLocale", new Integer(10));
        this.tagOrdinalByName.put("strip", new Integer(11));
        this.tagOrdinalByName.put("uc", new Integer(12));
        this.tagOrdinalByName.put("unique", new Integer(13));
        this.tagOrdinalByName.put("uuid", new Integer(14));
        this.tagOrdinalByName.put("xpath", new Integer(15));
    }

    public CustomTag createCustomTag(String name) {
        Integer ordinal = (Integer)this.tagOrdinalByName.get(name);
        switch (ordinal == null ? 0 : ordinal) {
            case 1: {
                return new BundleTag();
            }
            case 2: {
                return new FormatNowTag();
            }
            case 3: {
                return new IndentTag();
            }
            case 4: {
                return new LowerCaseTag();
            }
            case 5: {
                return new MessageTag();
            }
            case 6: {
                return new MillisecondsTag();
            }
            case 7: {
                return new ParamTag();
            }
            case 8: {
                return new ReplaceAllTag();
            }
            case 9: {
                return new SetBundleTag();
            }
            case 10: {
                return new SetLocaleTag();
            }
            case 11: {
                return new StripTag();
            }
            case 12: {
                return new UpperCaseTag();
            }
            case 13: {
                return new UniqueTag();
            }
            case 14: {
                return new UuidTag();
            }
            case 15: {
                return new XPathTag();
            }
        }
        throw new JET2TagException("Unknown Tag: " + name);
    }
}

