/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions.extras;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPath;
import org.eclipse.jet.xpath.XPathException;
import org.eclipse.jet.xpath.XPathExpression;
import org.eclipse.jet.xpath.XPathFactory;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathRuntimeException;
import org.eclipse.jet.xpath.XPathUtil;

public class SortFunction
implements XPathFunction,
XPathFunctionWithContext {
    private Context context;

    public Object evaluate(List args) {
        List<Object> nodes;
        Object rawNodeSet = args.get(0);
        if (rawNodeSet instanceof Collection) {
            nodes = new ArrayList((Collection)rawNodeSet);
        } else if (rawNodeSet.getClass().isArray()) {
            nodes = Arrays.asList((Object[])rawNodeSet);
        } else {
            return Collections.singleton(rawNodeSet);
        }
        try {
            Comparator comparator = this.createComparator(args.subList(1, args.size()));
            Collections.sort(nodes, comparator);
            return nodes;
        }
        catch (XPathException e) {
            throw new XPathRuntimeException(e);
        }
    }

    private Comparator createComparator(List keyExprList) throws XPathException {
        XPath xpath = this.createXPathEnv();
        Comparator[] comparators = new Comparator[keyExprList.size()];
        int i = 0;
        while (i < comparators.length) {
            String ordering;
            String keyExpr = XPathUtil.xpathString(keyExprList.get(i));
            int orderIdx = keyExpr.lastIndexOf("::");
            String string = ordering = orderIdx >= 0 ? keyExpr.substring(orderIdx) : null;
            comparators[i] = "::descending".equalsIgnoreCase(ordering) ? new DescendingXPathComparator(xpath.compile(keyExpr.substring(0, orderIdx))) : ("::ascending".equalsIgnoreCase(ordering) ? new XPathComparator(xpath.compile(keyExpr.substring(0, orderIdx))) : new XPathComparator(xpath.compile(keyExpr)));
            ++i;
        }
        return comparators.length == 1 ? comparators[0] : new ChainedComparator(comparators);
    }

    private XPath createXPathEnv() {
        XPath xpath = XPathFactory.newInstance().newXPath(this.context.getAnnotationManager());
        xpath.setXPathVariableResolver(this.context.getVariableResolver());
        xpath.setXPathFunctionResolver(this.context.getFunctionResolver());
        return xpath;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private static class ChainedComparator
    implements Comparator {
        private final Comparator[] comparatorChain;

        public ChainedComparator(Comparator[] comparatorChain) {
            this.comparatorChain = comparatorChain;
        }

        public int compare(Object o1, Object o2) {
            int i = 0;
            while (i < this.comparatorChain.length) {
                int result = this.comparatorChain[i].compare(o1, o2);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }
    }

    private static class DescendingXPathComparator
    extends XPathComparator {
        public DescendingXPathComparator(XPathExpression xpathExpr) {
            super(xpathExpr);
        }

        public int compare(Object o1, Object o2) {
            return super.compare(o2, o1);
        }
    }

    private static class XPathComparator
    implements Comparator {
        private final XPathExpression xpathExpr;

        public XPathComparator(XPathExpression xpathExpr) {
            this.xpathExpr = xpathExpr;
        }

        public int compare(Object o1, Object o2) {
            Object r1 = this.xpathExpr.evaluate(o1);
            Object r2 = this.xpathExpr.evaluate(o2);
            if (r1 instanceof Comparable) {
                return ((Comparable)r1).compareTo(r2);
            }
            String s1 = XPathUtil.xpathString(r1);
            String s2 = XPathUtil.xpathString(r2);
            return s1.compareTo(s2);
        }
    }
}

