/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.List;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathUtil;

public class NormalizeSpaceFunction
implements XPathFunction,
XPathFunctionWithContext {
    public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("normalize-space", null, new NormalizeSpaceFunction(), 0, 1);
    private Context context;

    public Object evaluate(List args) {
        String arg = args.size() == 0 ? XPathUtil.xpathString(this.context.getContextNode()) : XPathUtil.xpathString(args.get(0));
        return NormalizeSpaceFunction.normalizeSpace(arg);
    }

    public static String normalizeSpace(String input) {
        int inputLength = input.length();
        StringBuffer result = new StringBuffer(inputLength);
        int wsRunStart = -1;
        int i = 0;
        while (i < inputLength) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) {
                if (wsRunStart == -1) {
                    wsRunStart = i;
                }
            } else {
                if (wsRunStart > 0) {
                    result.append(' ');
                }
                wsRunStart = -1;
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

