/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jet.taglib.TagUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public final class UserRegionHelper
implements IWriterListener {
    private static final String INITIALCODE_POSITION_CATEGORY = "org.eclipse.jet.internal.taglib.control.initialcode";
    private static final String ROUNDTRIP_LISTENER_CATEGORY = "org.eclipse.jet.internal.taglib.control.userRegion";
    private static final String USERREGION_POSITION_CATEGORY = "org.eclipse.jet.internal.taglib.control.userRegion";
    static /* synthetic */ Class class$0;

    private UserRegionHelper() {
    }

    public void finalizeContent(JET2Writer writer, Object file) {
        if (file instanceof IFile && writer instanceof BufferedJET2Writer) {
            IFile iFile = (IFile)file;
            BufferedJET2Writer bufferedwriter = (BufferedJET2Writer)writer;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDocument document = (IDocument)bufferedwriter.getAdapter((Class)clazz);
            if (iFile.exists() && document != null) {
                String fileContents;
                try {
                    fileContents = TagUtil.getContents(iFile.getLocation());
                }
                catch (CoreException coreException) {
                    return;
                }
                try {
                    Position[] rtPositions = document.getPositions("org.eclipse.jet.internal.taglib.control.userRegion");
                    Position[] icPositions = document.getPositions(INITIALCODE_POSITION_CATEGORY);
                    int i = 0;
                    while (i < rtPositions.length) {
                        Position userRegionPosition = rtPositions[i];
                        Position initialCodePosition = this.findContainedInitialCodePosition(userRegionPosition, icPositions);
                        if (initialCodePosition != null) {
                            String existingRegion;
                            int existingEndMarkerOffset;
                            String unmodifiedMarker = initialCodePosition instanceof PositionWithUnmodifiedMarker ? ((PositionWithUnmodifiedMarker)initialCodePosition).unmodifiedMarker : null;
                            Position beginMarkerPosition = new Position(userRegionPosition.offset, initialCodePosition.offset - userRegionPosition.offset);
                            int endMarkerOffset = initialCodePosition.offset + initialCodePosition.length;
                            Position endMarkerPosition = new Position(endMarkerOffset, userRegionPosition.offset + userRegionPosition.length - endMarkerOffset);
                            String beginMarker = bufferedwriter.getContent(beginMarkerPosition.offset, beginMarkerPosition.length);
                            String endMarker = bufferedwriter.getContent(endMarkerPosition.offset, endMarkerPosition.length);
                            int existingRegionOffset = fileContents.indexOf(beginMarker);
                            if (!(existingRegionOffset == -1 || (existingEndMarkerOffset = fileContents.indexOf(endMarker, existingRegionOffset + beginMarker.length())) == -1 || (existingRegion = fileContents.substring(existingRegionOffset, existingEndMarkerOffset + endMarker.length())).equals(bufferedwriter.getContent(userRegionPosition.offset, userRegionPosition.length)) || unmodifiedMarker != null && existingRegion.indexOf(unmodifiedMarker) != -1)) {
                                bufferedwriter.replaceContent(userRegionPosition.offset, userRegionPosition.length, existingRegion);
                            }
                        }
                        ++i;
                    }
                }
                catch (BadPositionCategoryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Position findContainedInitialCodePosition(Position userRegionPosition, Position[] icPositions) {
        int i = 0;
        while (i < icPositions.length) {
            Position pos = icPositions[i];
            if (pos.offset + pos.length > userRegionPosition.offset + userRegionPosition.length) {
                return null;
            }
            if (userRegionPosition.offset <= pos.offset) {
                return pos;
            }
            ++i;
        }
        return null;
    }

    public void postCommitContent(JET2Writer writer, Object file) {
    }

    public static void markInitialCode(JET2Writer out, int initialCodeStart, int initialCodeEnd, String unmodifiedMarker) {
        IDocument document;
        if (!(out instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        BufferedJET2Writer bufferedWriter = (BufferedJET2Writer)out;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((document = (IDocument)bufferedWriter.getAdapter((Class)clazz)) == null) {
            throw new NullPointerException();
        }
        DocumentHelper.installPositionCategory(document, INITIALCODE_POSITION_CATEGORY);
        try {
            if (unmodifiedMarker == null) {
                document.addPosition(INITIALCODE_POSITION_CATEGORY, new Position(initialCodeStart, initialCodeEnd - initialCodeStart));
            } else {
                document.addPosition(INITIALCODE_POSITION_CATEGORY, (Position)new PositionWithUnmodifiedMarker(initialCodeStart, initialCodeEnd - initialCodeStart, unmodifiedMarker));
            }
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException();
        }
        catch (BadPositionCategoryException e) {
            throw new RuntimeException(e);
        }
    }

    public static void markInitialCode(JET2Writer out, int initialCodeStart, int initialCodeEnd) {
        UserRegionHelper.markInitialCode(out, initialCodeStart, initialCodeEnd, null);
    }

    public static void markUserRegion(JET2Writer out, int regionStart, int regionEnd) {
        IDocument document;
        if (!(out instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        BufferedJET2Writer bufferedWriter = (BufferedJET2Writer)out;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((document = (IDocument)bufferedWriter.getAdapter((Class)clazz)) == null) {
            throw new NullPointerException();
        }
        DocumentHelper.installPositionCategory(document, INITIALCODE_POSITION_CATEGORY);
        DocumentHelper.installPositionCategory(document, "org.eclipse.jet.internal.taglib.control.userRegion");
        try {
            document.addPosition("org.eclipse.jet.internal.taglib.control.userRegion", new Position(regionStart, regionEnd - regionStart));
            out.addEventListener("org.eclipse.jet.internal.taglib.control.userRegion", (IWriterListener)new UserRegionHelper());
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException();
        }
        catch (BadPositionCategoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static class PositionWithUnmodifiedMarker
    extends Position {
        public final String unmodifiedMarker;

        public PositionWithUnmodifiedMarker(int offset, int length, String unmodifiedMarker) {
            super(offset, length);
            this.unmodifiedMarker = unmodifiedMarker;
        }
    }
}

