/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.internal;

import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class JDTUtil {
    private static final Pattern patternNamespace = Pattern.compile("::");
    private static final Pattern patternSlash = Pattern.compile("/");

    public static IStorage findStorage(IJavaProject project, ResourceID id, boolean searchJars) {
        IPath p = JDTUtil.path(id);
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IStorage storage;
                IPackageFragmentRoot root = roots[i];
                if (!root.isArchive()) {
                    IResource r;
                    IStorage member;
                    IResource resource;
                    IFolder rootFolder = null;
                    IResource correspondingResource = root.getCorrespondingResource();
                    if (correspondingResource instanceof IFolder) {
                        rootFolder = (IFolder)correspondingResource;
                    } else if (root instanceof ExternalPackageFragmentRoot && (resource = ((ExternalPackageFragmentRoot)root).resource()) instanceof IFolder && (member = (IStorage)(rootFolder = (IFolder)resource).findMember(p)) != null) {
                        return member;
                    }
                    if (rootFolder != null && (r = project.getProject().findMember(rootFolder.getProjectRelativePath().append(p))) instanceof IFile) {
                        return (IFile)r;
                    }
                } else if (searchJars && (storage = JDTUtil.loadFromJar(id, root)) != null) {
                    return storage;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            XtendLog.logInfo(e);
        }
        return null;
    }

    public static IStorage loadFromJar(ResourceID id, IPackageFragmentRoot root) throws JavaModelException {
        if (root instanceof JarPackageFragmentRoot) {
            ZipFile zipFile;
            JarPackageFragmentRoot jar = (JarPackageFragmentRoot)root;
            try {
                zipFile = jar.getJar();
            }
            catch (CoreException e) {
                XtendLog.logError(e);
                return null;
            }
            ZipEntry entry = zipFile.getEntry(id.toFileName());
            if (entry != null && zipFile != null) {
                return new ZipEntryStorage(zipFile, entry);
            }
        }
        return null;
    }

    public static ResourceID findXtendXpandResourceID(IJavaProject project, IStorage file) {
        if (file == null) {
            return null;
        }
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getPath().isPrefixOf(file.getFullPath())) {
                    IPath shortOne = file.getFullPath().removeFirstSegments(root.getPath().segmentCount());
                    String ns = shortOne.removeFileExtension().toString();
                    ns = patternSlash.matcher(ns).replaceAll("::");
                    return new ResourceID(ns, shortOne.getFileExtension());
                }
                ++i;
            }
        }
        catch (JavaModelException e1) {
            XtendLog.logInfo(e1);
        }
        return null;
    }

    public static IJavaProject getJProject(IStorage s) {
        if (s instanceof IFile) {
            return JavaCore.create((IProject)((IFile)s).getProject());
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IJavaProject p = JavaCore.create((IProject)project);
            if (p.exists()) {
                try {
                    IPackageFragmentRoot[] roots = p.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        IPackageFragmentRoot root = roots[j];
                        if (root.getPath().isPrefixOf(s.getFullPath())) {
                            return p;
                        }
                        ++j;
                    }
                }
                catch (JavaModelException e) {
                    XtendLog.logError(e);
                }
            }
            ++i;
        }
        return null;
    }

    private static IPath path(ResourceID id) {
        return new Path(String.valueOf(patternNamespace.matcher(id.name).replaceAll("/")) + "." + id.extension);
    }

    public static String getQualifiedName(IStorage source) {
        ResourceID id = JDTUtil.findXtendXpandResourceID(JDTUtil.getJProject(source), source);
        if (id != null) {
            return id.name;
        }
        return null;
    }
}

