/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Case;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchExpression
extends Expression {
    private Expression switchExpr = null;
    private Expression defaultExpr = null;
    private List<Case> cases = null;

    public SwitchExpression(int start, int end, int line, int startOffset, int endOffset, Expression switchExpr, List<Case> cases, Expression defaultExpr) {
        super(start, end, line, startOffset, endOffset);
        this.switchExpr = switchExpr;
        this.cases = cases;
        this.defaultExpr = defaultExpr;
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Object switchVal = Boolean.TRUE;
        if (this.switchExpr != null) {
            switchVal = this.switchExpr.evaluate(ctx);
        }
        for (Case c : this.cases) {
            Object caseCondVal = c.getCondition().evaluate(ctx);
            if ((switchVal == null || !switchVal.equals(caseCondVal)) && switchVal != caseCondVal) continue;
            return c.getThenPart().evaluate(ctx);
        }
        return this.defaultExpr.evaluate(ctx);
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EDataType condEClassifier = EcorePackage.eINSTANCE.getEBoolean();
        if (this.switchExpr != null) {
            condEClassifier = this.switchExpr.analyze(ctx, issues);
        }
        if (condEClassifier == null) {
            return null;
        }
        Object returnEClassifier = this.defaultExpr.analyze(ctx, issues);
        if (returnEClassifier == null) {
            return null;
        }
        for (Case c : this.cases) {
            EClassifier caseThenEClassifier;
            EClassifier caseCondEClassifier = c.getCondition().analyze(ctx, issues);
            if (caseCondEClassifier != null && !BuiltinMetaModel.isAssignableFrom((EClassifier)condEClassifier, caseCondEClassifier)) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.INCOMPATIBLE_TYPES, String.valueOf(condEClassifier.getName()) + " expected!", c.getCondition()));
            }
            if ((caseThenEClassifier = c.getThenPart().analyze(ctx, issues)) == null || BuiltinMetaModel.isAssignableFrom(returnEClassifier, caseThenEClassifier)) continue;
            returnEClassifier = BuiltinMetaModel.isAssignableFrom(caseThenEClassifier, returnEClassifier) ? caseThenEClassifier : EcorePackage.eINSTANCE.getEJavaObject();
        }
        return returnEClassifier;
    }

    public List<Case> getCases() {
        if (this.cases == null) {
            return Collections.emptyList();
        }
        return this.cases;
    }

    public Expression getDefaultExpr() {
        return this.defaultExpr;
    }

    public Expression getSwitchExpr() {
        return this.switchExpr;
    }
}

