/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.internal.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileChangeEventType;

public class FileChangeEvent {
    private FileChangeEventType eventType;
    private IFile oldFile;
    private IFile file;

    public FileChangeEvent(FileChangeEventType anEventType, IFile aFile) {
        assert (anEventType == FileChangeEventType.CHANGED || anEventType == FileChangeEventType.DELETED);
        this.setEventType(anEventType);
        this.setFile(aFile);
        this.setOldFile(null);
    }

    public FileChangeEvent(FileChangeEventType anEventType, IFile anOldFile, IFile newFile) {
        assert (anEventType == FileChangeEventType.RENAMED || anEventType == FileChangeEventType.MOVED);
        this.setEventType(anEventType);
        this.setFile(newFile);
        this.setOldFile(anOldFile);
    }

    public FileChangeEventType getEventType() {
        return this.eventType;
    }

    public IFile getFile() {
        return this.file;
    }

    public IFile getOldFile() {
        return this.oldFile;
    }

    private void setEventType(FileChangeEventType type) {
        this.eventType = type;
    }

    private void setFile(IFile aFile) {
        this.file = aFile;
    }

    private void setOldFile(IFile aFile) {
        this.oldFile = aFile;
    }
}

