/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import org.eclipse.gmf.internal.xpand.ast.XpandAnalyzable;
import org.eclipse.gmf.internal.xpand.ast.XpandEvaluatable;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;

public abstract class Statement
extends SyntaxElement
implements XpandAnalyzable,
XpandEvaluatable {
    public Statement(int start, int end, int line, int startOffset, int endOffset) {
        super(start, end, line, startOffset, endOffset);
    }

    public final void evaluate(XpandExecutionContext ctx) {
        try {
            this.notifyEnter(ctx);
            ctx.getOutput().enterStatement(this);
            this.evaluateInternal(ctx);
            ctx.getOutput().exitStatement(null);
        }
        finally {
            this.notifyLeave(ctx);
        }
    }

    protected abstract void evaluateInternal(XpandExecutionContext var1);

    private void notifyEnter(XpandExecutionContext ctx) {
        EvaluationListener l = ctx.getEvaluationListener();
        if (l != null) {
            l.enter(this, ctx);
        }
    }

    private void notifyLeave(XpandExecutionContext ctx) {
        EvaluationListener l = ctx.getEvaluationListener();
        if (l != null) {
            l.leave(this, ctx);
        }
    }
}

