/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.log.AbstractLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;

public class FileLogHandler
extends AbstractLogHandler {
    private File logFile;

    public FileLogHandler(File logFile, OMLogger.Level logLevel) {
        super(logLevel);
        this.logFile = logFile;
    }

    public FileLogHandler(File logFile) {
        this.logFile = logFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    protected void writeLog(OMLogger logger, OMLogger.Level level, String msg, Throwable t) throws Throwable {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.logFile, true);
            PrintStream stream = new PrintStream(fos);
            stream.println(String.valueOf(FileLogHandler.toString(level)) + " " + msg);
            if (t != null) {
                IOUtil.print(t, stream);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(fos);
            throw throwable;
        }
        IOUtil.close(fos);
    }
}

