/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.dml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.dml.IDBParameter;
import org.eclipse.net4j.db.dml.IDBStatement;
import org.eclipse.net4j.internal.db.dml.DBParameter;

public class DBStatement
implements IDBStatement {
    private static final DBParameter[] NO_PARAMETERS = new DBParameter[0];
    private List<DBParameter> parameters;
    private List<Object> sequence = new ArrayList<Object>();

    public IDBParameter addParameter(DBType type) {
        int position = 0;
        if (this.parameters == null) {
            this.parameters = new ArrayList<DBParameter>();
        } else {
            position = this.parameters.size();
        }
        DBParameter parameter = new DBParameter(this, position, type);
        this.parameters.add(parameter);
        return parameter;
    }

    public IDBParameter addParameter(IDBField field) {
        return this.addParameter(field.getType());
    }

    public DBParameter[] getParameters() {
        if (this.parameters == null) {
            return NO_PARAMETERS;
        }
        return this.parameters.toArray(new DBParameter[this.parameters.size()]);
    }

    public void addSQL(String literal) {
        int tailPos = this.sequence.size() - 1;
        Object tail = this.sequence.get(tailPos);
        if (tail instanceof String) {
            this.sequence.set(tailPos, String.valueOf((String)tail) + literal);
        } else {
            this.sequence.add(literal);
        }
    }

    public void addSQL(IDBParameter parameter) {
        this.sequence.add(parameter);
    }

    public void addSQL(IDBSchemaElement schemaElement) {
        this.addSQL(schemaElement.getName());
    }

    public String getSQL() {
        StringBuilder builder = new StringBuilder();
        for (Object element : this.sequence) {
            if (element instanceof IDBParameter) {
                builder.append("?");
                continue;
            }
            builder.append(element);
        }
        return builder.toString();
    }
}

