/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

class ComposedImageDescriptor
extends CompositeImageDescriptor {
    protected ComposedImage composedImage;
    protected List imageDatas;

    public ComposedImageDescriptor(ComposedImage composedImage) {
        this.composedImage = composedImage;
    }

    public void drawCompositeImage(int width, int height) {
        ComposedImage.Size size = new ComposedImage.Size();
        size.width = width;
        size.height = height;
        Iterator images = this.imageDatas.iterator();
        Iterator points = this.composedImage.getDrawPoints(size).iterator();
        while (points.hasNext()) {
            ComposedImage.Point point = (ComposedImage.Point)points.next();
            this.drawImage((ImageData)images.next(), point.x, point.y);
        }
    }

    public Point getSize() {
        List images = this.composedImage.getImages();
        this.imageDatas = new ArrayList(images.size());
        ArrayList<ComposedImage.Size> sizes = new ArrayList<ComposedImage.Size>(images.size());
        Iterator i = images.iterator();
        while (i.hasNext()) {
            Image image = ExtendedImageRegistry.getInstance().getImage(i.next());
            ImageData imageData = image.getImageData();
            this.imageDatas.add(imageData);
            ComposedImage.Size size = new ComposedImage.Size();
            size.width = imageData.width;
            size.height = imageData.height;
            sizes.add(size);
        }
        ComposedImage.Size result = this.composedImage.getSize(sizes);
        return new Point(result.width, result.height);
    }
}

