/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.demos;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Queue;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AbstractRestServlet
extends HttpServlet {
    protected static final String __DEFAULT_APPID = "Webtide81-adf4-4f0a-ad58-d91e41bbe85";
    protected static final String STYLE = "<style type='text/css'>  img.thumb:hover {height:50px}  img.thumb {vertical-align:text-top}  span.red {color: #ff0000}  span.green {color: #00ff00}  iframe {border: 0px}</style>";
    protected static final String ITEMS_PARAM = "items";
    protected static final String APPID_PARAM = "appid";
    protected String _appid;

    public void init(ServletConfig servletConfig) throws ServletException {
        this._appid = servletConfig.getInitParameter(APPID_PARAM) == null ? __DEFAULT_APPID : servletConfig.getInitParameter(APPID_PARAM);
    }

    public static String sanitize(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c > '\u001f' && c != '<' && c != '&') continue;
            chars[i] = 63;
        }
        return String.valueOf(chars);
    }

    protected String restURL(String item) {
        try {
            return "https://open.api.ebay.com/shopping?MaxEntries=3&appid=" + this._appid + "&version=573&siteid=0&callname=FindItems&responseencoding=JSON&QueryKeywords=" + URLEncoder.encode(item, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateThumbs(Queue<Map<String, Object>> results) {
        StringBuilder thumbs = new StringBuilder();
        for (Map map : results) {
            if (!map.containsKey("GalleryURL")) continue;
            thumbs.append("<a href=\"").append(map.get("ViewItemURLForNaturalSearch")).append("\">");
            thumbs.append("<img class='thumb' border='1px' height='25px' src='").append(map.get("GalleryURL")).append("'").append(" title='").append(map.get("Title")).append("'").append("/>");
            thumbs.append("</a>&nbsp;");
        }
        return thumbs.toString();
    }

    protected String ms(long nano) {
        BigDecimal dec = new BigDecimal(nano);
        return dec.divide(new BigDecimal(1000000L)).setScale(1, RoundingMode.UP).toString();
    }

    protected int width(long nano) {
        int w = (int)((nano + 999999L) / 5000000L);
        if (w == 0) {
            w = 2;
        }
        return w;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

