/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.common.project.CompiledTransformation;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CompletionProposalUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionProposal;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.collectors.AbstractCollector;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportModuleCollector
extends AbstractCollector {
    @Override
    protected boolean isApplicableInternal(QvtCompletionData data) {
        IToken leftToken = data.getLeftToken();
        return leftToken.getKind() == 128;
    }

    @Override
    public void addPropoposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        this.addLocalModulesProposals(proposals, data);
        this.addDeployedModulesProposals(proposals, data);
    }

    private void addLocalModulesProposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        EclipseFile compiledFile = data.getCFile();
        CFolder rootFolder = compiledFile.getParent();
        this.addFolderProposals(rootFolder, (CFile)compiledFile, proposals, data, new String[0]);
    }

    private void addFolderProposals(CFolder folder, CFile excludedFile, Collection<ICompletionProposal> proposals, QvtCompletionData data, String[] path) {
        try {
            CResource member;
            CResource[] members;
            CResource[] cResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                member = cResourceArray[n2];
                if (member instanceof CFile) {
                    CFile file = (CFile)member;
                    if ((path.length != 0 || !file.getName().equals(excludedFile.getName())) && "qvto".equals(file.getExtension())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String[] stringArray = path;
                        int n3 = path.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String pathElement = stringArray[n4];
                            stringBuilder.append(pathElement).append('.');
                            ++n4;
                        }
                        stringBuilder.append(file.getUnitName());
                        QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(stringBuilder.toString(), "cat-class", data);
                        CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
                    }
                }
                ++n2;
            }
            cResourceArray = members;
            n = members.length;
            n2 = 0;
            while (n2 < n) {
                member = cResourceArray[n2];
                if (member instanceof CFolder) {
                    CFolder subfolder = (CFolder)member;
                    String[] newPath = new String[path.length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[newPath.length - 1] = subfolder.getName();
                    this.addFolderProposals(subfolder, excludedFile, proposals, data, newPath);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    private void addDeployedModulesProposals(Collection<ICompletionProposal> proposals, QvtCompletionData data) {
        List transformations = QvtTransformationRegistry.getInstance().getTransformations(TransformationRegistry.EMPTY_FILTER);
        for (CompiledTransformation transformation : transformations) {
            String proposalString = transformation.getId();
            QvtCompletionProposal info = CompletionProposalUtil.createCompletionProposal(proposalString, "cat-class", data);
            CompletionProposalUtil.addProposalIfNecessary(proposals, info, data);
        }
    }
}

