/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.project;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.project.JavaProjectUtil;
import org.eclipse.m2m.internal.qvt.oml.common.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.project.NatureUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtil {
    public static final String PDE_NATURE = "org.eclipse.pde.PluginNature";

    private PluginUtil() {
    }

    public static ModelHelper<IPluginModel> getModel(IProject project) throws MdaException {
        IFile pluginXmlFile = PluginUtil.getModelFile(project);
        if (!pluginXmlFile.exists()) {
            PluginUtil.createModelFile(pluginXmlFile);
        }
        ModelHelper<IPluginModel> model = PluginUtil.createPluginModel(pluginXmlFile);
        try {
            model.model().load();
        }
        catch (CoreException e) {
            throw new MdaException(e);
        }
        if (!model.model().isLoaded()) {
            throw new MdaException(NLS.bind((String)Messages.PluginUtil_PluginModelLoadError, (Object)pluginXmlFile));
        }
        return model;
    }

    public static IPlugin getPlugin(IProject project) throws MdaException {
        return PluginUtil.getModel(project).model().getPlugin();
    }

    private static void createModelFile(IFile file) {
        ModelHelper<IPluginModel> model = PluginUtil.createPluginModel(file);
        IPluginBase pluginBase = model.model().getPluginBase(true);
        try {
            pluginBase.setSchemaVersion(TargetPlatformHelper.getTargetVersion() < 3.2 ? "3.0" : "3.2");
        }
        catch (CoreException coreException) {}
        model.save();
    }

    private static IFile getModelFile(IProject project) {
        IPath manifestPath = project.getFullPath().append("plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(manifestPath);
        return file;
    }

    public static void addPluginNature(IProject project) throws CoreException {
        NatureUtils.addNature(project, PDE_NATURE);
    }

    public static ModelHelper<IPluginModel> createPluginModel(IFile file) {
        return new ModelHelper<WorkspacePluginModel>(new WorkspacePluginModel(file, false));
    }

    public static IPluginModelBase findPluginModelByProject(IProject project) {
        return PDECore.getDefault().getModelManager().findModel(project);
    }

    public static IPluginModelBase findPluginModelByID(String importID) {
        return PDECore.getDefault().getModelManager().findModel(importID);
    }

    public static String makeId(String name) {
        StringBuffer id = new StringBuffer();
        int i = 0;
        int len = name.length();
        while (i < len) {
            int ch = name.charAt(i);
            if (!(ch >= 65 && 90 >= ch || ch >= 97 && 122 >= ch || ch >= 48 && 57 >= ch || ch == 95 || i != 0 && i != name.length() - 1 && ch == 46)) {
                ch = 95;
            }
            id.append((char)ch);
            ++i;
        }
        return id.toString();
    }

    private static String getLibraryName(String projectName) {
        int lastDot = projectName.lastIndexOf(".");
        String libraryName = lastDot != -1 ? projectName.substring(lastDot + 1) : projectName;
        return String.valueOf(libraryName) + ".jar";
    }

    private static void createBuildPropertiesFile(IFile file) throws CoreException {
        ModelHelper<WorkspaceBuildModel> model = new ModelHelper<WorkspaceBuildModel>(new WorkspaceBuildModel(file));
        IBuildModelFactory factory = ((IBuildModel)model.model()).getFactory();
        IBuildEntry binEntry = factory.createEntry("bin.includes");
        binEntry.addToken("plugin.xml");
        String libraryName = PluginUtil.getLibraryName(file.getProject().getName());
        binEntry.addToken(libraryName);
        IBuildEntry entry = factory.createEntry("source." + libraryName);
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        String srcFolder = PluginUtil.getSourceFolderName(javaProject);
        if (srcFolder.length() > 0) {
            entry.addToken(new Path(srcFolder).addTrailingSeparator().toString());
        } else {
            entry.addToken(".");
        }
        ((IBuildModel)model.model()).getBuild().add(entry);
        entry = factory.createEntry("output." + libraryName);
        String outputFolder = PluginUtil.getOutputFolderName(javaProject);
        if (outputFolder.length() > 0) {
            entry.addToken(new Path(outputFolder).addTrailingSeparator().toString());
        } else {
            entry.addToken(".");
        }
        ((IBuildModel)model.model()).getBuild().add(entry);
        ((IBuildModel)model.model()).getBuild().add(binEntry);
        model.save();
    }

    private static String getSourceFolderName(IJavaProject javaProject) {
        try {
            return JavaProjectUtil.getSourceFolderName(javaProject).toOSString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getOutputFolderName(IJavaProject javaProject) {
        try {
            return JavaProjectUtil.getOutputFolderName(javaProject).toOSString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ModelHelper<T extends IModel> {
        private T model;

        public ModelHelper(T wrappedModel) {
            assert (wrappedModel != null);
            this.model = wrappedModel;
        }

        public T model() {
            return this.model;
        }

        public void save() {
            if (this.model instanceof IEditableModel) {
                IEditableModel em = (IEditableModel)this.model;
                em.save();
            }
        }
    }
}

