/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BaggageTest
extends Arquillian {
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter spanExporter;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class})).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=in-memory"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
        }
    }

    @Test
    void baggage() {
        WebTarget target = ClientBuilder.newClient().target(this.url.toString()).path("baggage");
        Response response = target.request().header("baggage", (Object)"user=naruto").get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        this.spanExporter.getFinishedSpanItems(2);
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @Path(value="/baggage")
    public static class BaggageResource {
        @Inject
        private Baggage baggage;

        @GET
        public Response baggage() {
            try {
                Assert.assertEquals((String)this.baggage.getEntryValue("user"), (String)"naruto");
                return Response.ok().build();
            }
            catch (Throwable e) {
                System.err.println("Baggage Resource Exception:");
                e.printStackTrace();
                throw e;
            }
        }
    }
}

