/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.mount.Driver;
import org.mandas.docker.client.messages.mount.VolumeOptions;

final class ImmutableVolumeOptions
implements VolumeOptions {
    @Nullable
    private final Boolean noCopy;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final Driver driverConfig;

    private ImmutableVolumeOptions(@Nullable Boolean noCopy, @Nullable Map<String, String> labels, @Nullable Driver driverConfig) {
        this.noCopy = noCopy;
        this.labels = labels;
        this.driverConfig = driverConfig;
    }

    @Override
    @JsonProperty(value="NoCopy")
    @Nullable
    public Boolean noCopy() {
        return this.noCopy;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="DriverConfig")
    @Nullable
    public Driver driverConfig() {
        return this.driverConfig;
    }

    public final ImmutableVolumeOptions withNoCopy(@Nullable Boolean value) {
        if (Objects.equals(this.noCopy, value)) {
            return this;
        }
        return new ImmutableVolumeOptions(value, this.labels, this.driverConfig);
    }

    public final ImmutableVolumeOptions withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableVolumeOptions.createUnmodifiableMap(true, false, entries);
        return new ImmutableVolumeOptions(this.noCopy, newValue, this.driverConfig);
    }

    public final ImmutableVolumeOptions withDriverConfig(@Nullable Driver value) {
        if (this.driverConfig == value) {
            return this;
        }
        return new ImmutableVolumeOptions(this.noCopy, this.labels, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVolumeOptions && this.equalsByValue((ImmutableVolumeOptions)another);
    }

    private boolean equalsByValue(ImmutableVolumeOptions another) {
        return Objects.equals(this.noCopy, another.noCopy) && Objects.equals(this.labels, another.labels) && Objects.equals(this.driverConfig, another.driverConfig);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.noCopy);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.driverConfig);
        return h;
    }

    public String toString() {
        return "VolumeOptions{noCopy=" + this.noCopy + ", labels=" + String.valueOf(this.labels) + ", driverConfig=" + String.valueOf(this.driverConfig) + "}";
    }

    public static ImmutableVolumeOptions copyOf(VolumeOptions instance) {
        if (instance instanceof ImmutableVolumeOptions) {
            return (ImmutableVolumeOptions)instance;
        }
        return ImmutableVolumeOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements VolumeOptions.Builder {
        private Boolean noCopy;
        private Map<String, String> labels = null;
        private Driver driverConfig;

        private Builder() {
        }

        public final Builder from(VolumeOptions instance) {
            Driver driverConfigValue;
            Map<String, String> labelsValue;
            Objects.requireNonNull(instance, "instance");
            Boolean noCopyValue = instance.noCopy();
            if (noCopyValue != null) {
                this.noCopy(noCopyValue);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            if ((driverConfigValue = instance.driverConfig()) != null) {
                this.driverConfig(driverConfigValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="NoCopy")
        public final Builder noCopy(@Nullable Boolean noCopy) {
            this.noCopy = noCopy;
            return this;
        }

        @Override
        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @Override
        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="DriverConfig")
        public final Builder driverConfig(@Nullable Driver driverConfig) {
            this.driverConfig = driverConfig;
            return this;
        }

        @Override
        public ImmutableVolumeOptions build() {
            return new ImmutableVolumeOptions(this.noCopy, this.labels == null ? null : ImmutableVolumeOptions.createUnmodifiableMap(false, false, this.labels), this.driverConfig);
        }
    }
}

