/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.CaConfig;
import org.mandas.docker.client.messages.swarm.ExternalCa;

final class ImmutableCaConfig
implements CaConfig {
    @Nullable
    private final Long nodeCertExpiry;
    @Nullable
    private final List<ExternalCa> externalCas;

    private ImmutableCaConfig(@Nullable Long nodeCertExpiry, @Nullable List<ExternalCa> externalCas) {
        this.nodeCertExpiry = nodeCertExpiry;
        this.externalCas = externalCas;
    }

    @Override
    @JsonProperty(value="NodeCertExpiry")
    @Nullable
    public Long nodeCertExpiry() {
        return this.nodeCertExpiry;
    }

    @Override
    @JsonProperty(value="ExternalCAs")
    @Nullable
    public List<ExternalCa> externalCas() {
        return this.externalCas;
    }

    public final ImmutableCaConfig withNodeCertExpiry(@Nullable Long value) {
        if (Objects.equals(this.nodeCertExpiry, value)) {
            return this;
        }
        return new ImmutableCaConfig(value, this.externalCas);
    }

    public final ImmutableCaConfig withExternalCas(ExternalCa ... elements) {
        if (elements == null) {
            if (this.externalCas == null) {
                return this;
            }
            return new ImmutableCaConfig(this.nodeCertExpiry, null);
        }
        List<ExternalCa> newValue = ImmutableCaConfig.createUnmodifiableList(false, ImmutableCaConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCaConfig(this.nodeCertExpiry, newValue);
    }

    public final ImmutableCaConfig withExternalCas(@Nullable Iterable<? extends ExternalCa> elements) {
        if (this.externalCas == elements) {
            return this;
        }
        List<ExternalCa> newValue = elements == null ? null : ImmutableCaConfig.createUnmodifiableList(false, ImmutableCaConfig.createSafeList(elements, true, false));
        return new ImmutableCaConfig(this.nodeCertExpiry, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCaConfig && this.equalsByValue((ImmutableCaConfig)another);
    }

    private boolean equalsByValue(ImmutableCaConfig another) {
        return Objects.equals(this.nodeCertExpiry, another.nodeCertExpiry) && Objects.equals(this.externalCas, another.externalCas);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.nodeCertExpiry);
        h += (h << 5) + Objects.hashCode(this.externalCas);
        return h;
    }

    public String toString() {
        return "CaConfig{nodeCertExpiry=" + this.nodeCertExpiry + ", externalCas=" + String.valueOf(this.externalCas) + "}";
    }

    public static ImmutableCaConfig copyOf(CaConfig instance) {
        if (instance instanceof ImmutableCaConfig) {
            return (ImmutableCaConfig)instance;
        }
        return ImmutableCaConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements CaConfig.Builder {
        private Long nodeCertExpiry;
        private List<ExternalCa> externalCas = null;

        private Builder() {
        }

        public final Builder from(CaConfig instance) {
            List<ExternalCa> externalCasValue;
            Objects.requireNonNull(instance, "instance");
            Long nodeCertExpiryValue = instance.nodeCertExpiry();
            if (nodeCertExpiryValue != null) {
                this.nodeCertExpiry(nodeCertExpiryValue);
            }
            if ((externalCasValue = instance.externalCas()) != null) {
                this.addAllExternalCas(externalCasValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="NodeCertExpiry")
        public final Builder nodeCertExpiry(@Nullable Long nodeCertExpiry) {
            this.nodeCertExpiry = nodeCertExpiry;
            return this;
        }

        public final Builder externalCa(ExternalCa element) {
            if (this.externalCas == null) {
                this.externalCas = new ArrayList<ExternalCa>();
            }
            this.externalCas.add(Objects.requireNonNull(element, "externalCas element"));
            return this;
        }

        public final Builder externalCas(ExternalCa ... elements) {
            if (this.externalCas == null) {
                this.externalCas = new ArrayList<ExternalCa>();
            }
            for (ExternalCa element : elements) {
                this.externalCas.add(Objects.requireNonNull(element, "externalCas element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="ExternalCAs")
        public final Builder externalCas(@Nullable Iterable<? extends ExternalCa> elements) {
            if (elements == null) {
                this.externalCas = null;
                return this;
            }
            this.externalCas = new ArrayList<ExternalCa>();
            return this.addAllExternalCas(elements);
        }

        public final Builder addAllExternalCas(Iterable<? extends ExternalCa> elements) {
            Objects.requireNonNull(elements, "externalCas element");
            if (this.externalCas == null) {
                this.externalCas = new ArrayList<ExternalCa>();
            }
            for (ExternalCa externalCa : elements) {
                this.externalCas.add(Objects.requireNonNull(externalCa, "externalCas element"));
            }
            return this;
        }

        @Override
        public ImmutableCaConfig build() {
            return new ImmutableCaConfig(this.nodeCertExpiry, this.externalCas == null ? null : ImmutableCaConfig.createUnmodifiableList(true, this.externalCas));
        }
    }
}

