/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ssh.proxy;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHBase;
import org.eclipse.linuxtools.internal.ssh.proxy.SSHFileStore;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;

public class SSHFileProxy
extends SSHBase
implements IRemoteFileProxy {
    private URI uri;

    public SSHFileProxy(URI uri) {
        super(uri);
        this.uri = uri;
    }

    public URI toURI(IPath path) {
        return this.uri;
    }

    public URI toURI(String path) {
        return this.uri.resolve(path);
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public String getDirectorySeparator() {
        return "/";
    }

    public IFileStore getResource(String path) {
        try {
            URI newUri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), path, this.uri.getQuery(), this.uri.getFragment());
            return new SSHFileStore(newUri, this);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URI getWorkingDir() {
        return this.uri;
    }
}

