/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DevHelpContentProducer
implements IHelpContentProducer {
    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        InputStream stream = null;
        try {
            URI uri = new URI(href);
            if ("html/devhelp.html".equals(uri.getPath())) {
                return null;
            }
            IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
            String[] paths = ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory").split(File.pathSeparator);
            Optional<Path> doc = Stream.of(paths).map(p -> Path.of(p, uri.getPath())).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
            if (doc.isPresent()) {
                stream = Files.newInputStream(doc.get(), new OpenOption[0]);
            }
        }
        catch (IOException | URISyntaxException e) {
            Platform.getLog((Bundle)FrameworkUtil.getBundle(this.getClass())).warn(MessageFormat.format(Messages.DevHelpContentProducer_ContentReadError, href), (Throwable)e);
        }
        return stream;
    }
}

