/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.dataviewers.piechart;

import org.eclipse.linuxtools.internal.dataviewers.piechart.PieChart;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.Range;

public class PieChartPaintListener
implements PaintListener {
    private PieChart chart;
    private Control plotArea;
    private double[][] seriesValues;
    private String[] seriesNames;
    private static final int X_GAP = 10;
    private static final Color WHITE = Display.getDefault().getSystemColor(1);
    private static final Color BLACK = Display.getDefault().getSystemColor(2);
    private static final String FONT = "Arial";
    private Point[] pieCenters;
    private int[][] pieSliceAngles;
    private int pieWidth;
    private String origTitleText;

    public PieChartPaintListener(PieChart chart) {
        this.chart = chart;
        this.plotArea = chart.getPlotArea().getControl();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        this.getPieSeriesArray();
        this.pieCenters = new Point[this.seriesValues.length];
        this.pieSliceAngles = new int[this.seriesValues.length][];
        if (this.seriesValues.length == 0) {
            Rectangle bounds = gc.getClipping();
            Font oldFont = gc.getFont();
            Font font = new Font((Device)Display.getDefault(), FONT, 15, 1);
            gc.setForeground(BLACK);
            gc.setFont(font);
            String text = "No data";
            Point textSize = e.gc.textExtent(text);
            gc.drawText(text, (bounds.width - textSize.x) / 2, (bounds.height - textSize.y) / 2);
            gc.setFont(oldFont);
            font.dispose();
            return;
        }
        Rectangle bounds = this.plotArea.getBounds();
        if (this.origTitleText == null) {
            this.origTitleText = this.chart.getTitle().getText();
        }
        if (this.chart.getTitle() instanceof Control) {
            this.setTitleBounds(bounds);
        } else {
            this.adjustTitle(e);
        }
        int width = bounds.width / this.seriesValues.length;
        int x = bounds.x;
        if (this.chart.getLegend().isVisible()) {
            Rectangle legendBounds = ((Control)this.chart.getLegend()).getBounds();
            Font oldFont = gc.getFont();
            Font font = new Font((Device)Display.getDefault(), FONT, 10, 1);
            gc.setForeground(BLACK);
            gc.setFont(font);
            String text = this.chart.getAxisSet().getXAxis(0).getTitle().getText();
            Point textSize = e.gc.textExtent(text);
            gc.drawText(text, legendBounds.x + (legendBounds.width - textSize.x) / 2, legendBounds.y - textSize.y);
            gc.setFont(oldFont);
            font.dispose();
        }
        this.pieWidth = Math.min(width - 10, bounds.height);
        for (int i = 0; i < this.seriesValues.length; ++i) {
            this.drawPieChart(e, i, new Rectangle(x, bounds.y, width, bounds.height));
            x += width;
        }
    }

    private void setTitleBounds(Rectangle bounds) {
        Control title = (Control)this.chart.getTitle();
        Rectangle titleBounds = title.getBounds();
        title.setLocation(new Point(bounds.x + (bounds.width - titleBounds.width) / 2, title.getLocation().y));
    }

    private void adjustTitle(PaintEvent pe) {
        ITitle title = this.chart.getTitle();
        Font font = title.getFont();
        Font oldFont = pe.gc.getFont();
        pe.gc.setFont(font);
        Control legend = (Control)this.chart.getLegend();
        Rectangle legendBounds = legend.getBounds();
        int adjustment = legendBounds.width - 15;
        Point blankSize = pe.gc.textExtent(" ");
        int numBlanks = adjustment / blankSize.x >> 1 << 1;
        Object text = this.origTitleText;
        for (int i = 0; i < numBlanks; ++i) {
            text = (String)text + " ";
        }
        pe.gc.setFont(oldFont);
        title.setText((String)text);
    }

    private void drawPieChart(PaintEvent e, int chartnum, Rectangle bounds) {
        double[] series = this.seriesValues[chartnum];
        int nelemSeries = series.length;
        double sumTotal = 0.0;
        this.pieSliceAngles[chartnum] = new int[nelemSeries - 1];
        for (int i = 0; i < nelemSeries; ++i) {
            sumTotal += series[i];
        }
        GC gc = e.gc;
        Font oldFont = gc.getFont();
        gc.setLineWidth(1);
        int pieX = bounds.x + (bounds.width - this.pieWidth) / 2;
        int pieY = bounds.y + (bounds.height - this.pieWidth) / 2;
        this.pieCenters[chartnum] = new Point(pieX + this.pieWidth / 2, pieY + this.pieWidth / 2);
        if (sumTotal == 0.0) {
            gc.drawOval(pieX, pieY, this.pieWidth, this.pieWidth);
        } else {
            double factor = 100.0 / sumTotal;
            int sweepAngle = 0;
            int incrementAngle = 0;
            int initialAngle = 90;
            for (int i = 0; i < nelemSeries; ++i) {
                if (i > 0) {
                    this.pieSliceAngles[chartnum][i - 1] = 90 - initialAngle;
                }
                gc.setBackground(((IBarSeries)this.chart.getSeriesSet().getSeries()[i]).getBarColor());
                if (i == nelemSeries - 1) {
                    sweepAngle = 360 - incrementAngle;
                } else {
                    double angle = series[i] * factor * 3.6;
                    sweepAngle = (int)Math.round(angle);
                }
                gc.fillArc(pieX, pieY, this.pieWidth, this.pieWidth, initialAngle, -sweepAngle);
                gc.drawArc(pieX, pieY, this.pieWidth, this.pieWidth, initialAngle, -sweepAngle);
                incrementAngle += sweepAngle;
                initialAngle += -sweepAngle;
            }
            gc.drawLine(this.pieCenters[chartnum].x, this.pieCenters[chartnum].y, this.pieCenters[chartnum].x, this.pieCenters[chartnum].y - this.pieWidth / 2);
        }
        Font font = new Font((Device)Display.getDefault(), FONT, 12, 1);
        gc.setForeground(BLACK);
        gc.setBackground(WHITE);
        gc.setFont(font);
        String text = this.seriesNames[chartnum];
        Point textSize = e.gc.textExtent(text);
        gc.drawText(text, pieX + (this.pieWidth - textSize.x) / 2, pieY + this.pieWidth + textSize.y);
        gc.setFont(oldFont);
        font.dispose();
    }

    private void getPieSeriesArray() {
        ISeries[] series = this.chart.getSeriesSet().getSeries();
        if (series == null || series.length == 0) {
            this.seriesValues = new double[0][0];
            this.seriesNames = new String[0];
            return;
        }
        String[] names = this.chart.getAxisSet().getXAxis(0).getCategorySeries();
        Range range = this.chart.getAxisSet().getXAxis(0).getRange();
        int itemRange = (int)range.upper - (int)range.lower + 1;
        int itemOffset = (int)range.lower;
        this.seriesValues = new double[itemRange][series.length];
        this.seriesNames = new String[itemRange];
        for (int i = 0; i < this.seriesValues.length; ++i) {
            this.seriesNames[i] = names[i + itemOffset];
            for (int j = 0; j < this.seriesValues[i].length; ++j) {
                double[] d = series[j].getXSeries();
                this.seriesValues[i][j] = d != null && d.length > 0 ? d[i + itemOffset] : 0.0;
            }
        }
    }

    public int getSliceIndexFromPosition(int chartnum, int x, int y) {
        Range range = this.chart.getAxisSet().getXAxis(0).getRange();
        if ((chartnum -= (int)range.lower) >= this.pieCenters.length || chartnum < 0) {
            return -1;
        }
        double rad = Math.sqrt(Math.pow(this.pieCenters[chartnum].x - x, 2.0) + Math.pow(this.pieCenters[chartnum].y - y, 2.0));
        if (2.0 * rad > (double)this.pieWidth) {
            return -1;
        }
        double angle = Math.acos((double)(this.pieCenters[chartnum].y - y) / rad) / Math.PI * 180.0;
        if (x - this.pieCenters[chartnum].x < 0) {
            angle = 360.0 - angle;
        }
        if (this.pieSliceAngles[chartnum].length == 0 || angle < (double)this.pieSliceAngles[chartnum][0]) {
            return 0;
        }
        for (int s = 0; s < this.pieSliceAngles[chartnum].length - 1; ++s) {
            if (!((double)this.pieSliceAngles[chartnum][s] <= angle) || !(angle < (double)this.pieSliceAngles[chartnum][s + 1])) continue;
            return s + 1;
        }
        return this.pieSliceAngles[chartnum].length;
    }
}

