
package org.mandas.docker.client.messages;

import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link RegistryAuth}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRegistryAuth.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableRegistryAuth implements RegistryAuth {
  private final @Nullable String username;
  private final @Nullable String password;
  private final @Nullable String email;
  private final @Nullable String serverAddress;
  private final @Nullable String identityToken;
  private transient final RegistryAuth.Builder toBuilder;

  private ImmutableRegistryAuth(
      @Nullable String username,
      @Nullable String password,
      @Nullable String email,
      @Nullable String serverAddress,
      @Nullable String identityToken) {
    this.username = username;
    this.password = password;
    this.email = email;
    this.serverAddress = serverAddress;
    this.identityToken = identityToken;
    this.toBuilder = Objects.requireNonNull(RegistryAuth.super.toBuilder(), "toBuilder");
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public @Nullable String username() {
    return username;
  }

  /**
   * @return The value of the {@code password} attribute
   */
  @Override
  public @Nullable String password() {
    return password;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @Override
  public @Nullable String email() {
    return email;
  }

  /**
   * @return The value of the {@code serverAddress} attribute
   */
  @Override
  public @Nullable String serverAddress() {
    return serverAddress;
  }

  /**
   * @return The value of the {@code identityToken} attribute
   */
  @Override
  public @Nullable String identityToken() {
    return identityToken;
  }

  /**
   * @return The computed-at-construction value of the {@code toBuilder} attribute
   */
  @Override
  public RegistryAuth.Builder toBuilder() {
    return toBuilder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryAuth#username() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for username (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRegistryAuth withUsername(@Nullable String value) {
    if (Objects.equals(this.username, value)) return this;
    return new ImmutableRegistryAuth(value, this.password, this.email, this.serverAddress, this.identityToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryAuth#password() password} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for password (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRegistryAuth withPassword(@Nullable String value) {
    if (Objects.equals(this.password, value)) return this;
    return new ImmutableRegistryAuth(this.username, value, this.email, this.serverAddress, this.identityToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryAuth#email() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRegistryAuth withEmail(@Nullable String value) {
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableRegistryAuth(this.username, this.password, value, this.serverAddress, this.identityToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryAuth#serverAddress() serverAddress} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for serverAddress (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRegistryAuth withServerAddress(@Nullable String value) {
    if (Objects.equals(this.serverAddress, value)) return this;
    return new ImmutableRegistryAuth(this.username, this.password, this.email, value, this.identityToken);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RegistryAuth#identityToken() identityToken} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for identityToken (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableRegistryAuth withIdentityToken(@Nullable String value) {
    if (Objects.equals(this.identityToken, value)) return this;
    return new ImmutableRegistryAuth(this.username, this.password, this.email, this.serverAddress, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRegistryAuth} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRegistryAuth
        && equalsByValue((ImmutableRegistryAuth) another);
  }

  private boolean equalsByValue(ImmutableRegistryAuth another) {
    return Objects.equals(username, another.username)
        && Objects.equals(password, another.password)
        && Objects.equals(email, another.email)
        && Objects.equals(serverAddress, another.serverAddress)
        && Objects.equals(identityToken, another.identityToken);
  }

  /**
   * Computes a hash code from attributes: {@code username}, {@code password}, {@code email}, {@code serverAddress}, {@code identityToken}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(username);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(serverAddress);
    h += (h << 5) + Objects.hashCode(identityToken);
    return h;
  }

  /**
   * Prints the immutable value {@code RegistryAuth} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RegistryAuth{"
        + "username=" + username
        + ", serverAddress=" + serverAddress
        + ", identityToken=" + identityToken
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RegistryAuth} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RegistryAuth instance
   */
  public static ImmutableRegistryAuth copyOf(RegistryAuth instance) {
    if (instance instanceof ImmutableRegistryAuth) {
      return (ImmutableRegistryAuth) instance;
    }
    return ImmutableRegistryAuth.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRegistryAuth ImmutableRegistryAuth}.
   * <pre>
   * ImmutableRegistryAuth.builder()
   *    .username(String | null) // nullable {@link RegistryAuth#username() username}
   *    .password(String | null) // nullable {@link RegistryAuth#password() password}
   *    .email(String | null) // nullable {@link RegistryAuth#email() email}
   *    .serverAddress(String | null) // nullable {@link RegistryAuth#serverAddress() serverAddress}
   *    .identityToken(String | null) // nullable {@link RegistryAuth#identityToken() identityToken}
   *    .build();
   * </pre>
   * @return A new ImmutableRegistryAuth builder
   */
  public static ImmutableRegistryAuth.Builder builder() {
    return new ImmutableRegistryAuth.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRegistryAuth ImmutableRegistryAuth}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements RegistryAuth.Builder {
    private String username;
    private String password;
    private String email;
    private String serverAddress;
    private String identityToken;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RegistryAuth} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RegistryAuth instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String usernameValue = instance.username();
      if (usernameValue != null) {
        username(usernameValue);
      }
      @Nullable String passwordValue = instance.password();
      if (passwordValue != null) {
        password(passwordValue);
      }
      @Nullable String emailValue = instance.email();
      if (emailValue != null) {
        email(emailValue);
      }
      @Nullable String serverAddressValue = instance.serverAddress();
      if (serverAddressValue != null) {
        serverAddress(serverAddressValue);
      }
      @Nullable String identityTokenValue = instance.identityToken();
      if (identityTokenValue != null) {
        identityToken(identityTokenValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RegistryAuth#username() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the value for the {@link RegistryAuth#password() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link RegistryAuth#email() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the value for the {@link RegistryAuth#serverAddress() serverAddress} attribute.
     * @param serverAddress The value for serverAddress (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serverAddress(@Nullable String serverAddress) {
      this.serverAddress = serverAddress;
      return this;
    }

    /**
     * Initializes the value for the {@link RegistryAuth#identityToken() identityToken} attribute.
     * @param identityToken The value for identityToken (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityToken(@Nullable String identityToken) {
      this.identityToken = identityToken;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRegistryAuth ImmutableRegistryAuth}.
     * @return An immutable instance of RegistryAuth
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRegistryAuth build() {
      return new ImmutableRegistryAuth(username, password, email, serverAddress, identityToken);
    }
  }
}
