/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.npipe;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.mandas.docker.client.npipe.NamedPipeSocket;
import org.mandas.docker.client.npipe.NpipeSocketAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class NpipeConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public NpipeConnectionSocketFactory(URI socketUri) {
        String filename = socketUri.toString().replaceAll("^npipe:///", "npipe://localhost/").replaceAll("^npipe://localhost", "");
        this.socketFile = new File(filename);
    }

    public static URI sanitizeUri(URI uri) {
        if (uri.getScheme().equals("npipe")) {
            return URI.create("npipe://localhost:80");
        }
        return uri;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return new NamedPipeSocket();
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        if (!(socket instanceof NamedPipeSocket)) {
            throw new AssertionError((Object)("Unexpected socket: " + String.valueOf(socket)));
        }
        socket.connect(new NpipeSocketAddress(this.socketFile), connectTimeout);
        return socket;
    }
}

