/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.Driver;
import org.mandas.docker.client.messages.swarm.IpamOptions;
import org.mandas.docker.client.messages.swarm.Network;
import org.mandas.docker.client.messages.swarm.NetworkSpec;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableNetwork
implements Network {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final NetworkSpec spec;
    private final Driver driverState;
    private final IpamOptions ipamOptions;

    private ImmutableNetwork(String id, Version version, Date createdAt, Date updatedAt, NetworkSpec spec, Driver driverState, IpamOptions ipamOptions) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.spec = spec;
        this.driverState = driverState;
        this.ipamOptions = ipamOptions;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public NetworkSpec spec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="DriverState")
    public Driver driverState() {
        return this.driverState;
    }

    @Override
    @JsonProperty(value="IPAMOptions")
    public IpamOptions ipamOptions() {
        return this.ipamOptions;
    }

    public final ImmutableNetwork withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNetwork(newValue, this.version, this.createdAt, this.updatedAt, this.spec, this.driverState, this.ipamOptions);
    }

    public final ImmutableNetwork withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableNetwork(this.id, newValue, this.createdAt, this.updatedAt, this.spec, this.driverState, this.ipamOptions);
    }

    public final ImmutableNetwork withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableNetwork(this.id, this.version, newValue, this.updatedAt, this.spec, this.driverState, this.ipamOptions);
    }

    public final ImmutableNetwork withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableNetwork(this.id, this.version, this.createdAt, newValue, this.spec, this.driverState, this.ipamOptions);
    }

    public final ImmutableNetwork withSpec(NetworkSpec value) {
        if (this.spec == value) {
            return this;
        }
        NetworkSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableNetwork(this.id, this.version, this.createdAt, this.updatedAt, newValue, this.driverState, this.ipamOptions);
    }

    public final ImmutableNetwork withDriverState(Driver value) {
        if (this.driverState == value) {
            return this;
        }
        Driver newValue = Objects.requireNonNull(value, "driverState");
        return new ImmutableNetwork(this.id, this.version, this.createdAt, this.updatedAt, this.spec, newValue, this.ipamOptions);
    }

    public final ImmutableNetwork withIpamOptions(IpamOptions value) {
        if (this.ipamOptions == value) {
            return this;
        }
        IpamOptions newValue = Objects.requireNonNull(value, "ipamOptions");
        return new ImmutableNetwork(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.driverState, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetwork && this.equalTo(0, (ImmutableNetwork)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetwork another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.spec.equals(another.spec) && this.driverState.equals(another.driverState) && this.ipamOptions.equals(another.ipamOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.driverState.hashCode();
        h += (h << 5) + this.ipamOptions.hashCode();
        return h;
    }

    public String toString() {
        return "Network{id=" + this.id + ", version=" + String.valueOf(this.version) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", spec=" + String.valueOf(this.spec) + ", driverState=" + String.valueOf(this.driverState) + ", ipamOptions=" + String.valueOf(this.ipamOptions) + "}";
    }

    public static ImmutableNetwork copyOf(Network instance) {
        if (instance instanceof ImmutableNetwork) {
            return (ImmutableNetwork)instance;
        }
        return ImmutableNetwork.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SPEC = 16L;
        private static final long INIT_BIT_DRIVER_STATE = 32L;
        private static final long INIT_BIT_IPAM_OPTIONS = 64L;
        private long initBits = 127L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private NetworkSpec spec;
        private Driver driverState;
        private IpamOptions ipamOptions;

        private Builder() {
        }

        public final Builder from(Network instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.spec(instance.spec());
            this.driverState(instance.driverState());
            this.ipamOptions(instance.ipamOptions());
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder spec(NetworkSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="DriverState")
        public final Builder driverState(Driver driverState) {
            this.driverState = Objects.requireNonNull(driverState, "driverState");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="IPAMOptions")
        public final Builder ipamOptions(IpamOptions ipamOptions) {
            this.ipamOptions = Objects.requireNonNull(ipamOptions, "ipamOptions");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableNetwork build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetwork(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.driverState, this.ipamOptions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("driverState");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("ipamOptions");
            }
            return "Cannot build Network, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

