/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ManagerStatus;

final class ImmutableManagerStatus
implements ManagerStatus {
    @Nullable
    private final Boolean leader;
    private final String reachability;
    private final String addr;

    private ImmutableManagerStatus(@Nullable Boolean leader, String reachability, String addr) {
        this.leader = leader;
        this.reachability = reachability;
        this.addr = addr;
    }

    @Override
    @JsonProperty(value="Leader")
    @Nullable
    public Boolean leader() {
        return this.leader;
    }

    @Override
    @JsonProperty(value="Reachability")
    public String reachability() {
        return this.reachability;
    }

    @Override
    @JsonProperty(value="Addr")
    public String addr() {
        return this.addr;
    }

    public final ImmutableManagerStatus withLeader(@Nullable Boolean value) {
        if (Objects.equals(this.leader, value)) {
            return this;
        }
        return new ImmutableManagerStatus(value, this.reachability, this.addr);
    }

    public final ImmutableManagerStatus withReachability(String value) {
        String newValue = Objects.requireNonNull(value, "reachability");
        if (this.reachability.equals(newValue)) {
            return this;
        }
        return new ImmutableManagerStatus(this.leader, newValue, this.addr);
    }

    public final ImmutableManagerStatus withAddr(String value) {
        String newValue = Objects.requireNonNull(value, "addr");
        if (this.addr.equals(newValue)) {
            return this;
        }
        return new ImmutableManagerStatus(this.leader, this.reachability, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableManagerStatus && this.equalTo(0, (ImmutableManagerStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableManagerStatus another) {
        return Objects.equals(this.leader, another.leader) && this.reachability.equals(another.reachability) && this.addr.equals(another.addr);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.leader);
        h += (h << 5) + this.reachability.hashCode();
        h += (h << 5) + this.addr.hashCode();
        return h;
    }

    public String toString() {
        return "ManagerStatus{leader=" + this.leader + ", reachability=" + this.reachability + ", addr=" + this.addr + "}";
    }

    public static ImmutableManagerStatus copyOf(ManagerStatus instance) {
        if (instance instanceof ImmutableManagerStatus) {
            return (ImmutableManagerStatus)instance;
        }
        return ImmutableManagerStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_REACHABILITY = 1L;
        private static final long INIT_BIT_ADDR = 2L;
        private long initBits = 3L;
        private Boolean leader;
        private String reachability;
        private String addr;

        private Builder() {
        }

        public final Builder from(ManagerStatus instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean leaderValue = instance.leader();
            if (leaderValue != null) {
                this.leader(leaderValue);
            }
            this.reachability(instance.reachability());
            this.addr(instance.addr());
            return this;
        }

        @JsonProperty(value="Leader")
        public final Builder leader(@Nullable Boolean leader) {
            this.leader = leader;
            return this;
        }

        @JsonProperty(value="Reachability")
        public final Builder reachability(String reachability) {
            this.reachability = Objects.requireNonNull(reachability, "reachability");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Addr")
        public final Builder addr(String addr) {
            this.addr = Objects.requireNonNull(addr, "addr");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableManagerStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableManagerStatus(this.leader, this.reachability, this.addr);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reachability");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("addr");
            }
            return "Cannot build ManagerStatus, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

